/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.introspection.java;

import org.eclipse.epsilon.emc.simulink.engine.MatlabEngine;
import org.eclipse.epsilon.emc.simulink.model.element.SimulinkElement;
import org.eclipse.epsilon.emc.simulink.model.element.SimulinkModelElement;
import org.eclipse.epsilon.emc.simulink.model.element.StateflowBlock;
import org.eclipse.epsilon.emc.simulink.types.Struct;
import org.eclipse.epsilon.eol.exceptions.EolIllegalPropertyException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.introspection.java.JavaPropertyGetter;

public class SimulinkPropertyGetter
extends JavaPropertyGetter {
    private static final String TYPE = "type";
    protected MatlabEngine engine;

    public boolean hasProperty(Object object, String property) {
        if (object instanceof Struct) {
            return ((Struct)object).containsKey(property);
        }
        return super.hasProperty(object, property);
    }

    public Object invoke(Object object, String property) throws EolRuntimeException {
        try {
            return super.invoke(object, property);
        }
        catch (Exception e) {
            SimulinkModelElement element;
            if (object instanceof SimulinkModelElement && (element = (SimulinkModelElement)object) instanceof SimulinkModelElement) {
                if (property.equalsIgnoreCase(TYPE)) {
                    return element.getType();
                }
                try {
                    if (element instanceof StateflowBlock) {
                        return ((StateflowBlock)element).getProperty(property);
                    }
                    if (element instanceof SimulinkElement) {
                        return ((SimulinkElement)element).getProperty(property);
                    }
                }
                catch (EolIllegalPropertyException me) {
                    throw new EolRuntimeException(me.getMessage());
                }
            }
            if (object instanceof Struct) {
                return ((Struct)object).get(property);
            }
            throw new EolRuntimeException(e.getMessage());
        }
    }
}

