/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.discovery;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.DiscoveryFilter;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.discovery.ClassNameFilter;
import org.junit.platform.engine.discovery.PackageNameFilter;
import org.junit.platform.engine.support.discovery.ClassContainerSelectorResolver;
import org.junit.platform.engine.support.discovery.EngineDiscoveryRequestResolution;
import org.junit.platform.engine.support.discovery.SelectorResolver;

@API(status=API.Status.STABLE, since="1.10")
public class EngineDiscoveryRequestResolver<T extends TestDescriptor> {
    private final List<Function<InitializationContext<T>, SelectorResolver>> resolverCreators;
    private final List<Function<InitializationContext<T>, TestDescriptor.Visitor>> visitorCreators;

    private EngineDiscoveryRequestResolver(List<Function<InitializationContext<T>, SelectorResolver>> resolverCreators, List<Function<InitializationContext<T>, TestDescriptor.Visitor>> visitorCreators) {
        this.resolverCreators = new ArrayList<Function<InitializationContext<T>, SelectorResolver>>(resolverCreators);
        this.visitorCreators = new ArrayList<Function<InitializationContext<T>, TestDescriptor.Visitor>>(visitorCreators);
    }

    public void resolve(EngineDiscoveryRequest request, T engineDescriptor) {
        Preconditions.notNull(request, "request must not be null");
        Preconditions.notNull(engineDescriptor, "engineDescriptor must not be null");
        DefaultInitializationContext<T> initializationContext = new DefaultInitializationContext<T>(request, engineDescriptor);
        List<SelectorResolver> resolvers = this.instantiate(this.resolverCreators, initializationContext);
        List<TestDescriptor.Visitor> visitors = this.instantiate(this.visitorCreators, initializationContext);
        new EngineDiscoveryRequestResolution(request, (TestDescriptor)engineDescriptor, resolvers, visitors).run();
    }

    private <R> List<R> instantiate(List<Function<InitializationContext<T>, R>> creators, InitializationContext<T> context2) {
        return creators.stream().map(creator -> creator.apply(context2)).collect(Collectors.toCollection(ArrayList::new));
    }

    public static <T extends TestDescriptor> Builder<T> builder() {
        return new Builder();
    }

    private static class DefaultInitializationContext<T extends TestDescriptor>
    implements InitializationContext<T> {
        private final EngineDiscoveryRequest request;
        private final T engineDescriptor;
        private final Predicate<String> classNameFilter;

        DefaultInitializationContext(EngineDiscoveryRequest request, T engineDescriptor) {
            this.request = request;
            this.engineDescriptor = engineDescriptor;
            this.classNameFilter = this.buildClassNamePredicate(request);
        }

        private Predicate<String> buildClassNamePredicate(EngineDiscoveryRequest request) {
            ArrayList<DiscoveryFilter<String>> filters = new ArrayList<DiscoveryFilter<String>>();
            filters.addAll(request.getFiltersByType(ClassNameFilter.class));
            filters.addAll(request.getFiltersByType(PackageNameFilter.class));
            return Filter.composeFilters(filters).toPredicate();
        }

        @Override
        public EngineDiscoveryRequest getDiscoveryRequest() {
            return this.request;
        }

        @Override
        public T getEngineDescriptor() {
            return this.engineDescriptor;
        }

        @Override
        public Predicate<String> getClassNameFilter() {
            return this.classNameFilter;
        }
    }

    @API(status=API.Status.STABLE, since="1.10")
    public static interface InitializationContext<T extends TestDescriptor> {
        public EngineDiscoveryRequest getDiscoveryRequest();

        public T getEngineDescriptor();

        public Predicate<String> getClassNameFilter();
    }

    @API(status=API.Status.STABLE, since="1.10")
    public static class Builder<T extends TestDescriptor> {
        private final List<Function<InitializationContext<T>, SelectorResolver>> resolverCreators = new ArrayList<Function<InitializationContext<T>, SelectorResolver>>();
        private final List<Function<InitializationContext<T>, TestDescriptor.Visitor>> visitorCreators = new ArrayList<Function<InitializationContext<T>, TestDescriptor.Visitor>>();

        private Builder() {
        }

        public Builder<T> addClassContainerSelectorResolver(Predicate<Class<?>> classFilter) {
            Preconditions.notNull(classFilter, "classFilter must not be null");
            return this.addSelectorResolver((InitializationContext<T> context2) -> new ClassContainerSelectorResolver(classFilter, context2.getClassNameFilter()));
        }

        public Builder<T> addSelectorResolver(SelectorResolver resolver) {
            Preconditions.notNull(resolver, "resolver must not be null");
            return this.addSelectorResolver((InitializationContext<T> context2) -> resolver);
        }

        public Builder<T> addSelectorResolver(Function<InitializationContext<T>, SelectorResolver> resolverCreator) {
            this.resolverCreators.add(resolverCreator);
            return this;
        }

        public Builder<T> addTestDescriptorVisitor(Function<InitializationContext<T>, TestDescriptor.Visitor> visitorCreator) {
            this.visitorCreators.add(visitorCreator);
            return this;
        }

        public EngineDiscoveryRequestResolver<T> build() {
            return new EngineDiscoveryRequestResolver(this.resolverCreators, this.visitorCreators);
        }
    }
}

