/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi;

import java.util.stream.Stream;
import org.apache.jena.graph.Graph;
import org.apache.jena.shared.AlreadyExistsException;
import org.apache.jena.shared.DoesNotExistException;

public interface GraphMaker {
    public Graph createGraph(String var1) throws AlreadyExistsException;

    public Graph openGraph(String var1) throws DoesNotExistException;

    public void removeGraph(String var1) throws DoesNotExistException;

    public boolean hasGraph(String var1);

    public Stream<String> names();

    public void close();

    default public Graph getGraphOrNull(String name) {
        try {
            return this.openGraph(name);
        }
        catch (DoesNotExistException e2) {
            return null;
        }
    }

    default public Stream<Graph> graphs() {
        return this.names().map(this::openGraph);
    }
}

