/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.util.NodeUtils;

public enum ValueSpace {
    VSPACE_UNDEF(10),
    VSPACE_BLANKNODE(12),
    VSPACE_URI(13),
    VSPACE_VARIABLE(14),
    VSPACE_STRING(50),
    VSPACE_LANG(55),
    VSPACE_NUM(110),
    VSPACE_BOOLEAN(120),
    VSPACE_DATETIME(130),
    VSPACE_DATE(131),
    VSPACE_TIME(135),
    VSPACE_DURATION(160),
    VSPACE_SORTKEY(900),
    VSPACE_QUOTED_TRIPLE(999),
    VSPACE_UNKNOWN(6000),
    VSPACE_DIFFERENT(9999);

    private final int comparisonOrder;

    private ValueSpace(int orderIndex) {
        this.comparisonOrder = orderIndex;
    }

    public int comparisonOrder() {
        return this.comparisonOrder;
    }

    public static int comparisonOrder(ValueSpace vs1, ValueSpace vs2) {
        if (vs1 == VSPACE_UNKNOWN && vs2 != VSPACE_UNKNOWN) {
            return 2;
        }
        return Integer.compare(vs1.comparisonOrder, vs2.comparisonOrder);
    }

    public static ValueSpace valueSpace(NodeValue nv) {
        if (nv == null) {
            return VSPACE_UNDEF;
        }
        if (nv.isNumber()) {
            return VSPACE_NUM;
        }
        if (nv.isDateTime()) {
            return VSPACE_DATETIME;
        }
        if (nv.isString()) {
            return VSPACE_STRING;
        }
        if (nv.isLangString()) {
            return VSPACE_LANG;
        }
        if (nv.isBoolean()) {
            return VSPACE_BOOLEAN;
        }
        if (!SystemARQ.ValueExtensions) {
            return VSPACE_UNKNOWN;
        }
        if (nv.isDate()) {
            return VSPACE_DATE;
        }
        if (nv.isTime()) {
            return VSPACE_TIME;
        }
        if (nv.isGYear()) {
            return VSPACE_DATETIME;
        }
        if (nv.isGYearMonth()) {
            return VSPACE_DATETIME;
        }
        if (nv.isGMonth()) {
            return VSPACE_DATETIME;
        }
        if (nv.isGMonthDay()) {
            return VSPACE_DATETIME;
        }
        if (nv.isGDay()) {
            return VSPACE_DATETIME;
        }
        if (nv.isDuration()) {
            return VSPACE_DURATION;
        }
        if (nv.isSortKey()) {
            return VSPACE_SORTKEY;
        }
        if (nv.isBlank()) {
            return VSPACE_BLANKNODE;
        }
        if (nv.isIRI()) {
            return VSPACE_URI;
        }
        if (nv.isVariable()) {
            return VSPACE_VARIABLE;
        }
        if (nv.isTripleTerm()) {
            return VSPACE_QUOTED_TRIPLE;
        }
        if (NodeUtils.hasLang(nv.asNode())) {
            return VSPACE_LANG;
        }
        return VSPACE_UNKNOWN;
    }
}

