/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dap.variables.maps;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.epsilon.eol.dap.variables.IVariableReference;
import org.eclipse.epsilon.eol.dap.variables.IdentifiableReference;
import org.eclipse.epsilon.eol.dap.variables.SuspendedState;
import org.eclipse.epsilon.eol.dap.variables.maps.MapSliceReference;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.types.EolMapType;

public class SlicedMapReference
extends IdentifiableReference<Map<Object, Object>> {
    private final int sliceSize;
    private final String name;

    public SlicedMapReference(IEolContext context, String name, Map<Object, Object> m, int sliceSize) {
        super(context, m);
        this.sliceSize = sliceSize;
        this.name = name;
    }

    @Override
    public String getTypeName() {
        return new EolMapType().getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return String.format("<sliced map of %d elements>", ((Map)this.target).size());
    }

    @Override
    public List<IVariableReference> getVariables(SuspendedState state) {
        ArrayList<IVariableReference> refs = new ArrayList<IVariableReference>(((Map)this.target).size() / this.sliceSize + 1);
        int from = 0;
        while (from < ((Map)this.target).size()) {
            int to = Math.min(((Map)this.target).size(), from + this.sliceSize);
            refs.add(state.putOrGetReference(new MapSliceReference(this.context, this.name, (Map)this.target, from, to)));
            from += this.sliceSize;
        }
        return refs;
    }
}

