/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.test.persistence;

import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.client.test.common.cases.ESTestWithSharedProject;
import org.eclipse.emf.emfstore.client.test.common.dsl.Add;
import org.eclipse.emf.emfstore.client.test.common.dsl.Create;
import org.eclipse.emf.emfstore.client.test.common.util.ProjectUtil;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.emf.emfstore.test.model.TestElement;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ProjectLastUpdatedTest
extends ESTestWithSharedProject {
    private ESLocalProject clonedProject;

    @BeforeClass
    public static void beforeClass() {
        ProjectLastUpdatedTest.startEMFStore();
    }

    @AfterClass
    public static void afterClass() {
        ProjectLastUpdatedTest.stopEMFStore();
    }

    @Before
    public void before() {
        super.before();
        TestElement testElement = Create.testElement();
        Add.toProject((ESLocalProject)this.getLocalProject(), (EObject)testElement);
        try {
            this.clonedProject = this.getLocalProject().getRemoteProject().checkout("Copy", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ESException ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void lastUpdatedIsSetAfterCheckout() {
        Assert.assertNotNull((Object)this.clonedProject.getLastUpdated());
    }

    @Test
    public void lastUpdatedDidChange() throws ESException {
        Add.toProject((ESLocalProject)this.getLocalProject(), (EObject)Create.testElement());
        ProjectUtil.commit((ESLocalProject)this.getLocalProject());
        Date before = this.clonedProject.getLastUpdated();
        this.clonedProject.update((IProgressMonitor)new NullProgressMonitor());
        Date after = this.clonedProject.getLastUpdated();
        Assert.assertNotEquals((Object)before, (Object)after);
    }
}

