/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.views.changes;

import java.util.List;
import org.eclipse.emf.emfstore.internal.client.ui.views.changes.ChangePackageVisualizationHelper;
import org.eclipse.emf.emfstore.internal.client.ui.views.changes.Messages;
import org.eclipse.emf.emfstore.internal.client.ui.views.scm.SCMContentProvider;
import org.eclipse.emf.emfstore.internal.client.ui.views.scm.SCMLabelProvider;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementIdToEObjectMapping;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.server.model.versioning.AbstractChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabbedChangesComposite
extends Composite {
    private TabFolder folder;
    private Composite tabComposite;
    private TreeViewer tabTreeViewer;
    private SCMContentProvider contentProvider;
    private SCMLabelProvider labelProvider;

    public TabbedChangesComposite(Composite parent, int style, List<AbstractChangePackage> changePackages, Project project, ModelElementIdToEObjectMapping idToEObjectMapping, boolean showRootNodes) {
        super(parent, style);
        this.createComposite(style, project, idToEObjectMapping, showRootNodes);
        this.tabTreeViewer.setInput(changePackages);
    }

    public TabbedChangesComposite(Composite parent, int style, Project project, List<AbstractOperation> operations, ModelElementIdToEObjectMapping idToEObjectMapping, boolean showRootNodes) {
        super(parent, style);
        this.createComposite(style, project, idToEObjectMapping, showRootNodes);
        this.tabTreeViewer.setInput(operations);
    }

    private void createComposite(int style, Project project, ModelElementIdToEObjectMapping idToEObjectMapping, boolean showRootNodes) {
        this.setLayout((Layout)new GridLayout());
        this.folder = new TabFolder((Composite)this, style);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.folder);
        this.tabComposite = new Composite((Composite)this.folder, 0);
        GridLayoutFactory.fillDefaults().applyTo(this.tabComposite);
        this.tabTreeViewer = new TreeViewer(this.tabComposite, 768);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.tabTreeViewer.getControl());
        this.contentProvider = new SCMContentProvider(idToEObjectMapping);
        this.contentProvider.setShowRootNodes(showRootNodes);
        this.labelProvider = new SCMLabelProvider(project);
        this.labelProvider.setChangePackageVisualizationHelper(new ChangePackageVisualizationHelper(idToEObjectMapping));
        this.tabTreeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.tabTreeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.tabTreeViewer.expandToLevel(1);
        TabItem opTab = new TabItem(this.folder, style);
        opTab.setText(Messages.TabbedChangesComposite_OperationsText);
        opTab.setControl((Control)this.tabComposite);
    }

    public void dispose() {
        this.contentProvider.dispose();
        this.labelProvider.dispose();
    }
}

