/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.startup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.FeatureNotFoundException;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.SerializationException;
import org.eclipse.emf.emfstore.internal.server.exceptions.FatalESException;
import org.eclipse.emf.emfstore.internal.server.model.ProjectHistory;
import org.eclipse.emf.emfstore.internal.server.model.ServerSpace;
import org.eclipse.emf.emfstore.internal.server.model.versioning.Version;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.CompositeOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmfStoreValidator {
    private final ServerSpace serverSpace;
    private List<String> excludedProjects;
    public static final int RESOLVEALL = 1;
    public static final int MODELELEMENTID = 2;
    public static final int PROJECTGENERATION = 4;
    private long timeMillis;

    public EmfStoreValidator(ServerSpace serverSpace) {
        this.serverSpace = serverSpace;
        this.excludedProjects = new ArrayList<String>();
    }

    public void validate(int options, boolean throwException) throws FatalESException {
        boolean errors = true;
        if ((options & 1) == 1) {
            boolean bl = errors = this.validateResolveAll() && errors;
        }
        if ((options & 2) == 2) {
            boolean bl = errors = this.validateModelelementId() && errors;
        }
        if (!errors && throwException) {
            throw new FatalESException("Validation failed.");
        }
    }

    public void validate(int options) throws FatalESException {
        this.validate(options, true);
    }

    private boolean validateResolveAll() {
        this.start("Resolving all elements...");
        EcoreUtil.resolveAll((ResourceSet)this.serverSpace.eResource().getResourceSet());
        BasicEList errors = new BasicEList();
        EList resources = this.serverSpace.eResource().getResourceSet().getResources();
        for (Resource currentResource : resources) {
            errors.addAll((Collection)currentResource.getErrors());
        }
        this.removeAcceptedErrors((EList<Resource.Diagnostic>)errors);
        this.errors((Collection<? extends Object>)errors);
        this.stop();
        return errors.size() == 0;
    }

    private void removeAcceptedErrors(EList<Resource.Diagnostic> errors) {
        Iterator iterator = errors.iterator();
        while (iterator.hasNext()) {
            FeatureNotFoundException featureNotFoundException;
            Resource.Diagnostic diagnostic = (Resource.Diagnostic)iterator.next();
            if (!(diagnostic instanceof FeatureNotFoundException) || !((featureNotFoundException = (FeatureNotFoundException)diagnostic).getObject() instanceof Version) || !featureNotFoundException.getName().equals("projectState") && !featureNotFoundException.getName().equals("changes")) continue;
            iterator.remove();
        }
    }

    private boolean validateModelelementId() {
        this.start("Checking ModelElementIds...");
        ArrayList<String> errors = new ArrayList<String>();
        for (ProjectHistory projectHistory : this.serverSpace.getProjects()) {
            if (this.isExcluded(projectHistory)) continue;
            System.out.println("Checking project: " + projectHistory.getProjectId().getId());
            for (Version version : projectHistory.getVersions()) {
                if (version.getChanges() != null) {
                    for (AbstractOperation ao : version.getChanges().getOperations()) {
                        if (ao instanceof CompositeOperation || ao.getModelElementId() != null && ao.getModelElementId().getId() != null) continue;
                        errors.add("ChangeOperation has no ModelElementId in project: " + projectHistory.getProjectId() + " version: " + version.getPrimarySpec().getIdentifier());
                    }
                }
                if (version.getProjectState() == null) continue;
                for (EObject me : version.getProjectState().getAllModelElements()) {
                    ModelElementId modelElementId = ModelUtil.getProject((EObject)me).getModelElementId(me);
                    if (modelElementId != null && modelElementId.getId() != null) continue;
                    errors.add("ModelElement has no ModelElementId in project: " + projectHistory.getProjectId() + " version: " + version.getPrimarySpec().getIdentifier());
                }
            }
        }
        this.errors(errors);
        this.stop();
        return errors.size() == 0;
    }

    private boolean validateProjectGeneration() {
        this.start("Project generation compare ...");
        ArrayList<String> errors = new ArrayList<String>();
        for (ProjectHistory history : this.serverSpace.getProjects()) {
            if (this.isExcluded(history)) continue;
            System.out.println("Checking project: " + history.getProjectId().getId());
            Project state = null;
            for (Version version : history.getVersions()) {
                if (version.getProjectState() != null && state == null) {
                    state = (Project)ModelUtil.clone((EObject)version.getProjectState());
                    continue;
                }
                version.getChanges().apply(state, true);
                if (version.getProjectState() == null) continue;
                int[] compare = EmfStoreValidator.linearCompare(version.getProjectState(), state);
                if (compare[0] == 0) {
                    errors.add("project compare of project " + history.getProjectId().getId() + " not equal in version " + version.getPrimarySpec().getIdentifier());
                }
                state = (Project)ModelUtil.clone((EObject)version.getProjectState());
            }
        }
        this.errors(errors);
        this.stop();
        return errors.size() == 0;
    }

    public void setExcludedProjects(List<String> excludedProjects) {
        if (excludedProjects != null) {
            this.excludedProjects = excludedProjects;
        }
    }

    private boolean isExcluded(ProjectHistory projectHistory) {
        return this.excludedProjects.contains(projectHistory.getProjectId().getId());
    }

    private void start(String str) {
        this.timeMillis = System.currentTimeMillis();
        System.out.println("Validation: " + str);
    }

    private void stop() {
        System.out.println("Validation took: " + (System.currentTimeMillis() - this.timeMillis) + " ms\n");
    }

    private void errors(Collection<? extends Object> errorList) {
        System.out.println("Errors: " + errorList.size());
        for (Object object : errorList) {
            System.out.println(object);
        }
    }

    private static int[] linearCompare(Project projectA, Project projectB) {
        int[] result = new int[5];
        result[0] = 1;
        String stringA = "";
        String stringB = "";
        try {
            stringA = ModelUtil.eObjectToString((EObject)projectA);
            stringB = ModelUtil.eObjectToString((EObject)projectB);
        }
        catch (SerializationException e) {
            ModelUtil.logException((Throwable)e);
            result[0] = 0;
            return result;
        }
        int length = Math.min(stringA.length(), stringB.length());
        int index = 0;
        while (index < length) {
            if (stringA.charAt(index) != stringB.charAt(index)) {
                int lineNumber;
                result[0] = 0;
                result[1] = index;
                result[2] = stringA.charAt(index);
                result[3] = lineNumber = EmfStoreValidator.getLineNum(stringA, index);
                result[4] = EmfStoreValidator.getColNum(stringA, index);
                break;
            }
            ++index;
        }
        return result;
    }

    private static int getColNum(String stringA, int index) {
        int pos = index;
        int j = 0;
        int i = 0;
        while (i < index) {
            ++j;
            if (stringA.charAt(i) == '\n') {
                pos -= j;
                j = 0;
            }
            ++i;
        }
        return pos;
    }

    private static int getLineNum(String stringA, int index) {
        int lineNum = 1;
        int i = 0;
        while (i < index) {
            if (stringA.charAt(i) == '\n') {
                ++lineNum;
            }
            ++i;
        }
        return lineNum;
    }
}

