/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.conflictDetection;

import java.util.Set;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ConflictBucketCandidate;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ExistenceOppositeReservationMap;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.FeatureNameReservationMap;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ModelElementIdReservationMap;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.OppositeReservationMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReservationSet {
    private final ModelElementIdReservationMap modelElementIdReservationMap = new ModelElementIdReservationMap();

    public void addFullReservation(String modelElementId) {
        this.addFullReservation(modelElementId, null);
    }

    public void addExistenceReservation(String modelElementId) {
        this.addExistenceReservation(modelElementId, null);
    }

    public void addContainerReservation(String modelElementId) {
        this.addFeatureReservation(modelElementId, "+container");
    }

    public void addFeatureReservation(String modelElementId, String featureName) {
        this.addFeatureReservation(modelElementId, featureName, null);
    }

    public void addMultiReferenceWithOppositeReservation(String modelElementId, String featureName, String oppositeModelElementId) {
        this.addMultiReferenceWithOppositeReservation(modelElementId, featureName, oppositeModelElementId, null);
    }

    public void addMapKeyReservation(String modelElementId, String featureName, String key) {
        this.addMultiReferenceWithOppositeReservation(modelElementId, featureName, key);
    }

    public void addFullReservation(String modelElementId, ConflictBucketCandidate conflictBucketCandidate) {
        FeatureNameReservationMap featureNameReservationMap = new FeatureNameReservationMap(true);
        featureNameReservationMap.setConflictBucketCandidate(conflictBucketCandidate);
        this.modelElementIdReservationMap.put(modelElementId, featureNameReservationMap);
    }

    public void addExistenceReservation(String modelElementId, ConflictBucketCandidate conflictBucketCandidate) {
        ExistenceOppositeReservationMap existenceOppositeReservationMap;
        FeatureNameReservationMap featureNameReservationMap = (FeatureNameReservationMap)this.modelElementIdReservationMap.get(modelElementId);
        if (featureNameReservationMap == null) {
            featureNameReservationMap = new FeatureNameReservationMap();
            this.modelElementIdReservationMap.put(modelElementId, featureNameReservationMap);
        }
        if (!featureNameReservationMap.hasExistenceFeature()) {
            existenceOppositeReservationMap = new ExistenceOppositeReservationMap();
            featureNameReservationMap.put("+existence", existenceOppositeReservationMap);
        } else {
            existenceOppositeReservationMap = (ExistenceOppositeReservationMap)featureNameReservationMap.get("+existence");
        }
        existenceOppositeReservationMap.addConflictBucketCandidate(conflictBucketCandidate);
    }

    public void addFeatureReservation(String modelElementId, String featureName, ConflictBucketCandidate conflictBucketCandidate) {
        OppositeReservationMap oppositeReservationMap;
        if (featureName == "+existence") {
            this.addExistenceReservation(modelElementId);
            return;
        }
        FeatureNameReservationMap featureNameReservationMap = (FeatureNameReservationMap)this.modelElementIdReservationMap.get(modelElementId);
        if (featureNameReservationMap == null) {
            featureNameReservationMap = new FeatureNameReservationMap();
            this.modelElementIdReservationMap.put(modelElementId, featureNameReservationMap);
        }
        if (!featureNameReservationMap.containsKey(featureName)) {
            oppositeReservationMap = new OppositeReservationMap(false);
            featureNameReservationMap.put(featureName, oppositeReservationMap);
        } else {
            oppositeReservationMap = (OppositeReservationMap)featureNameReservationMap.get(featureName);
        }
        oppositeReservationMap.setConflictBucketCandidate(conflictBucketCandidate);
        if (oppositeReservationMap.hasOpposites()) {
            throw new IllegalStateException("Reservation on same feature with AND without opposites is illegal!");
        }
    }

    public void addMultiReferenceWithOppositeReservation(String modelElementID, String featureName, String oppositeModelElementId, ConflictBucketCandidate conflictBucketCandidate) {
        OppositeReservationMap oppositeReservationMap;
        FeatureNameReservationMap featureNameReservationMap = (FeatureNameReservationMap)this.modelElementIdReservationMap.get(modelElementID);
        if (featureNameReservationMap == null) {
            featureNameReservationMap = new FeatureNameReservationMap();
            this.modelElementIdReservationMap.put(modelElementID, featureNameReservationMap);
        }
        if (!featureNameReservationMap.containsKey(featureName)) {
            oppositeReservationMap = new OppositeReservationMap(true);
            featureNameReservationMap.put(featureName, oppositeReservationMap);
        } else {
            oppositeReservationMap = (OppositeReservationMap)featureNameReservationMap.get(featureName);
        }
        if (!oppositeReservationMap.hasOpposites()) {
            throw new IllegalStateException("Reservation on same feature with AND without opposites is illegal!");
        }
        oppositeReservationMap.put(oppositeModelElementId, conflictBucketCandidate);
    }

    public Set<String> getAllModelElements() {
        return this.modelElementIdReservationMap.keySet();
    }

    public boolean hasExistenceReservation(String modelElementId) {
        FeatureNameReservationMap featureNameReservationMap = (FeatureNameReservationMap)this.modelElementIdReservationMap.get(modelElementId);
        return featureNameReservationMap != null && featureNameReservationMap.hasExistenceFeature();
    }

    public boolean hasFullReservation(String modelElementId) {
        FeatureNameReservationMap featureNameReservationMap = (FeatureNameReservationMap)this.modelElementIdReservationMap.get(modelElementId);
        return featureNameReservationMap != null && featureNameReservationMap.isAllFeatures();
    }

    public Set<String> getFeatureNames(String modelElementId) {
        return ((FeatureNameReservationMap)this.modelElementIdReservationMap.get(modelElementId)).keySet();
    }

    public boolean hasFeatureReservation(String modelElementId, String featureName) {
        FeatureNameReservationMap featureNameReservationMap = (FeatureNameReservationMap)this.modelElementIdReservationMap.get(modelElementId);
        if (featureNameReservationMap == null) {
            return false;
        }
        OppositeReservationMap oppositeReservationMap = (OppositeReservationMap)featureNameReservationMap.get(featureName);
        return oppositeReservationMap != null && !oppositeReservationMap.hasOpposites();
    }

    public boolean hasOppositeReservations(String modelElementId, String featureName) {
        FeatureNameReservationMap featureNameReservationMap = (FeatureNameReservationMap)this.modelElementIdReservationMap.get(modelElementId);
        if (featureNameReservationMap == null) {
            return false;
        }
        OppositeReservationMap oppositeReservationMap = (OppositeReservationMap)featureNameReservationMap.get(featureName);
        return oppositeReservationMap != null && oppositeReservationMap.hasOpposites();
    }

    public Set<String> getOpposites(String modelElementID, String featureName) {
        return ((OppositeReservationMap)((FeatureNameReservationMap)this.modelElementIdReservationMap.get(modelElementID)).get(featureName)).keySet();
    }

    public Set<ConflictBucketCandidate> getConflictBucketCandidates(String modelElementId) {
        return this.modelElementIdReservationMap.getConflictBucketCandidates(modelElementId);
    }

    public Set<ConflictBucketCandidate> getConflictBucketCandidates(String modelElementId, String featureName) {
        return this.modelElementIdReservationMap.getConflictBucketCandidates(modelElementId, featureName);
    }

    public Set<ConflictBucketCandidate> getConflictBucketCandidates(String modelElementId, String featureName, String oppositeModelElement) {
        return this.modelElementIdReservationMap.getConflictBucketCandidates(modelElementId, featureName, oppositeModelElement);
    }

    public boolean hasOppositeReservation(String modelElementID, String featureName, String oppositeModelElementID) {
        FeatureNameReservationMap featureNameReservationMap = (FeatureNameReservationMap)this.modelElementIdReservationMap.get(modelElementID);
        if (featureNameReservationMap == null) {
            return false;
        }
        OppositeReservationMap oppositeReservationMap = (OppositeReservationMap)featureNameReservationMap.get(featureName);
        if (oppositeReservationMap == null || !oppositeReservationMap.hasOpposites()) {
            return false;
        }
        return oppositeReservationMap.containsKey(oppositeModelElementID);
    }
}

