/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.controller;

import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.client.ESUsersession;
import org.eclipse.emf.emfstore.client.util.ESVoidCallable;
import org.eclipse.emf.emfstore.internal.client.model.exceptions.LoginCanceledException;
import org.eclipse.emf.emfstore.internal.client.ui.common.RunInUI;
import org.eclipse.emf.emfstore.internal.client.ui.controller.AbstractEMFStoreUIController;
import org.eclipse.emf.emfstore.internal.client.ui.controller.Messages;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIShareProjectController
extends AbstractEMFStoreUIController<Void> {
    private final ESLocalProject localProject;
    private ESUsersession usersession;
    private boolean loginHasBeenCancelled;
    private boolean shareWasSuccessful;
    private String shareErrorMessage;

    public UIShareProjectController(Shell shell, ESLocalProject localProject) {
        super(shell, true, false);
        this.localProject = localProject;
    }

    public UIShareProjectController(Shell shell, ESUsersession usersession, ESLocalProject localProject) {
        super(shell, true, true);
        this.usersession = usersession;
        this.localProject = localProject;
    }

    @Override
    public void afterRun() {
        if (this.loginHasBeenCancelled) {
            return;
        }
        RunInUI.run((Callable<Void>)new ESVoidCallable(){

            public void run() {
                if (UIShareProjectController.this.shareWasSuccessful) {
                    MessageDialog.openInformation((Shell)UIShareProjectController.this.getShell(), (String)Messages.UIShareProjectController_ShareSucceeded, (String)Messages.UIShareProjectController_SharedSucceeded_Message);
                } else {
                    MessageDialog.openError((Shell)UIShareProjectController.this.getShell(), (String)Messages.UIShareProjectController_ShareFailed, (String)UIShareProjectController.this.shareErrorMessage);
                }
            }
        });
    }

    @Override
    public Void doRun(IProgressMonitor progressMonitor) throws ESException {
        try {
            this.localProject.shareProject(this.usersession != null ? this.usersession : null, progressMonitor);
            this.shareWasSuccessful = true;
        }
        catch (LoginCanceledException loginCanceledException) {
            this.loginHasBeenCancelled = true;
        }
        catch (ESException e) {
            this.shareWasSuccessful = false;
            this.shareErrorMessage = e.getMessage();
        }
        return null;
    }
}

