/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.impl;

import java.util.List;
import org.eclipse.emf.emfstore.internal.client.model.impl.ProjectSpaceBase;
import org.eclipse.emf.emfstore.internal.client.model.util.EMFStoreCommand;
import org.eclipse.emf.emfstore.internal.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.internal.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplyOperationsRunnable
implements Runnable {
    private ProjectSpaceBase projectSpace;
    private List<AbstractOperation> operations;
    private boolean addOperations;

    public ApplyOperationsRunnable(ProjectSpaceBase projectSpaceBase, List<AbstractOperation> operations, boolean addOperations) {
        this.projectSpace = projectSpaceBase;
        this.operations = operations;
        this.addOperations = addOperations;
    }

    @Override
    public void run() {
        new EMFStoreCommand(){

            protected void doRun() {
                ApplyOperationsRunnable.this.projectSpace.stopChangeRecording();
                try {
                    for (AbstractOperation operation : ApplyOperationsRunnable.this.operations) {
                        try {
                            operation.apply((IdEObjectCollection)ApplyOperationsRunnable.this.projectSpace.getProject());
                        }
                        catch (RuntimeException e) {
                            WorkspaceUtil.handleException(e);
                        }
                    }
                    if (ApplyOperationsRunnable.this.addOperations) {
                        ApplyOperationsRunnable.this.projectSpace.addOperations(ApplyOperationsRunnable.this.operations);
                    }
                }
                finally {
                    if (ApplyOperationsRunnable.this.projectSpace.getOperationManager() != null) {
                        ApplyOperationsRunnable.this.projectSpace.startChangeRecording();
                    }
                }
            }
        }.run(false);
    }
}

