/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.common.extensionpoint;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.emfstore.common.extensionpoint.ExtensionPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionElement {
    private final IConfigurationElement element;
    private boolean exceptionInsteadOfNull;

    public ExtensionElement(IConfigurationElement element) {
        this(element, false);
    }

    public ExtensionElement(IConfigurationElement element, boolean throwExceptions) {
        this.element = element;
        this.exceptionInsteadOfNull = throwExceptions;
    }

    public Boolean getBoolean(String name) {
        return Boolean.parseBoolean(this.getAttribute(name));
    }

    public Integer getInteger(String name) {
        try {
            return Integer.parseInt(this.getAttribute(name));
        }
        catch (NumberFormatException e) {
            return (Integer)ExtensionPoint.handleErrorOrNull(this.exceptionInsteadOfNull, e);
        }
    }

    public String getAttribute(String name) {
        String attribute = this.element.getAttribute(name);
        if (attribute == null) {
            ExtensionPoint.handleErrorOrNull(this.exceptionInsteadOfNull, null);
        }
        return attribute;
    }

    public <T> T getClass(String class_id, Class<T> returnType) {
        try {
            Object executableExtension = this.element.createExecutableExtension(class_id);
            if (returnType.isInstance(executableExtension)) {
                return (T)executableExtension;
            }
            return (T)ExtensionPoint.handleErrorOrNull(this.exceptionInsteadOfNull, null);
        }
        catch (CoreException e) {
            return (T)ExtensionPoint.handleErrorOrNull(this.exceptionInsteadOfNull, (Exception)((Object)e));
        }
    }

    public IConfigurationElement getIConfigurationElement() {
        return this.element;
    }

    public void setThrowException(boolean throwException) {
        this.exceptionInsteadOfNull = throwException;
    }

    public boolean getThrowException() {
        return this.exceptionInsteadOfNull;
    }
}

