/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.model.filetransfer;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.emfstore.client.model.filetransfer.FileTransferJob;
import org.eclipse.emf.emfstore.client.model.filetransfer.FileTransferManager;
import org.eclipse.emf.emfstore.server.exceptions.EmfStoreException;
import org.eclipse.emf.emfstore.server.exceptions.FileTransferException;
import org.eclipse.emf.emfstore.server.filetransfer.FileChunk;
import org.eclipse.emf.emfstore.server.filetransfer.FilePartitionerUtil;
import org.eclipse.emf.emfstore.server.filetransfer.FileTransferInformation;
import org.eclipse.emf.emfstore.server.model.FileIdentifier;

public class FileUploadJob
extends FileTransferJob {
    public FileUploadJob(FileTransferManager transferManager, FileIdentifier fileId, boolean transferVisibleToUser) throws FileTransferException {
        super(transferManager, new FileTransferInformation(fileId, (int)transferManager.getCache().getCachedFile(fileId).length()), "File Upload");
        this.setUser(transferVisibleToUser);
        this.setFile(this.getCache().getCachedFile(fileId));
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.getConnectionAttributes();
            if (!this.executeTransfer(monitor)) {
                return Status.CANCEL_STATUS;
            }
        }
        catch (EmfStoreException e) {
            this.setException((Exception)((Object)e));
            monitor.setCanceled(true);
            monitor.done();
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private boolean executeTransfer(IProgressMonitor monitor) throws EmfStoreException {
        FileChunk fileChunk;
        this.initializeMonitor(monitor);
        do {
            fileChunk = FilePartitionerUtil.readChunk((File)this.getFile(), (FileTransferInformation)this.getFileInformation());
            this.getConnectionManager().uploadFileChunk(this.getSessionId(), this.getProjectId(), fileChunk);
            monitor.worked(1);
            this.incrementChunkNumber();
            if (!this.isCanceled()) continue;
            return false;
        } while (!fileChunk.isLast());
        this.getTransferManager().removeWaitingUpload(this.getFileId());
        return true;
    }
}

