/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.model.filetransfer;

import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.emfstore.client.model.filetransfer.FileDownloadStatus;
import org.eclipse.emf.emfstore.client.model.filetransfer.FileTransferJob;
import org.eclipse.emf.emfstore.client.model.filetransfer.FileTransferManager;
import org.eclipse.emf.emfstore.server.exceptions.EmfStoreException;
import org.eclipse.emf.emfstore.server.filetransfer.FileChunk;
import org.eclipse.emf.emfstore.server.filetransfer.FilePartitionerUtil;
import org.eclipse.emf.emfstore.server.filetransfer.FileTransferInformation;
import org.eclipse.emf.emfstore.server.model.FileIdentifier;

public class FileDownloadJob
extends FileTransferJob {
    private FileDownloadStatus status;

    FileDownloadJob(FileDownloadStatus status, FileTransferManager transferManager, FileIdentifier fileId, boolean transferVisibleToUser) {
        super(transferManager, new FileTransferInformation(fileId, -1), "File Download");
        this.setUser(transferVisibleToUser);
        this.status = status;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.getConnectionAttributes();
            this.setFile(this.getCache().createTempFile(this.getFileId()));
            if (!this.executeTransfer(monitor)) {
                return Status.CANCEL_STATUS;
            }
        }
        catch (EmfStoreException e) {
            return this.registerException((Exception)((Object)e));
        }
        catch (IOException e) {
            return this.registerException(e);
        }
        catch (RuntimeException e) {
            return this.registerException(e);
        }
        return Status.OK_STATUS;
    }

    private IStatus registerException(Exception e) {
        this.status.transferFailed(e);
        this.setException(e);
        return Status.CANCEL_STATUS;
    }

    private boolean executeTransfer(IProgressMonitor monitor) throws RemoteException, EmfStoreException {
        FileChunk fileChunk = null;
        fileChunk = this.getConnectionManager().downloadFileChunk(this.getSessionId(), this.getProjectId(), this.getFileInformation());
        this.getFileInformation().setFileSize(fileChunk.getFileSize());
        this.initializeMonitor(monitor);
        this.status.transferStarted(fileChunk.getFileSize());
        do {
            fileChunk = this.getConnectionManager().downloadFileChunk(this.getSessionId(), this.getProjectId(), this.getFileInformation());
            FilePartitionerUtil.writeChunk((File)this.getFile(), (FileChunk)fileChunk);
            monitor.worked(1);
            this.incrementChunkNumber();
            if (!this.isCanceled()) continue;
            this.status.transferCancelled();
            return false;
        } while (!fileChunk.isLast());
        File result = this.getCache().moveTempFileToCache(this.getFileId());
        this.status.transferFinished(result);
        return true;
    }
}

