/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.emfstorebridge.actions;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecp.emfstorebridge.actions.CreateProjectDialog;
import org.eclipse.emf.emfstore.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.client.model.WorkspaceManager;
import org.eclipse.emf.emfstore.client.model.util.EMFStoreCommand;
import org.eclipse.emf.emfstore.common.CommonUtil;
import org.eclipse.emf.emfstore.common.model.util.ModelUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportXMIAction
implements IActionDelegate {
    private ISelection selection;
    public static final String[] FILTER_NAMES = new String[]{"ECP Project Files (*.ucm)", "All Files (*.*)"};
    public static final String[] FILTER_EXTS = new String[]{"*.ucm", "*.*"};

    public void run(IAction action) {
        if (this.selection instanceof TreeSelection) {
            WorkspaceManager.init();
            final Object firstElement = ((TreeSelection)this.selection).getFirstElement();
            new EMFStoreCommand(){

                protected void doRun() {
                    ImportXMIAction.this.runImport(firstElement);
                }
            }.run();
        }
    }

    private void runImport(Object firstElement) {
        if (firstElement instanceof IFile) {
            CreateProjectDialog dialog = new CreateProjectDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), null);
            dialog.open();
            final ProjectSpace projectSpace = dialog.getProjectSpace();
            IFile file = (IFile)firstElement;
            final URI fileURI = URI.createFileURI((String)file.getRawLocationURI().getPath());
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            final Resource resource = resourceSet.getResource(fileURI, true);
            final ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            new EMFStoreCommand(){

                protected void doRun() {
                    ImportXMIAction.this.importFile(projectSpace, fileURI, resource, progressDialog);
                }
            }.run();
            return;
        }
    }

    private void importFile(ProjectSpace projectSpace, URI fileURI, Resource resource, ProgressMonitorDialog progressDialog) {
        try {
            try {
                progressDialog.open();
                progressDialog.getProgressMonitor().beginTask("Import model...", 100);
                Set<EObject> importElements = this.validation(resource);
                if (importElements.size() > 0) {
                    int i = 0;
                    for (EObject eObject : importElements) {
                        this.runImport(projectSpace, fileURI, ModelUtil.clone((EObject)eObject), i);
                        progressDialog.getProgressMonitor().worked(10);
                        ++i;
                    }
                }
            }
            catch (RuntimeException e) {
                ModelUtil.logException((Throwable)e);
                progressDialog.getProgressMonitor().done();
                progressDialog.close();
            }
        }
        finally {
            progressDialog.getProgressMonitor().done();
            progressDialog.close();
        }
    }

    private Set<EObject> validation(Resource resource) {
        HashSet<EObject> childrenSet = new HashSet<EObject>();
        HashSet<EObject> rootNodes = new HashSet<EObject>();
        EList rootContent = resource.getContents();
        for (EObject rootNode : rootContent) {
            TreeIterator contents = rootNode.eAllContents();
            while (contents.hasNext()) {
                EObject content = (EObject)contents.next();
                if (!(content instanceof EObject)) continue;
                childrenSet.add(content);
            }
        }
        for (EObject rootNode : rootContent) {
            if (!(rootNode instanceof EObject) || childrenSet.contains(rootNode)) continue;
            rootNodes.add(rootNode);
        }
        HashSet<EObject> notSelfContained = new HashSet<EObject>();
        for (EObject rootNode : rootNodes) {
            if (CommonUtil.isSelfContained((EObject)rootNode)) continue;
            notSelfContained.add(rootNode);
        }
        rootNodes.removeAll(notSelfContained);
        return rootNodes;
    }

    private void runImport(ProjectSpace projectSpace, URI uri, EObject element, int resourceIndex) {
        projectSpace.getProject().addModelElement(element);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }
}

