/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.editor.mecontrols.melinkcontrol;

import java.util.ArrayList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecp.common.Activator;
import org.eclipse.emf.ecp.common.model.ECPModelelementContext;
import org.eclipse.emf.ecp.common.utilities.ModelElementClassTooltip;
import org.eclipse.emf.ecp.common.utilities.ShortLabelProvider;
import org.eclipse.emf.ecp.editor.ModelElementChangeListener;
import org.eclipse.emf.ecp.editor.mecontrols.melinkcontrol.MEHyperLinkAdapter;
import org.eclipse.emf.ecp.editor.mecontrols.melinkcontrol.MEHyperLinkDeleteAdapter;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class MELinkControl {
    private EReference eReference;
    private Hyperlink hyperlink;
    private ILabelProvider labelProvider;
    private ILabelProviderListener labelProviderListener;
    private ImageHyperlink imageHyperlink;
    private EObject link;
    private EObject contextModelElement;
    private ModelElementChangeListener modelElementChangeListener;
    private ECPModelelementContext context;
    private IItemPropertyDescriptor pDescriptor;
    private ComposedAdapterFactory adapterFactory;
    protected Composite linkComposite;
    protected FormToolkit toolkit;

    public ECPModelelementContext getContext() {
        return this.context;
    }

    protected void setToolkit(FormToolkit toolkit) {
        this.toolkit = toolkit;
    }

    protected FormToolkit getToolkit() {
        return this.toolkit;
    }

    public void setContext(ECPModelelementContext context) {
        this.context = context;
    }

    public Control createControl(Composite parent, int style, IItemPropertyDescriptor itemPropertyDescriptor, EObject link, EObject contextModelElement, FormToolkit toolkit, ECPModelelementContext context) {
        this.context = context;
        this.pDescriptor = itemPropertyDescriptor;
        Object feature = itemPropertyDescriptor.getFeature((Object)link);
        this.eReference = (EReference)feature;
        this.link = link;
        this.contextModelElement = contextModelElement;
        this.toolkit = toolkit;
        return this.createControl(parent, style);
    }

    protected Control createControl(Composite parent, int style) {
        this.linkComposite = this.toolkit.createComposite(parent, style);
        this.linkComposite.setLayout((Layout)new GridLayout(3, false));
        if (!this.pDescriptor.canSetProperty((Object)this.contextModelElement)) {
            this.linkComposite.setEnabled(false);
        }
        this.createHyperlink(parent, style);
        this.createDeleteAction(style);
        return this.linkComposite;
    }

    protected void createDeleteAction(int style) {
        ImageHyperlink deleteLink = this.toolkit.createImageHyperlink(this.linkComposite, style);
        Image deleteImage = null;
        deleteImage = this.eReference.isContainment() && this.context.getMetaModelElementContext().isNonDomainElement(this.link.eClass()) ? Activator.getImageDescriptor((String)"icons/delete.gif").createImage() : PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE");
        deleteLink.setImage(deleteImage);
        deleteLink.addMouseListener((MouseListener)new MEHyperLinkDeleteAdapter(this.contextModelElement, this.eReference, this.link, this.context));
    }

    private void createHyperlink(final Composite parent, int style) {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        AdapterFactoryLabelProvider adapterFactoryLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory);
        IDecoratorManager decoratorManager = PlatformUI.getWorkbench().getDecoratorManager();
        this.labelProvider = new DecoratingLabelProvider((ILabelProvider)adapterFactoryLabelProvider, decoratorManager.getLabelDecorator());
        this.labelProviderListener = new ILabelProviderListener(){

            public void labelProviderChanged(LabelProviderChangedEvent event) {
                MELinkControl.this.updateIcon();
            }
        };
        this.labelProvider.addListener(this.labelProviderListener);
        ArrayList<EObject> list = new ArrayList<EObject>();
        list.add(this.link);
        this.modelElementChangeListener = new ModelElementChangeListener(this.link){

            public void onChange(Notification notification) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (MELinkControl.this.hyperlink != null && !MELinkControl.this.hyperlink.isDisposed()) {
                            ShortLabelProvider shortLabelProvider = new ShortLabelProvider();
                            String text = shortLabelProvider.getText((Object)MELinkControl.this.link);
                            MELinkControl.this.hyperlink.setText(text);
                            MELinkControl.this.hyperlink.setToolTipText(text);
                            (this).MELinkControl.this.linkComposite.layout(true);
                            parent.getParent().layout(true);
                        }
                    }
                });
            }
        };
        Image image = this.labelProvider.getImage((Object)this.link);
        this.imageHyperlink = this.toolkit.createImageHyperlink(this.linkComposite, style);
        this.imageHyperlink.setImage(image);
        this.imageHyperlink.setData((Object)this.link.eClass());
        ModelElementClassTooltip.enableFor((Control)this.imageHyperlink);
        ShortLabelProvider shortLabelProvider = new ShortLabelProvider();
        this.hyperlink = this.toolkit.createHyperlink(this.linkComposite, shortLabelProvider.getText((Object)this.link), style);
        this.hyperlink.setToolTipText(shortLabelProvider.getText((Object)this.link));
        MEHyperLinkAdapter listener = new MEHyperLinkAdapter(this.link, this.contextModelElement, this.eReference.getName());
        this.hyperlink.addHyperlinkListener((IHyperlinkListener)listener);
        this.imageHyperlink.addHyperlinkListener((IHyperlinkListener)listener);
    }

    private void updateIcon() {
        this.imageHyperlink.setImage(this.labelProvider.getImage((Object)this.link));
    }

    public void dispose() {
        if (this.modelElementChangeListener != null) {
            this.modelElementChangeListener.remove();
        }
        if (this.labelProvider != null) {
            this.labelProvider.removeListener(this.labelProviderListener);
            this.labelProvider.dispose();
        }
        if (this.linkComposite != null) {
            this.linkComposite.dispose();
        }
        if (this.adapterFactory != null) {
            this.adapterFactory.dispose();
        }
    }

    public int canRender(IItemPropertyDescriptor itemPropertyDescriptor, EObject link, EObject contextModelElement) {
        return 0;
    }
}

