/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.model.ECPModelelementContext;
import org.eclipse.emf.ecp.editor.Activator;
import org.eclipse.emf.ecp.editor.mecontrols.AbstractMEControl;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlFactory {
    private HashMap<Class<?>, ArrayList<AbstractMEControl>> controlRegistry = new HashMap();

    public ControlFactory() {
        this.initializeMEControls();
    }

    private void initializeMEControls() {
        IConfigurationElement[] attributecontrols = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.emf.ecp.editor.attributecontrols");
        IConfigurationElement[] referencecontrols = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.emf.ecp.editor.referencecontrols");
        ArrayList<IConfigurationElement> allControls = new ArrayList<IConfigurationElement>();
        allControls.addAll(Arrays.asList(attributecontrols));
        allControls.addAll(Arrays.asList(referencecontrols));
        for (IConfigurationElement e : allControls) {
            String type = e.getAttribute("type");
            try {
                AbstractMEControl control = (AbstractMEControl)e.createExecutableExtension("class");
                Class<?> resolvedType = control.getClass().getClassLoader().loadClass(type);
                boolean showLabel = Boolean.parseBoolean(e.getAttribute("showLabel"));
                control.setShowLabel(showLabel);
                ArrayList<AbstractMEControl> list = this.controlRegistry.get(resolvedType);
                if (list == null) {
                    list = new ArrayList();
                }
                list.add(control);
                this.controlRegistry.put(resolvedType, list);
            }
            catch (ClassNotFoundException e1) {
                Activator.logException(e1);
            }
            catch (CoreException e2) {
                Activator.logException((Exception)((Object)e2));
            }
        }
    }

    public AbstractMEControl createControl(IItemPropertyDescriptor itemPropertyDescriptor, EObject modelElement) {
        return this.createControl(itemPropertyDescriptor, modelElement, null);
    }

    public AbstractMEControl createControl(IItemPropertyDescriptor itemPropertyDescriptor, EObject modelElement, ECPModelelementContext context) {
        EStructuralFeature feature = (EStructuralFeature)itemPropertyDescriptor.getFeature((Object)modelElement);
        if (feature instanceof EAttribute) {
            return this.createAttribute(itemPropertyDescriptor, feature, modelElement, context);
        }
        if (feature instanceof EReference) {
            return this.createReferenceControl(itemPropertyDescriptor, (EReference)feature, modelElement, context);
        }
        return null;
    }

    private AbstractMEControl createReferenceControl(IItemPropertyDescriptor itemPropertyDescriptor, EReference feature, EObject modelElement, ECPModelelementContext context) {
        Class instanceClass = feature.getEType().getInstanceClass();
        Set<Class<?>> keySet = this.controlRegistry.keySet();
        ArrayList<AbstractMEControl> candidates = new ArrayList<AbstractMEControl>();
        for (Class<?> clazz : keySet) {
            if (!clazz.isAssignableFrom(instanceClass)) continue;
            candidates.addAll((Collection<AbstractMEControl>)this.controlRegistry.get(clazz));
        }
        AbstractMEControl control = this.getBestCandidate(candidates, itemPropertyDescriptor, (EStructuralFeature)feature, modelElement, context);
        AbstractMEControl ret = null;
        if (control == null) {
            return null;
        }
        try {
            ret = (AbstractMEControl)control.getClass().newInstance();
            ret.setShowLabel(control.getShowLabel());
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return ret;
    }

    private AbstractMEControl createAttribute(IItemPropertyDescriptor itemPropertyDescriptor, EStructuralFeature feature, EObject modelElement, ECPModelelementContext context) {
        Class instanceClass = ((EAttribute)feature).getEAttributeType().getInstanceClass();
        Set<Class<?>> keySet = this.controlRegistry.keySet();
        ArrayList<AbstractMEControl> candidates = new ArrayList<AbstractMEControl>();
        for (Class<?> clazz : keySet) {
            if (instanceClass.isPrimitive()) {
                try {
                    Class primitive = (Class)clazz.getField("TYPE").get(null);
                    if (primitive.equals(instanceClass)) {
                        candidates.addAll((Collection<AbstractMEControl>)this.controlRegistry.get(clazz));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (SecurityException securityException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
            if (!clazz.isAssignableFrom(instanceClass)) continue;
            candidates.addAll((Collection<AbstractMEControl>)this.controlRegistry.get(clazz));
        }
        AbstractMEControl control = this.getBestCandidate(candidates, itemPropertyDescriptor, feature, modelElement, context);
        AbstractMEControl ret = null;
        if (control == null) {
            return null;
        }
        try {
            ret = (AbstractMEControl)control.getClass().newInstance();
            ret.setShowLabel(control.getShowLabel());
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return ret;
    }

    private AbstractMEControl getBestCandidate(ArrayList<AbstractMEControl> candidates, IItemPropertyDescriptor itemPropertyDescriptor, EStructuralFeature feature, EObject modelElement, ECPModelelementContext context) {
        int bestValue = 0;
        AbstractMEControl bestCandidate = null;
        for (AbstractMEControl abstractMEControl : candidates) {
            abstractMEControl.setContext(context);
            int newValue = abstractMEControl.canRender(itemPropertyDescriptor, modelElement);
            if (newValue <= bestValue) continue;
            bestCandidate = abstractMEControl;
            bestValue = newValue;
        }
        return bestCandidate;
    }
}

