/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.server.model.versioning.operations.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.emfstore.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.common.model.ModelElementId;
import org.eclipse.emf.emfstore.common.model.impl.IdEObjectCollectionImpl;
import org.eclipse.emf.emfstore.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.MultiReferenceOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.OperationsFactory;
import org.eclipse.emf.emfstore.server.model.versioning.operations.OperationsPackage;
import org.eclipse.emf.emfstore.server.model.versioning.operations.UnkownFeatureException;
import org.eclipse.emf.emfstore.server.model.versioning.operations.impl.ReferenceOperationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiReferenceOperationImpl
extends ReferenceOperationImpl
implements MultiReferenceOperation {
    protected static final boolean ADD_EDEFAULT = false;
    protected boolean add = false;
    protected static final int INDEX_EDEFAULT = 0;
    protected int index = 0;
    protected EList<ModelElementId> referencedModelElements;

    protected MultiReferenceOperationImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return OperationsPackage.Literals.MULTI_REFERENCE_OPERATION;
    }

    @Override
    public boolean isAdd() {
        return this.add;
    }

    @Override
    public void setAdd(boolean newAdd) {
        boolean oldAdd = this.add;
        this.add = newAdd;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, oldAdd, this.add));
        }
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int newIndex) {
        int oldIndex = this.index;
        this.index = newIndex;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, oldIndex, this.index));
        }
    }

    @Override
    public EList<ModelElementId> getReferencedModelElements() {
        if (this.referencedModelElements == null) {
            this.referencedModelElements = new EObjectContainmentEList.Resolving(ModelElementId.class, (InternalEObject)this, 12);
        }
        return this.referencedModelElements;
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 12: {
                return ((InternalEList)this.getReferencedModelElements()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 10: {
                return this.isAdd();
            }
            case 11: {
                return this.getIndex();
            }
            case 12: {
                return this.getReferencedModelElements();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 10: {
                this.setAdd((Boolean)newValue);
                return;
            }
            case 11: {
                this.setIndex((Integer)newValue);
                return;
            }
            case 12: {
                this.getReferencedModelElements().clear();
                this.getReferencedModelElements().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 10: {
                this.setAdd(false);
                return;
            }
            case 11: {
                this.setIndex(0);
                return;
            }
            case 12: {
                this.getReferencedModelElements().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 10: {
                return this.add;
            }
            case 11: {
                return this.index != 0;
            }
            case 12: {
                return this.referencedModelElements != null && !this.referencedModelElements.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (add: ");
        result.append(this.add);
        result.append(", index: ");
        result.append(this.index);
        result.append(')');
        return result.toString();
    }

    @Override
    public void apply(IdEObjectCollection project) {
        EReference reference;
        EObject modelElement = project.getModelElement(this.getModelElementId());
        if (modelElement == null) {
            return;
        }
        EList<ModelElementId> referencedModelElementIds = this.getReferencedModelElements();
        ArrayList<EObject> referencedModelElements = new ArrayList<EObject>();
        for (ModelElementId refrencedModelElementId : referencedModelElementIds) {
            EObject referencedME = project.getModelElement(refrencedModelElementId);
            if (referencedME == null) {
                referencedME = ((IdEObjectCollectionImpl)project).getDeletedModelElement(refrencedModelElementId);
            }
            if (referencedME == null) continue;
            referencedModelElements.add(referencedME);
        }
        try {
            reference = (EReference)this.getFeature(modelElement);
        }
        catch (UnkownFeatureException e) {
            return;
        }
        Object object = modelElement.eGet((EStructuralFeature)reference);
        EList list = (EList)object;
        if (this.isAdd()) {
            if (this.index < list.size() && this.index > -1) {
                int i = this.index;
                for (EObject m : referencedModelElements) {
                    if (i < list.size()) {
                        if (list.contains((Object)m)) {
                            list.move(i, (Object)m);
                        } else {
                            list.add(i, (Object)m);
                        }
                    } else {
                        list.add((Object)m);
                    }
                    ++i;
                }
            } else {
                list.addAll(referencedModelElements);
            }
        } else {
            for (EObject me : referencedModelElements) {
                if (!list.contains((Object)me)) continue;
                list.remove((Object)me);
            }
            for (EObject currentElement : referencedModelElements) {
                if (!reference.isContainment()) continue;
                project.addModelElement(currentElement);
            }
        }
    }

    @Override
    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isAdd()) {
            stringBuilder.append("Added ");
            stringBuilder.append(this.getMiddleDescription());
            stringBuilder.append(" to ");
        } else {
            stringBuilder.append("Removed ");
            stringBuilder.append(this.getMiddleDescription());
            stringBuilder.append(" from ");
        }
        stringBuilder.append(this.featureName);
        return stringBuilder.toString();
    }

    private String getMiddleDescription() {
        String featureName = this.getFeatureName();
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getReferencedModelElements().size() > 1) {
            stringBuilder.append(this.getReferencedModelElements().size());
            stringBuilder.append(" ");
            stringBuilder.append(featureName);
        } else {
            String singular = featureName.substring(0, featureName.length() - 1);
            stringBuilder.append(singular);
        }
        return stringBuilder.toString();
    }

    @Override
    public String getName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Changed ");
        stringBuilder.append(this.getFeatureName());
        return stringBuilder.toString();
    }

    @Override
    public AbstractOperation reverse() {
        MultiReferenceOperation multiReferenceOperation = OperationsFactory.eINSTANCE.createMultiReferenceOperation();
        super.reverse(multiReferenceOperation);
        multiReferenceOperation.setAdd(!this.isAdd());
        EList<ModelElementId> copiedReferencedModelElements = multiReferenceOperation.getReferencedModelElements();
        EList<ModelElementId> modelElements = this.getReferencedModelElements();
        for (ModelElementId modelElementId : modelElements) {
            copiedReferencedModelElements.add((Object)((ModelElementId)ModelUtil.clone((EObject)modelElementId)));
        }
        multiReferenceOperation.setIndex(this.getIndex());
        return multiReferenceOperation;
    }

    @Override
    public Set<ModelElementId> getOtherInvolvedModelElements() {
        HashSet<ModelElementId> set = new HashSet<ModelElementId>();
        set.addAll((Collection<ModelElementId>)this.getReferencedModelElements());
        return set;
    }
}

