/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.common.utilities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboView<T> {
    private final Combo combo;
    private HashMap<Integer, T> map = new HashMap();
    private T lastSelection;
    private SelectionListener listener;
    private ILabelProvider labelProvider;
    private List<IComboChangeListener<? super T>> changeListeners = new ArrayList<IComboChangeListener<? super T>>();

    public ComboView(Combo combo) {
        this.combo = combo;
        this.listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object newSelection = ComboView.this.map.get(ComboView.this.combo.getSelectionIndex());
                if (newSelection != ComboView.this.lastSelection) {
                    ComboView.this.lastSelection = newSelection;
                    for (IComboChangeListener listener : ComboView.this.changeListeners) {
                        listener.selectionChanged(newSelection);
                    }
                }
            }
        };
        combo.addSelectionListener(this.listener);
    }

    public ComboView(Composite parent, int style) {
        this(new Combo(parent, style));
    }

    public void setInput(Collection<? extends T> entries) {
        this.setInput(entries, null, false);
    }

    public void setInput(Collection<? extends T> entries, T defaultEntry, boolean fireSelectionChangeEvents) {
        String[] labels = new String[entries.size()];
        int selection = 0;
        int i = 0;
        for (T e : entries) {
            String label = this.labelProvider == null ? String.valueOf(e) : this.labelProvider.getText(e);
            this.map.put(i, e);
            labels[i] = label;
            if (e.equals(defaultEntry)) {
                selection = i;
            }
            ++i;
        }
        if (!fireSelectionChangeEvents) {
            this.lastSelection = this.map.get(selection);
        }
        this.combo.setItems(labels);
        this.combo.select(selection);
        this.listener.widgetSelected(null);
    }

    public T getSelection() {
        if (this.combo.isDisposed()) {
            return this.lastSelection;
        }
        int index = this.combo.getSelectionIndex();
        if (index == -1) {
            return null;
        }
        return this.map.get(index);
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public Combo getControl() {
        return this.combo;
    }

    public void addSelectionChangedListener(IComboChangeListener<? super T> listener) {
        this.changeListeners.add(listener);
    }

    public void removeSelectionChangedListener(IComboChangeListener<? super T> listener) {
        this.changeListeners.remove(listener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IComboChangeListener<T> {
        public void selectionChanged(T var1);
    }
}

