/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.common.dnd;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecp.common.Activator;
import org.eclipse.emf.ecp.common.commands.ECPCommand;
import org.eclipse.emf.ecp.common.dnd.DragSourcePlaceHolder;
import org.eclipse.emf.ecp.common.dnd.MEDropAdapter;
import org.eclipse.emf.ecp.common.model.ECPWorkspaceManager;
import org.eclipse.emf.ecp.common.model.NoWorkspaceException;
import org.eclipse.emf.ecp.common.model.workSpaceModel.ECPProject;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComposedDropAdapter
extends DropTargetAdapter {
    private StructuredViewer viewer;
    private List<EObject> source;
    private EObject target;
    private EObject targetConatiner;
    private EObject dropee;
    private Map<EClass, MEDropAdapter> dropAdapters;
    private MEDropAdapter targetDropAdapter;
    private int eventFeedback;
    private boolean targetIsRoot;

    public ComposedDropAdapter(StructuredViewer viewer) {
        IConfigurationElement[] confs;
        this.viewer = viewer;
        this.dropAdapters = new HashMap<EClass, MEDropAdapter>();
        IConfigurationElement[] iConfigurationElementArray = confs = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.emf.ecp.common.dropadapter");
        int n = confs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                MEDropAdapter dropAdapter = (MEDropAdapter)element.createExecutableExtension("class");
                dropAdapter.init(viewer);
                this.dropAdapters.put(dropAdapter.isDropAdapterfor(), dropAdapter);
            }
            catch (CoreException e) {
                Activator.getDefault().logException(e.getMessage(), (Exception)((Object)e));
            }
            ++n2;
        }
    }

    public void drop(final DropTargetEvent event) {
        new ECPCommand(this.target){

            protected void doRun() {
                if (ComposedDropAdapter.this.targetIsRoot) {
                    try {
                        ECPProject project = ECPWorkspaceManager.getInstance().getWorkSpace().getProject(ComposedDropAdapter.this.target);
                        for (EObject obj : ComposedDropAdapter.this.source) {
                            project.addModelElementToRoot(obj);
                        }
                    }
                    catch (NoWorkspaceException noWorkspaceException) {}
                } else if (ComposedDropAdapter.isInsertAfter(ComposedDropAdapter.this.eventFeedback)) {
                    ComposedDropAdapter.this.targetDropAdapter.dropMove(ComposedDropAdapter.this.targetConatiner, ComposedDropAdapter.this.target, ComposedDropAdapter.this.source, true);
                } else if (ComposedDropAdapter.isInsertBefore(ComposedDropAdapter.this.eventFeedback)) {
                    ComposedDropAdapter.this.targetDropAdapter.dropMove(ComposedDropAdapter.this.targetConatiner, ComposedDropAdapter.this.target, ComposedDropAdapter.this.source, false);
                } else {
                    ComposedDropAdapter.this.targetDropAdapter.drop(event, ComposedDropAdapter.this.target, ComposedDropAdapter.this.source);
                }
            }
        }.run(true);
    }

    public void dragOver(DropTargetEvent event) {
        this.source = null;
        this.target = null;
        this.targetConatiner = null;
        this.targetDropAdapter = null;
        this.targetIsRoot = false;
        this.eventFeedback = 1;
        event.detail = 1;
        if (!this.extractDnDSourceAndTarget(event)) {
            event.detail = 0;
            return;
        }
        if (this.targetIsRoot) {
            return;
        }
        this.setInitialEventFeedback(event);
        this.eventFeedback = event.feedback;
        if ((ComposedDropAdapter.isInsertBefore(this.eventFeedback) || ComposedDropAdapter.isInsertAfter(this.eventFeedback)) && this.target.eContainer() != null) {
            this.targetConatiner = this.target.eContainer();
            this.targetDropAdapter = this.getTargetDropAdapter(this.targetConatiner.eClass());
        } else {
            this.targetDropAdapter = this.getTargetDropAdapter(this.target.eClass());
        }
        if (this.targetDropAdapter == null) {
            event.detail = 0;
        } else if (!this.targetDropAdapter.canDrop(this.eventFeedback, event, this.source, this.target, this.dropee)) {
            event.detail = 2006;
        } else if (this.targetDropAdapter.canDrop(this.eventFeedback, event, this.source, this.target, this.dropee)) {
            event.detail = 1;
        }
    }

    private boolean extractDnDSourceAndTarget(DropTargetEvent event) {
        boolean result = true;
        List tmpSource = (List)DragSourcePlaceHolder.getDragSource();
        if (tmpSource == null) {
            result = false;
        }
        for (Object obj : tmpSource) {
            if (obj instanceof EObject) continue;
            result = false;
        }
        this.source = (List)DragSourcePlaceHolder.getDragSource();
        if (this.source.size() == 0) {
            return false;
        }
        if (event.item == null || event.item.getData() == null || !(event.item.getData() instanceof EObject)) {
            result = false;
        }
        if (result) {
            this.dropee = this.source.get(0);
            this.target = (EObject)event.item.getData();
            ECPProject targetProject = null;
            ECPProject dropeeProject = null;
            try {
                targetProject = ECPWorkspaceManager.getInstance().getWorkSpace().getProject(this.target);
                dropeeProject = ECPWorkspaceManager.getInstance().getWorkSpace().getProject(this.dropee);
                if (targetProject.getRootObject() == this.target) {
                    this.targetIsRoot = true;
                }
            }
            catch (NoWorkspaceException e) {
                Activator.getDefault().logException((Exception)((Object)e));
                result = false;
            }
            if (!targetProject.equals(dropeeProject)) {
                result = false;
            }
        }
        return result;
    }

    private MEDropAdapter getTargetDropAdapter(EClass targetEClass) {
        EClass superTypeHavingADropAdapter;
        MEDropAdapter ret = this.dropAdapters.get(targetEClass);
        if (ret == null && (superTypeHavingADropAdapter = this.getSuperTypeHavingADropAdapter((Collection<EClass>)targetEClass.getESuperTypes())) != null && superTypeHavingADropAdapter != targetEClass) {
            ret = this.getTargetDropAdapter(superTypeHavingADropAdapter);
        }
        return ret;
    }

    private EClass getSuperTypeHavingADropAdapter(Collection<EClass> superClazz) {
        EClass ret = null;
        if (superClazz.size() == 0) {
            return EcorePackage.eINSTANCE.getEObject();
        }
        HashSet<EClass> intersection = new HashSet<EClass>(this.dropAdapters.keySet());
        intersection.retainAll(superClazz);
        if (intersection.size() > 1) {
            HashSet<EClass> toBeRemoved = new HashSet<EClass>();
            for (EClass eClass1 : intersection) {
                for (EClass eClass2 : intersection) {
                    if (eClass2.equals(eClass1) || !eClass2.isSuperTypeOf(eClass1) && !eClass2.equals(EcorePackage.eINSTANCE.getEObject())) continue;
                    toBeRemoved.add(eClass2);
                }
            }
            intersection.removeAll(toBeRemoved);
        }
        if (intersection.size() > 1) {
            throw new IllegalStateException("More than one drop adapter for this type found!");
        }
        if (intersection.size() == 0) {
            HashSet<EClass> eclazz = new HashSet<EClass>();
            for (EClass superClass : superClazz) {
                eclazz.addAll((Collection<EClass>)superClass.getESuperTypes());
            }
            ret = this.getSuperTypeHavingADropAdapter(eclazz);
        } else {
            ret = (EClass)intersection.toArray()[0];
        }
        return ret;
    }

    private void setInitialEventFeedback(DropTargetEvent event) {
        event.feedback = 1;
        if (event.item != null) {
            Rectangle rect = ((TreeItem)event.item).getBounds();
            Point pt = this.viewer.getControl().toControl(event.x, event.y);
            if (pt.y < rect.y + 5) {
                event.feedback = 2;
            }
            if (pt.y > rect.y + rect.height - 5) {
                event.feedback = 4;
            }
        }
        event.feedback |= 0x18;
    }

    public static boolean isInsertBefore(int eventFeedback) {
        return (eventFeedback & 2) == 2;
    }

    public static boolean isInsertAfter(int eventFeedback) {
        return (eventFeedback & 4) == 4;
    }
}

