/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.server.core.subinterfaces;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.common.model.ModelFactory;
import org.eclipse.emf.emfstore.common.model.Project;
import org.eclipse.emf.emfstore.common.model.util.FileUtil;
import org.eclipse.emf.emfstore.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.server.core.AbstractEmfstoreInterface;
import org.eclipse.emf.emfstore.server.core.AbstractSubEmfstoreInterface;
import org.eclipse.emf.emfstore.server.core.subinterfaces.VersionSubInterfaceImpl;
import org.eclipse.emf.emfstore.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.server.exceptions.EmfStoreException;
import org.eclipse.emf.emfstore.server.exceptions.FatalEmfStoreException;
import org.eclipse.emf.emfstore.server.exceptions.InvalidProjectIdException;
import org.eclipse.emf.emfstore.server.exceptions.StorageException;
import org.eclipse.emf.emfstore.server.model.ProjectHistory;
import org.eclipse.emf.emfstore.server.model.ProjectId;
import org.eclipse.emf.emfstore.server.model.ProjectInfo;
import org.eclipse.emf.emfstore.server.model.SessionId;
import org.eclipse.emf.emfstore.server.model.versioning.LogMessage;
import org.eclipse.emf.emfstore.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.server.model.versioning.Version;
import org.eclipse.emf.emfstore.server.model.versioning.VersionSpec;
import org.eclipse.emf.emfstore.server.model.versioning.VersioningFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectSubInterfaceImpl
extends AbstractSubEmfstoreInterface {
    public ProjectSubInterfaceImpl(AbstractEmfstoreInterface parentInterface) throws FatalEmfStoreException {
        super(parentInterface);
    }

    protected ProjectHistory getProject(ProjectId projectId) throws EmfStoreException {
        ProjectHistory projectHistory = this.getProjectOrNull(projectId);
        if (projectHistory != null) {
            return projectHistory;
        }
        throw new InvalidProjectIdException("Project with the id:" + (projectId == null ? "null" : projectId) + " doesn't exist.");
    }

    private ProjectHistory getProjectOrNull(ProjectId projectId) {
        for (ProjectHistory project : this.getServerSpace().getProjects()) {
            if (!project.getProjectId().equals(projectId)) continue;
            return project;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project getProject(ProjectId projectId, VersionSpec versionSpec) throws EmfStoreException {
        Object object = this.getMonitor();
        synchronized (object) {
            PrimaryVersionSpec resolvedVersion = this.getSubInterface(VersionSubInterfaceImpl.class).resolveVersionSpec(projectId, versionSpec);
            Version version = this.getSubInterface(VersionSubInterfaceImpl.class).getVersion(projectId, resolvedVersion);
            if (version.getProjectState() == null) {
                while (version.getProjectState() == null && version.getPreviousVersion() != null) {
                    version = version.getPreviousVersion();
                }
                if (version.getProjectState() == null) {
                    throw new EmfStoreException("Couldn't find project state.");
                }
                Project projectState = (Project)ModelUtil.clone((EObject)version.getProjectState());
                Version next = version.getNextVersion();
                while (next != null && next.getPrimarySpec().compareTo((Object)resolvedVersion) < 1) {
                    next.getChanges().apply(projectState);
                    next = next.getNextVersion();
                }
                return projectState;
            }
            return version.getProjectState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProjectInfo> getProjectList(SessionId sessionId) throws EmfStoreException {
        Object object = this.getMonitor();
        synchronized (object) {
            ArrayList<ProjectInfo> result = new ArrayList<ProjectInfo>();
            for (ProjectHistory projectHistory : this.getServerSpace().getProjects()) {
                try {
                    this.getAuthorizationControl().checkReadAccess(sessionId, projectHistory.getProjectId(), null);
                    result.add(this.createProjectInfo(projectHistory));
                }
                catch (AccessControlException accessControlException) {
                    // empty catch block
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectInfo createProject(String name, String description, LogMessage logMessage) throws EmfStoreException {
        Object object = this.getMonitor();
        synchronized (object) {
            ProjectHistory projectHistory = null;
            try {
                logMessage.setDate(new Date());
                projectHistory = this.createEmptyProject(name, description, logMessage, ModelFactory.eINSTANCE.createProject());
            }
            catch (FatalEmfStoreException e) {
                throw new StorageException("Couldn't save data in database.");
            }
            return this.createProjectInfo(projectHistory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectInfo createProject(String name, String description, LogMessage logMessage, Project project) throws EmfStoreException {
        Object object = this.getMonitor();
        synchronized (object) {
            ProjectHistory projectHistory = null;
            try {
                logMessage.setDate(new Date());
                projectHistory = this.createEmptyProject(name, description, logMessage, project);
            }
            catch (FatalEmfStoreException e) {
                throw new StorageException("Couldn't save data in database.");
            }
            return this.createProjectInfo(projectHistory);
        }
    }

    public void deleteProject(ProjectId projectId, boolean deleteFiles) throws EmfStoreException {
        this.deleteProject(projectId, deleteFiles, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void deleteProject(ProjectId projectId, boolean deleteFiles, boolean throwInvalidIdException) throws EmfStoreException {
        var4_4 = this.getMonitor();
        synchronized (var4_4) {
            block26: {
                try {
                    project = this.getProject(projectId);
                    this.getServerSpace().getProjects().remove((Object)project);
                    try {
                        try {
                            this.save((EObject)this.getServerSpace());
                        }
                        catch (FatalEmfStoreException e) {
                            throw new StorageException("Couldn't save data in database.");
                        }
                    }
                    finally {
                        project.eResource().delete(null);
                        ** for (version : project.getVersions())
                    }
lbl-1000:
                    // 1 sources

                    {
                        changes = version.getChanges();
                        if (changes != null) {
                            changes.eResource().delete(null);
                        }
                        if ((projectState = version.getProjectState()) != null) {
                            projectState.eResource().delete(null);
                        }
                        version.eResource().delete(null);
                        continue;
lbl25:
                        // 1 sources

                    }
                }
                catch (InvalidProjectIdException e) {
                    if (throwInvalidIdException) {
                        throw e;
                    }
                    if (deleteFiles) {
                        projectFolder = new File(this.getResourceHelper().getProjectFolder(projectId));
                        try {
                            FileUtil.deleteFolder((File)projectFolder);
                        }
                        catch (IOException e) {
                            ModelUtil.logException((String)"Project files couldn't be deleted, but it was deleted from containment tree.", (Throwable)e);
                        }
                    }
                    break block26;
                }
                catch (IOException e) {
                    try {
                        throw new StorageException("Project resource files couldn't be deleted.", e);
                    }
                    catch (Throwable var12_24) {
                        if (deleteFiles) {
                            projectFolder = new File(this.getResourceHelper().getProjectFolder(projectId));
                            try {
                                FileUtil.deleteFolder((File)projectFolder);
                            }
                            catch (IOException e) {
                                ModelUtil.logException((String)"Project files couldn't be deleted, but it was deleted from containment tree.", (Throwable)e);
                            }
                        }
                        throw var12_24;
                    }
                }
                if (!deleteFiles) break block26;
                projectFolder = new File(this.getResourceHelper().getProjectFolder(projectId));
                try {
                    FileUtil.deleteFolder((File)projectFolder);
                }
                catch (IOException e) {
                    ModelUtil.logException((String)"Project files couldn't be deleted, but it was deleted from containment tree.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectId importProjectHistoryToServer(ProjectHistory projectHistory) throws EmfStoreException {
        Object object = this.getMonitor();
        synchronized (object) {
            ProjectHistory projectOrNull = this.getProjectOrNull(projectHistory.getProjectId());
            if (projectOrNull != null) {
                projectHistory.setProjectId(org.eclipse.emf.emfstore.server.model.ModelFactory.eINSTANCE.createProjectId());
            }
            try {
                this.getResourceHelper().createResourceForProjectHistory(projectHistory);
                this.getServerSpace().getProjects().add((Object)projectHistory);
                this.getResourceHelper().save((EObject)this.getServerSpace());
                for (Version version : projectHistory.getVersions()) {
                    if (version.getChanges() != null) {
                        this.getResourceHelper().createResourceForChangePackage(version.getChanges(), version.getPrimarySpec(), projectHistory.getProjectId());
                    }
                    if (version.getProjectState() != null) {
                        this.getResourceHelper().createResourceForProject(version.getProjectState(), version.getPrimarySpec(), projectHistory.getProjectId());
                    }
                    this.getResourceHelper().createResourceForVersion(version, projectHistory.getProjectId());
                }
                this.getResourceHelper().save((EObject)projectHistory);
                this.getResourceHelper().saveAll();
            }
            catch (FatalEmfStoreException e) {
                this.deleteProject(projectHistory.getProjectId(), true, false);
                throw new StorageException("Couldn't save data in database.");
            }
            return (ProjectId)ModelUtil.clone((EObject)projectHistory.getProjectId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectHistory exportProjectHistoryFromServer(ProjectId projectId) throws EmfStoreException {
        Object object = this.getMonitor();
        synchronized (object) {
            return (ProjectHistory)ModelUtil.clone((EObject)this.getProject(projectId));
        }
    }

    private ProjectHistory createEmptyProject(String name, String description, LogMessage logMessage, Project initialProjectState) throws FatalEmfStoreException {
        ProjectHistory projectHistory = org.eclipse.emf.emfstore.server.model.ModelFactory.eINSTANCE.createProjectHistory();
        projectHistory.setProjectName(name);
        projectHistory.setProjectDescription(description);
        projectHistory.setProjectId(org.eclipse.emf.emfstore.server.model.ModelFactory.eINSTANCE.createProjectId());
        Version firstVersion = VersioningFactory.eINSTANCE.createVersion();
        firstVersion.setLogMessage(logMessage);
        PrimaryVersionSpec primary = VersioningFactory.eINSTANCE.createPrimaryVersionSpec();
        primary.setIdentifier(0);
        firstVersion.setPrimarySpec(primary);
        firstVersion.setProjectState(initialProjectState);
        this.getResourceHelper().createResourceForProject(initialProjectState, firstVersion.getPrimarySpec(), projectHistory.getProjectId());
        projectHistory.getVersions().add((Object)firstVersion);
        this.getResourceHelper().createResourceForVersion(firstVersion, projectHistory.getProjectId());
        this.getResourceHelper().createResourceForProjectHistory(projectHistory);
        this.getServerSpace().getProjects().add((Object)projectHistory);
        this.save((EObject)this.getServerSpace());
        return projectHistory;
    }

    private ProjectInfo createProjectInfo(ProjectHistory project) {
        ProjectInfo info = org.eclipse.emf.emfstore.server.model.ModelFactory.eINSTANCE.createProjectInfo();
        info.setName(project.getProjectName());
        info.setDescription(project.getProjectDescription());
        info.setProjectId((ProjectId)ModelUtil.clone((EObject)project.getProjectId()));
        info.setVersion((PrimaryVersionSpec)ModelUtil.clone((EObject)project.getLastVersion().getPrimarySpec()));
        return info;
    }
}

