/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.swt.internal.layout;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.model.common.AbstractGridCell;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.swt.layout.AbstractLayoutProvider;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ECPLayoutProvider
extends AbstractLayoutProvider {
    private static final Point DEFAULT_PREFERRED_SIZE = new Point(-1, -1);

    public Layout getColumnLayout(int numColumns, boolean equalWidth) {
        return GridLayoutFactory.fillDefaults().numColumns(numColumns).equalWidth(equalWidth).create();
    }

    public Layout getColumnLayout(int numColumns, boolean equalWidth, Point margins) {
        return GridLayoutFactory.fillDefaults().numColumns(numColumns).equalWidth(equalWidth).margins(margins).create();
    }

    public Object getLayoutData(SWTGridCell gridCell, SWTGridDescription controlGridDescription, SWTGridDescription currentRowGridDescription, SWTGridDescription fullGridDescription, VElement vElement, EObject domainModel, Control control) {
        return GridDataFactory.fillDefaults().align(this.getHorizontalAlignment(gridCell), this.getVerticalAlignment(gridCell)).hint(this.getPreferredSize(gridCell)).grab(gridCell.isHorizontalGrab(), gridCell.isVerticalGrab()).span(gridCell.getHorizontalSpan() + fullGridDescription.getColumns() - currentRowGridDescription.getColumns(), 1).create();
    }

    private Point getPreferredSize(SWTGridCell gridCell) {
        return gridCell.getPreferredSize() != null ? gridCell.getPreferredSize() : DEFAULT_PREFERRED_SIZE;
    }

    private int getHorizontalAlignment(SWTGridCell gridCell) {
        if (gridCell.isHorizontalFill()) {
            return 4;
        }
        if (gridCell.getHorizontalAlignment() != null) {
            return this.convertAlignment(gridCell.getHorizontalAlignment());
        }
        return 1;
    }

    private int getVerticalAlignment(SWTGridCell gridCell) {
        if (gridCell.isVerticalFill()) {
            return 4;
        }
        if (gridCell.getVerticalAlignment() != null) {
            return this.convertAlignment(gridCell.getVerticalAlignment());
        }
        return 0x1000000;
    }

    private int convertAlignment(AbstractGridCell.Alignment alignment) {
        switch (alignment) {
            case BEGINNING: {
                return 1;
            }
            case END: {
                return 0x1000008;
            }
        }
        return 0x1000000;
    }

    private GridData getSpanningGridData(int xSpan, int ySpan) {
        return GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(xSpan, ySpan).create();
    }

    public Object getSpanningLayoutData(int spanX, int spanY) {
        return this.getSpanningGridData(spanX, spanY);
    }
}

