/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.impl;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.emfstore.client.ESUsersession;
import org.eclipse.emf.emfstore.client.callbacks.ESCommitCallback;
import org.eclipse.emf.emfstore.client.callbacks.ESUpdateCallback;
import org.eclipse.emf.emfstore.client.changetracking.ESCommandStack;
import org.eclipse.emf.emfstore.client.handler.ESRunnableContext;
import org.eclipse.emf.emfstore.client.observer.ESLoginObserver;
import org.eclipse.emf.emfstore.client.observer.ESMergeObserver;
import org.eclipse.emf.emfstore.client.util.ESClientURIUtil;
import org.eclipse.emf.emfstore.client.util.RunESCommand;
import org.eclipse.emf.emfstore.common.ESObserver;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionElement;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;
import org.eclipse.emf.emfstore.internal.client.importexport.impl.ExportChangesController;
import org.eclipse.emf.emfstore.internal.client.importexport.impl.ExportProjectController;
import org.eclipse.emf.emfstore.internal.client.model.CompositeOperationHandle;
import org.eclipse.emf.emfstore.internal.client.model.Configuration;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.Usersession;
import org.eclipse.emf.emfstore.internal.client.model.Workspace;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.ConflictResolver;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.notification.recording.NotificationRecorder;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.ConnectionManager;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.ServerCall;
import org.eclipse.emf.emfstore.internal.client.model.controller.CommitController;
import org.eclipse.emf.emfstore.internal.client.model.controller.ShareController;
import org.eclipse.emf.emfstore.internal.client.model.controller.UpdateController;
import org.eclipse.emf.emfstore.internal.client.model.exceptions.ChangeConflictException;
import org.eclipse.emf.emfstore.internal.client.model.exceptions.IllegalProjectSpaceStateException;
import org.eclipse.emf.emfstore.internal.client.model.exceptions.MEUrlResolutionException;
import org.eclipse.emf.emfstore.internal.client.model.exceptions.PropertyNotFoundException;
import org.eclipse.emf.emfstore.internal.client.model.filetransfer.FileDownloadStatus;
import org.eclipse.emf.emfstore.internal.client.model.filetransfer.FileInformation;
import org.eclipse.emf.emfstore.internal.client.model.filetransfer.FileTransferManager;
import org.eclipse.emf.emfstore.internal.client.model.impl.ApplyOperationsAndRecordRunnable;
import org.eclipse.emf.emfstore.internal.client.model.impl.ApplyOperationsRunnable;
import org.eclipse.emf.emfstore.internal.client.model.impl.DefaultRunnableContext;
import org.eclipse.emf.emfstore.internal.client.model.impl.ESLocalProjectSaveStateNotifier;
import org.eclipse.emf.emfstore.internal.client.model.impl.Messages;
import org.eclipse.emf.emfstore.internal.client.model.impl.OperationManager;
import org.eclipse.emf.emfstore.internal.client.model.impl.ResourcePersister;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESLocalProjectImpl;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESUsersessionImpl;
import org.eclipse.emf.emfstore.internal.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.internal.client.observers.DeleteProjectSpaceObserver;
import org.eclipse.emf.emfstore.internal.client.properties.PropertyManager;
import org.eclipse.emf.emfstore.internal.common.ESDisposable;
import org.eclipse.emf.emfstore.internal.common.ExtensionRegistry;
import org.eclipse.emf.emfstore.internal.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.common.model.impl.IdentifiableElementImpl;
import org.eclipse.emf.emfstore.internal.common.model.impl.ProjectImpl;
import org.eclipse.emf.emfstore.internal.common.model.util.IResourceLogger;
import org.eclipse.emf.emfstore.internal.common.model.util.IdEObjectCollectionChangeObserver;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.SerializationException;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ChangeConflictSet;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ConflictBucket;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ConflictDetector;
import org.eclipse.emf.emfstore.internal.server.exceptions.FileTransferException;
import org.eclipse.emf.emfstore.internal.server.exceptions.InvalidVersionSpecException;
import org.eclipse.emf.emfstore.internal.server.model.FileIdentifier;
import org.eclipse.emf.emfstore.internal.server.model.ModelFactory;
import org.eclipse.emf.emfstore.internal.server.model.ProjectId;
import org.eclipse.emf.emfstore.internal.server.model.ProjectInfo;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.OrgUnitProperty;
import org.eclipse.emf.emfstore.internal.server.model.url.ModelElementUrlFragment;
import org.eclipse.emf.emfstore.internal.server.model.versioning.AbstractChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.BranchInfo;
import org.eclipse.emf.emfstore.internal.server.model.versioning.BranchVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.FileBasedChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.LogMessage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.TagVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersioningFactory;
import org.eclipse.emf.emfstore.internal.server.model.versioning.Versions;
import org.eclipse.emf.emfstore.internal.server.model.versioning.impl.FileBasedChangePackageImpl;
import org.eclipse.emf.emfstore.internal.server.model.versioning.impl.persistent.ChangePackageContainer;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.CreateDeleteOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.util.ChangePackageUtil;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.util.OperationUtil;
import org.eclipse.emf.emfstore.server.ESCloseableIterable;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.emf.emfstore.server.model.ESChangePackage;
import org.eclipse.emf.emfstore.server.model.versionspec.ESPrimaryVersionSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProjectSpaceBase
extends IdentifiableElementImpl
implements ProjectSpace,
ESLoginObserver,
ESDisposable,
ChangePackageContainer {
    private ESLocalProjectImpl esLocalProjectImpl;
    private boolean initCompleted;
    private boolean isTransient;
    private boolean disposed;
    private FileTransferManager fileTransferManager;
    private OperationManager operationManager;
    private PropertyManager propertyManager;
    private final Map<String, OrgUnitProperty> propertyMap = new LinkedHashMap<String, OrgUnitProperty>();
    private ResourceSet resourceSet;
    private ResourcePersister resourcePersister;
    private ECrossReferenceAdapter crossReferenceAdapter;
    private ESRunnableContext runnableContext;

    public ProjectSpaceBase() {
        this.initRunnableContext();
    }

    @Override
    public void setRunnableContext(ESRunnableContext runnableContext) {
        this.runnableContext = runnableContext;
    }

    private void initRunnableContext() {
        this.runnableContext = (ESRunnableContext)ExtensionRegistry.INSTANCE.get("org.eclipse.emf.emfstore.client.runnableChangeContext", ESRunnableContext.class, (Object)new DefaultRunnableContext(), true);
    }

    @Override
    public FileIdentifier addFile(File file) throws FileTransferException {
        return this.fileTransferManager.addFile(file);
    }

    @Override
    public FileIdentifier addFile(File file, String fileIdentifier) throws FileTransferException {
        return this.fileTransferManager.addFile(file, fileIdentifier);
    }

    @Override
    public void addOperations(List<? extends AbstractOperation> operations) {
        ArrayList<AbstractOperation> ops = new ArrayList<AbstractOperation>();
        for (AbstractOperation abstractOperation : operations) {
            ops.add(abstractOperation);
        }
        this.getLocalChangePackage().addAll(ops);
        this.updateDirtyState();
        for (AbstractOperation abstractOperation : operations) {
            this.operationManager.notifyOperationExecuted(abstractOperation);
        }
    }

    @Override
    public void addTag(PrimaryVersionSpec versionSpec, TagVersionSpec tag) throws ESException {
        ConnectionManager cm = ESWorkspaceProviderImpl.getInstance().getConnectionManager();
        cm.addTag(this.getUsersession().getSessionId(), this.getProjectId(), versionSpec, tag);
    }

    public void applyChanges(PrimaryVersionSpec baseSpec, List<AbstractChangePackage> incomingChangePackages, AbstractChangePackage myChanges, IProgressMonitor progressMonitor, boolean runChecksumCheckOnBaseSpec) throws ESException {
        this.notifyPreRevertMyChanges(this.getLocalChangePackage());
        this.revert();
        this.notifyPostRevertMyChanges();
        this.applyChangePackages(incomingChangePackages, false);
        if (runChecksumCheckOnBaseSpec) {
            this.runChecksumTests(baseSpec, incomingChangePackages, progressMonitor);
        }
        this.notifyPostApplyTheirChanges(incomingChangePackages);
        this.reapplyLocalChanges(myChanges);
        this.notifyPostApplyMergedChanges(myChanges);
        this.setBaseVersion(baseSpec);
        this.save();
    }

    private void reapplyLocalChanges(AbstractChangePackage myChangePackage) {
        ESCloseableIterable operations = myChangePackage.operations();
        try {
            if (Configuration.getClientBehavior().isRerecordingActivated().booleanValue()) {
                this.applyOperationsWithRerecording(operations.iterable());
            } else {
                this.applyOperations(operations.iterable(), true);
            }
        }
        finally {
            operations.close();
        }
    }

    private void runChecksumTests(PrimaryVersionSpec baseSpec, List<AbstractChangePackage> incomingChangePackages, IProgressMonitor progressMonitor) throws ESException {
        progressMonitor.subTask(Messages.ProjectSpaceBase_Computing_Checksum);
        if (!this.performChecksumCheck(baseSpec, this.getProject())) {
            progressMonitor.subTask(Messages.ProjectSpaceBase_Activate_ChecksumErrorHandler_Invalid_Chekcum);
            boolean errorHandled = Configuration.getClientBehavior().getChecksumErrorHandler().execute(this.toAPI(), (ESPrimaryVersionSpec)baseSpec.toAPI(), progressMonitor);
            if (!errorHandled) {
                int i = incomingChangePackages.size() - 1;
                while (i >= 0) {
                    ESCloseableIterable reversedOperations = incomingChangePackages.get(i).reversedOperations();
                    try {
                        this.applyChangePackage(reversedOperations.iterable(), false);
                    }
                    finally {
                        reversedOperations.close();
                    }
                    --i;
                }
                throw new ESException(Messages.ProjectSpaceBase_Update_Cancelled_Invalid_Checksum);
            }
        }
    }

    private void applyChangePackage(Iterable<AbstractOperation> operations, boolean addOperations) {
        this.applyOperations(operations, addOperations);
    }

    private void applyChangePackages(Iterable<AbstractChangePackage> changePackages, boolean addOperations) {
        for (AbstractChangePackage changePackage : changePackages) {
            ESCloseableIterable operations = changePackage.operations();
            try {
                this.applyChangePackage(operations.iterable(), addOperations);
            }
            finally {
                operations.close();
            }
        }
    }

    private boolean performChecksumCheck(PrimaryVersionSpec baseVersion, Project project) {
        if (Configuration.getClientBehavior().isChecksumCheckActive()) {
            long expectedChecksum = baseVersion.getProjectStateChecksum();
            try {
                long computedChecksum = ModelUtil.computeChecksum((IdEObjectCollection)project);
                return expectedChecksum == computedChecksum;
            }
            catch (SerializationException e) {
                WorkspaceUtil.logWarning(Messages.ProjectSpaceBase_Cannot_Compute_Checksum, (Exception)((Object)e));
            }
        }
        return true;
    }

    public void applyOperations(Iterable<AbstractOperation> operations, boolean addOperations) {
        this.executeRunnable(new ApplyOperationsRunnable(this, operations, addOperations));
    }

    public void applyOperationsWithRerecording(Iterable<AbstractOperation> operations) {
        this.executeRunnable(new ApplyOperationsAndRecordRunnable(this, operations));
    }

    public void executeRunnable(Runnable runnable) {
        this.getRunnableContext().executeRunnable(runnable);
    }

    @Override
    public CompositeOperationHandle beginCompositeOperation() {
        return this.operationManager.beginCompositeOperation();
    }

    public void cleanCutElements() {
        ArrayList cutElements = new ArrayList(this.getProject().getCutElements());
        for (EObject cutElement : cutElements) {
            this.getProject().deleteModelElement(cutElement);
        }
    }

    @Override
    public PrimaryVersionSpec commit(IProgressMonitor monitor) throws ESException {
        return (PrimaryVersionSpec)new CommitController(this, null, null, monitor).execute();
    }

    @Override
    public PrimaryVersionSpec commit(String logMessage, ESCommitCallback callback, IProgressMonitor monitor) throws ESException {
        return (PrimaryVersionSpec)new CommitController(this, logMessage, callback, monitor).execute();
    }

    @Override
    public PrimaryVersionSpec commitToBranch(BranchVersionSpec branch, String logMessage, ESCommitCallback callback, IProgressMonitor monitor) throws ESException {
        return (PrimaryVersionSpec)new CommitController(this, branch, logMessage, callback, monitor).execute();
    }

    @Override
    public void exportLocalChanges(File file, IProgressMonitor progressMonitor) throws IOException {
        new ExportChangesController(this).execute(file, progressMonitor);
    }

    @Override
    public void exportLocalChanges(File file) throws IOException {
        new ExportChangesController(this).execute(file, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public void exportProject(File file, IProgressMonitor progressMonitor) throws IOException {
        new ExportProjectController(this).execute(file, progressMonitor);
    }

    @Override
    public void exportProject(File file) throws IOException {
        new ExportProjectController(this).execute(file, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public List<AbstractChangePackage> getChanges(VersionSpec sourceVersion, VersionSpec targetVersion) throws InvalidVersionSpecException, ESException {
        ConnectionManager connectionManager = ESWorkspaceProviderImpl.getInstance().getConnectionManager();
        List changes = connectionManager.getChanges(this.getUsersession().getSessionId(), this.getProjectId(), sourceVersion, targetVersion);
        return changes;
    }

    @Override
    public FileDownloadStatus getFile(FileIdentifier fileIdentifier) throws FileTransferException {
        return this.fileTransferManager.getFile(fileIdentifier, false);
    }

    @Override
    public FileInformation getFileInfo(FileIdentifier fileIdentifier) {
        return this.fileTransferManager.getFileInfo(fileIdentifier);
    }

    @Override
    public AbstractChangePackage getLocalChangePackage(boolean canonize) {
        AbstractChangePackage changePackage = ChangePackageUtil.createChangePackage((boolean)Configuration.getClientBehavior().useInMemoryChangePackage());
        ESCloseableIterable operations = this.getLocalChangePackage().operations();
        try {
            for (AbstractOperation operation : operations.iterable()) {
                AbstractOperation clonedOperation = (AbstractOperation)ModelUtil.clone((EObject)operation);
                changePackage.add(clonedOperation);
            }
        }
        finally {
            operations.close();
        }
        LogMessage logMessage = VersioningFactory.eINSTANCE.createLogMessage();
        if (this.getUsersession() != null) {
            logMessage.setAuthor(this.getUsersession().getUsername());
        } else {
            logMessage.setAuthor(Messages.ProjectSpaceBase_Unknown_Author);
        }
        logMessage.setClientDate(new Date());
        changePackage.setLogMessage(logMessage);
        return changePackage;
    }

    public NotificationRecorder getNotificationRecorder() {
        return this.operationManager.getNotificationRecorder();
    }

    @Override
    public OperationManager getOperationManager() {
        return this.operationManager;
    }

    @Override
    public ProjectInfo getProjectInfo() {
        ProjectInfo projectInfo = ModelFactory.eINSTANCE.createProjectInfo();
        projectInfo.setProjectId((ProjectId)ModelUtil.clone((EObject)this.getProjectId()));
        projectInfo.setName(this.getProjectName());
        projectInfo.setDescription(this.getProjectDescription());
        projectInfo.setVersion((PrimaryVersionSpec)ModelUtil.clone((EObject)this.getBaseVersion()));
        return projectInfo;
    }

    @Override
    public PropertyManager getPropertyManager() {
        if (this.propertyManager == null) {
            this.propertyManager = new PropertyManager(this);
        }
        return this.propertyManager;
    }

    private OrgUnitProperty getProperty(String name) throws PropertyNotFoundException {
        OrgUnitProperty orgUnitProperty;
        if (this.getUsersession() != null && this.getUsersession().getACUser() != null && (orgUnitProperty = this.propertyMap.get(name)) != null) {
            return orgUnitProperty;
        }
        throw new PropertyNotFoundException(MessageFormat.format(Messages.ProjectSpaceBase_Property_Not_Found, name));
    }

    @Override
    public void importLocalChanges(String fileName) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(URI.createFileURI((String)fileName), true);
        EList directContents = resource.getContents();
        if (directContents.size() != 1 && !(directContents.get(0) instanceof ChangePackage)) {
            throw new IOException(Messages.ProjectSpaceBase_Corrupt_File);
        }
        AbstractChangePackage changePackage = (AbstractChangePackage)directContents.get(0);
        if (!this.initCompleted) {
            this.init();
        }
        ESCloseableIterable operations = changePackage.operations();
        try {
            this.applyOperations(operations.iterable(), true);
        }
        finally {
            operations.close();
        }
    }

    @Override
    public void init() {
        this.initCrossReferenceAdapter();
        ESCommandStack commandStack = (ESCommandStack)ESWorkspaceProviderImpl.getInstance().getEditingDomain().getCommandStack();
        this.fileTransferManager = new FileTransferManager(this);
        this.operationManager = new OperationManager(this);
        this.initPropertyMap();
        URI localChangePackageUri = ESClientURIUtil.createOperationsURI(this);
        AbstractChangePackage localChangePackage = this.getLocalChangePackage();
        if (localChangePackage == null) {
            if (Configuration.getClientBehavior().useInMemoryChangePackage()) {
                localChangePackage = VersioningFactory.eINSTANCE.createChangePackage();
                Resource resource = this.getResourceSet().getResource(localChangePackageUri, false);
                resource.getContents().add((Object)localChangePackage);
            } else {
                URI normalizedUri = this.getResourceSet().getURIConverter().normalize(localChangePackageUri);
                String filePath = normalizedUri.toFileString();
                localChangePackage = VersioningFactory.eINSTANCE.createFileBasedChangePackage();
                ((FileBasedChangePackage)localChangePackage).initialize(filePath);
            }
            this.setChangePackage(localChangePackage);
        } else if (!Configuration.getClientBehavior().useInMemoryChangePackage()) {
            FileBasedChangePackage changePackage = (FileBasedChangePackage)this.getLocalChangePackage();
            try {
                FileUtils.copyFile((File)new File(changePackage.getFilePath()), (File)new File(changePackage.getTempFilePath()));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        this.initResourcePersister();
        commandStack.addCommandStackObserver(this.resourcePersister);
        commandStack.addCommandStackObserver(this.operationManager);
        this.getProject().addIdEObjectCollectionChangeObserver((IdEObjectCollectionChangeObserver)this.operationManager);
        this.getProject().addIdEObjectCollectionChangeObserver((IdEObjectCollectionChangeObserver)this.resourcePersister);
        if (this.getProject() instanceof ProjectImpl) {
            ((ProjectImpl)this.getProject()).setUndetachable((IdEObjectCollectionChangeObserver)this.operationManager);
            ((ProjectImpl)this.getProject()).setUndetachable((IdEObjectCollectionChangeObserver)this.resourcePersister);
        }
        this.initCompleted = true;
        this.startChangeRecording();
        this.cleanCutElements();
    }

    private void initPropertyMap() {
        if (this.getUsersession() != null) {
            ESWorkspaceProviderImpl.getObserverBus().register((ESObserver)this, new Class[]{ESLoginObserver.class});
            ACUser acUser = this.getUsersession().getACUser();
            if (acUser != null) {
                for (OrgUnitProperty p : acUser.getProperties()) {
                    if (p.getProject() == null || !p.getProject().equals(this.getProjectId())) continue;
                    this.propertyMap.put(p.getName(), p);
                }
            }
        }
    }

    private void initCrossReferenceAdapter() {
        boolean useCrossReferenceAdapter = true;
        for (ESExtensionElement element : new ESExtensionPoint("org.eclipse.emf.emfstore.client.inverseCrossReferenceCache").getExtensionElements()) {
            useCrossReferenceAdapter &= element.getBoolean("activated").booleanValue();
        }
        if (useCrossReferenceAdapter) {
            this.crossReferenceAdapter = new ECrossReferenceAdapter();
            this.getProject().eAdapters().add((Object)this.crossReferenceAdapter);
        }
    }

    private void initResourcePersister() {
        this.resourcePersister = new ResourcePersister(this.toAPI());
        if (!this.isTransient) {
            this.resourcePersister.addResource(this.eResource());
            this.resourcePersister.addResource(this.getLocalChangePackage().eResource());
            this.resourcePersister.addResource(this.getProject().eResource());
            this.resourcePersister.addDirtyStateChangeLister(new ESLocalProjectSaveStateNotifier(this.toAPI()));
            ESWorkspaceProviderImpl.getObserverBus().register((ESObserver)this.resourcePersister);
        }
    }

    public FileTransferManager getFileTransferManager() {
        return this.fileTransferManager;
    }

    @Override
    public void initResources(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
        this.initCompleted = true;
        URI projectSpaceURI = ESClientURIUtil.createProjectSpaceURI(this);
        URI operationsURI = ESClientURIUtil.createOperationsURI(this);
        URI projectURI = ESClientURIUtil.createProjectURI(this);
        this.setResourceCount(0);
        ArrayList<Resource> resources = new ArrayList<Resource>();
        Resource resource = resourceSet.createResource(projectURI);
        resource.getContents().add((Object)this.getProject());
        resources.add(resource);
        this.setResourceCount(this.getResourceCount() + 1);
        for (EObject modelElement : this.getProject().getAllModelElements()) {
            ((XMIResource)resource).setID(modelElement, this.getProject().getModelElementId(modelElement).getId());
        }
        Resource localChangePackageResource = resourceSet.createResource(operationsURI);
        resources.add(localChangePackageResource);
        Resource projectSpaceResource = resourceSet.createResource(projectSpaceURI);
        projectSpaceResource.getContents().add((Object)this);
        resources.add(projectSpaceResource);
        for (Resource currentResource : resources) {
            try {
                ModelUtil.saveResource((Resource)currentResource, (IResourceLogger)WorkspaceUtil.getResourceLogger());
            }
            catch (IOException e) {
                WorkspaceUtil.logException(Messages.ProjectSpaceBase_Resource_Init_Failed, e);
            }
        }
        this.init();
    }

    @Override
    public void delete(IProgressMonitor monitor) throws IOException {
        ((DeleteProjectSpaceObserver)ESWorkspaceProviderImpl.getObserverBus().notify(DeleteProjectSpaceObserver.class)).projectSpaceDeleted(this);
        this.getProject().delete();
        this.deleteResource(this.getProject().eResource());
        this.deleteResource(this.eResource());
        if (FileBasedChangePackage.class.isInstance(this.getLocalChangePackage())) {
            ((FileBasedChangePackageImpl)FileBasedChangePackageImpl.class.cast(this.getLocalChangePackage())).delete();
        } else {
            URI localChangePackageUri = ESClientURIUtil.createOperationsURI(this);
            URI normalizedUri = this.getResourceSet().getURIConverter().normalize(localChangePackageUri);
            String fileString = normalizedUri.toFileString();
            File operationsFile = new File(fileString);
            operationsFile.delete();
            boolean isDeleted = !operationsFile.exists();
            int retries = 0;
            while (!isDeleted && retries < 3) {
                operationsFile.delete();
                isDeleted = !operationsFile.exists();
                ++retries;
            }
        }
        ESWorkspaceProviderImpl.getInstance().getInternalWorkspace().getProjectSpaces().remove((Object)this);
        this.dispose();
    }

    private void deleteResource(Resource resource) throws IOException {
        if (resource != null) {
            resource.delete(null);
        }
    }

    public Collection<EStructuralFeature.Setting> findInverseCrossReferences(EObject modelElement) {
        if (this.crossReferenceAdapter != null) {
            return this.crossReferenceAdapter.getInverseReferences(modelElement);
        }
        return EcoreUtil.UsageCrossReferencer.find((EObject)modelElement, (ResourceSet)this.resourceSet);
    }

    @Override
    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    @Override
    public void setResourceSet(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    @Override
    public boolean isTransient() {
        return this.isTransient;
    }

    @Override
    public boolean isUpdated() throws ESException {
        PrimaryVersionSpec headVersion = this.resolveVersionSpec((VersionSpec)Versions.createHEAD((VersionSpec)this.getBaseVersion()), (IProgressMonitor)new NullProgressMonitor());
        return this.getBaseVersion().equals(headVersion);
    }

    @Override
    public void loginCompleted(ESUsersession session) {
        if (this.getUsersession() == null || !((ESUsersessionImpl)this.getUsersession().toAPI()).equals(session)) {
            return;
        }
        try {
            this.transmitProperties();
        }
        catch (RuntimeException e) {
            WorkspaceUtil.logException(Messages.ProjectSpaceBase_Transmit_Properties_Failed, e);
        }
    }

    @Override
    public void makeTransient() {
        if (this.initCompleted) {
            throw new IllegalAccessError(Messages.ProjectSpaceBase_Make_Transient_Error);
        }
        this.isTransient = true;
    }

    @Override
    public void mergeBranch(final PrimaryVersionSpec branchSpec, ConflictResolver conflictResolver, final IProgressMonitor monitor) throws ESException {
        if (branchSpec == null || conflictResolver == null) {
            throw new IllegalArgumentException(Messages.ProjectSpaceBase_Arguments_Must_Not_Be_Null);
        }
        if (Versions.isSameBranch((VersionSpec)this.getBaseVersion(), (VersionSpec)branchSpec)) {
            throw new InvalidVersionSpecException(Messages.ProjectSpaceBase_Cannot_Merge_Branch_With_Itself);
        }
        PrimaryVersionSpec commonAncestor = (PrimaryVersionSpec)new ServerCall<PrimaryVersionSpec>((ProjectSpace)this){

            @Override
            protected PrimaryVersionSpec run() throws ESException {
                return ProjectSpaceBase.this.resolveVersionSpec((VersionSpec)Versions.createANCESTOR((PrimaryVersionSpec)ProjectSpaceBase.this.getBaseVersion(), (PrimaryVersionSpec)branchSpec), monitor);
            }
        }.execute();
        final List<AbstractChangePackage> baseChanges = this.getChanges((VersionSpec)commonAncestor, (VersionSpec)this.getBaseVersion());
        List<AbstractChangePackage> branchChanges = this.getChanges((VersionSpec)commonAncestor, (VersionSpec)branchSpec);
        ChangeConflictSet conflictSet = new ConflictDetector().calculateConflicts(branchChanges, baseChanges, this.getProject());
        if (conflictResolver.resolveConflicts(this.getProject(), conflictSet)) {
            final AbstractChangePackage copyOfResolvedConflicts = this.mergeResolvedConflicts(conflictSet, branchChanges, baseChanges);
            RunESCommand.WithException.run(ESException.class, new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ProjectSpaceBase.this.applyChanges(ProjectSpaceBase.this.getBaseVersion(), baseChanges, copyOfResolvedConflicts, monitor, false);
                    ProjectSpaceBase.this.setMergedVersion((PrimaryVersionSpec)ModelUtil.clone((EObject)branchSpec));
                    return null;
                }
            });
        }
    }

    @Override
    public AbstractChangePackage mergeResolvedConflicts(ChangeConflictSet conflictSet, List<AbstractChangePackage> myChangePackages, List<AbstractChangePackage> theirChangePackages) throws ChangeConflictException {
        LinkedHashSet<AbstractOperation> accceptedMineSet = new LinkedHashSet<AbstractOperation>();
        LinkedHashSet<AbstractOperation> rejectedTheirsSet = new LinkedHashSet<AbstractOperation>();
        for (ConflictBucket conflict : conflictSet.getConflictBuckets()) {
            if (!conflict.isResolved()) {
                throw new ChangeConflictException(Messages.ProjectSpaceBase_Conflict_During_Update_No_Resolution, conflictSet);
            }
            accceptedMineSet.addAll(conflict.getAcceptedLocalOperations());
            rejectedTheirsSet.addAll(conflict.getRejectedRemoteOperations());
        }
        LinkedList<AbstractOperation> acceptedMineList = new LinkedList<AbstractOperation>();
        for (AbstractChangePackage locChangePackage : myChangePackages) {
            ESCloseableIterable operations = locChangePackage.operations();
            try {
                block8: for (AbstractOperation myOperation : operations.iterable()) {
                    Set notInvolvedInConflict = conflictSet.getNotInvolvedInConflict();
                    ArrayList<AbstractOperation> ops = new ArrayList<AbstractOperation>(notInvolvedInConflict);
                    if (ProjectSpaceBase.containsOp(ops, myOperation)) {
                        acceptedMineList.add(myOperation);
                    } else if (ProjectSpaceBase.containsOp(accceptedMineSet, myOperation)) {
                        acceptedMineList.add(myOperation);
                    }
                    Iterator iterator = accceptedMineSet.iterator();
                    while (iterator.hasNext()) {
                        AbstractOperation operation = (AbstractOperation)iterator.next();
                        if (!operation.getIdentifier().equals(myOperation.getIdentifier())) continue;
                        iterator.remove();
                        continue block8;
                    }
                }
            }
            finally {
                operations.close();
            }
        }
        acceptedMineList.addAll(accceptedMineSet);
        LinkedList<AbstractOperation> rejectedTheirsList = new LinkedList<AbstractOperation>();
        for (AbstractChangePackage theirCP : theirChangePackages) {
            ESCloseableIterable operations = theirCP.operations();
            try {
                for (AbstractOperation theirOperation : operations.iterable()) {
                    if (!ProjectSpaceBase.containsOp(rejectedTheirsSet, theirOperation)) continue;
                    rejectedTheirsList.add(theirOperation);
                }
            }
            finally {
                operations.close();
            }
        }
        ArrayList<AbstractOperation> mergeResult = new ArrayList<AbstractOperation>(rejectedTheirsList.size() + acceptedMineList.size());
        for (AbstractOperation operationToReverse : rejectedTheirsList) {
            mergeResult.add(0, operationToReverse.reverse());
        }
        mergeResult.addAll(acceptedMineList);
        AbstractChangePackage result = ChangePackageUtil.createChangePackage((boolean)Configuration.getClientBehavior().useInMemoryChangePackage());
        result.addAll(mergeResult);
        return result;
    }

    private static boolean containsOp(Collection<AbstractOperation> ops, AbstractOperation op) {
        for (AbstractOperation abstractOperation : ops) {
            if (OperationUtil.isCreateDelete((AbstractOperation)abstractOperation) && OperationUtil.isCreateDelete((AbstractOperation)op)) {
                CreateDeleteOperation createDeleteOperation = (CreateDeleteOperation)CreateDeleteOperation.class.cast(abstractOperation);
                CreateDeleteOperation otherCreateDeleteOperation = (CreateDeleteOperation)CreateDeleteOperation.class.cast(op);
                if (!createDeleteOperation.getOperationId().equals(otherCreateDeleteOperation.getOperationId()) || !createDeleteOperation.getModelElementId().equals(otherCreateDeleteOperation.getModelElementId())) continue;
                return true;
            }
            if (!abstractOperation.getOperationId().equals(op.getOperationId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<BranchInfo> getBranches() throws ESException {
        return (List)new ServerCall<List<BranchInfo>>((ProjectSpace)this){

            @Override
            protected List<BranchInfo> run() throws ESException {
                ConnectionManager cm = ESWorkspaceProviderImpl.getInstance().getConnectionManager();
                return cm.getBranches(this.getSessionId(), ProjectSpaceBase.this.getProjectId());
            }
        }.execute();
    }

    @Override
    public void removeTag(PrimaryVersionSpec versionSpec, TagVersionSpec tag) throws ESException {
        ConnectionManager cm = ESWorkspaceProviderImpl.getInstance().getConnectionManager();
        cm.removeTag(this.getUsersession().getSessionId(), this.getProjectId(), versionSpec, tag);
    }

    @Override
    public EObject resolve(ModelElementUrlFragment modelElementUrlFragment) throws MEUrlResolutionException {
        ModelElementId modelElementId = modelElementUrlFragment.getModelElementId();
        EObject modelElement = this.getProject().getModelElement(modelElementId);
        if (modelElement == null) {
            throw new MEUrlResolutionException();
        }
        return modelElement;
    }

    @Override
    public PrimaryVersionSpec resolveVersionSpec(final VersionSpec versionSpec, IProgressMonitor monitor) throws InvalidVersionSpecException, ESException {
        return (PrimaryVersionSpec)new ServerCall<PrimaryVersionSpec>((ProjectSpace)this, monitor){

            @Override
            protected PrimaryVersionSpec run() throws ESException {
                return this.getConnectionManager().resolveVersionSpec(this.getSessionId(), ProjectSpaceBase.this.getProjectId(), versionSpec);
            }
        }.execute();
    }

    @Override
    public void revert() {
        while (!this.getLocalChangePackage().isEmpty()) {
            this.undoLastOperation();
        }
        this.updateDirtyState();
    }

    public void saveProjectSpaceOnly() {
        this.saveResource(this.eResource());
    }

    @Override
    public void save() {
        this.saveProjectSpaceOnly();
        this.saveChangePackage();
        this.resourcePersister.saveDirtyResources(true);
    }

    @Override
    public boolean hasUnsavedChanges() {
        if (this.resourcePersister != null) {
            return this.resourcePersister.isDirty();
        }
        return false;
    }

    private void saveChangePackage() {
        try {
            this.getLocalChangePackage().save();
        }
        catch (IOException e) {
            WorkspaceUtil.logException(String.valueOf(Messages.ProjectSpaceBase_Error_During_Save) + Messages.ProjectSpaceBase_Delete_Project_And_Checkout_Again, e);
        }
    }

    public void saveResource(Resource resource) {
        try {
            if (resource == null) {
                if (!this.isTransient) {
                    WorkspaceUtil.logException(Messages.ProjectSpaceBase_Resource_Not_Initialized, (Exception)((Object)new IllegalProjectSpaceStateException(Messages.ProjectSpaceBase_Resource_Is_Null)));
                }
                return;
            }
            ModelUtil.saveResource((Resource)resource, (IResourceLogger)WorkspaceUtil.getResourceLogger());
        }
        catch (IOException e) {
            WorkspaceUtil.logException(String.valueOf(Messages.ProjectSpaceBase_Error_During_Save) + Messages.ProjectSpaceBase_Delete_Project_And_Checkout_Again, e);
        }
    }

    @Override
    public void setProperty(OrgUnitProperty property) {
        if (this.getUsersession() != null && this.getUsersession().getACUser() != null) {
            try {
                if (property.getProject() == null) {
                    property.setProject((ProjectId)ModelUtil.clone((EObject)this.getProjectId()));
                } else if (!property.getProject().equals(this.getProjectId())) {
                    return;
                }
                OrgUnitProperty prop = this.getProperty(property.getName());
                prop.setValue(property.getValue());
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                this.getUsersession().getACUser().getProperties().add((Object)property);
                this.propertyMap.put(property.getName(), property);
            }
            for (OrgUnitProperty changedProperty : this.getUsersession().getChangedProperties()) {
                if (!changedProperty.getName().equals(property.getName()) || !changedProperty.getProject().equals(this.getProjectId())) continue;
                changedProperty.setValue(property.getValue());
                ((Workspace)ESWorkspaceProviderImpl.getInstance().getWorkspace().toInternalAPI()).save();
                return;
            }
            this.getUsersession().getChangedProperties().add((Object)property);
            ((Workspace)ESWorkspaceProviderImpl.getInstance().getWorkspace().toInternalAPI()).save();
        }
    }

    @Override
    public ProjectInfo shareProject(IProgressMonitor monitor) throws ESException {
        return this.shareProject(null, monitor);
    }

    @Override
    public ProjectInfo shareProject(Usersession session, IProgressMonitor monitor) throws ESException {
        return (ProjectInfo)new ShareController(this, session, monitor).execute();
    }

    public void startChangeRecording() {
        this.operationManager.startChangeRecording();
        this.updateDirtyState();
    }

    public void stopChangeRecording() {
        if (this.operationManager != null) {
            this.operationManager.stopChangeRecording();
        }
    }

    @Override
    public void transmitProperties() {
        ArrayList<OrgUnitProperty> temp = new ArrayList<OrgUnitProperty>();
        for (OrgUnitProperty changedProperty : this.getUsersession().getChangedProperties()) {
            if (changedProperty.getProject() == null || !changedProperty.getProject().equals(this.getProjectId())) continue;
            temp.add(changedProperty);
        }
        ListIterator iterator = temp.listIterator();
        while (iterator.hasNext()) {
            try {
                ESWorkspaceProviderImpl.getInstance().getConnectionManager().transmitProperty(this.getUsersession().getSessionId(), (OrgUnitProperty)iterator.next(), this.getUsersession().getACUser(), this.getProjectId());
                iterator.remove();
            }
            catch (ESException e) {
                WorkspaceUtil.logException(Messages.ProjectSpaceBase_Transmission_Of_Properties_Failed, (Exception)((Object)e));
            }
        }
    }

    @Override
    public void undoLastOperation() {
        this.undoLastOperations(1);
    }

    @Override
    public void undoLastOperations(int numberOfOperations) {
        if (numberOfOperations <= 0) {
            return;
        }
        if (!this.getLocalChangePackage().isEmpty()) {
            List operations = this.getLocalChangePackage().removeAtEnd(1);
            AbstractOperation lastOperation = (AbstractOperation)operations.get(0);
            AbstractOperation reversedOperation = lastOperation.reverse();
            List<AbstractOperation> iterable = Collections.singletonList(reversedOperation);
            this.applyOperations(iterable, false);
            this.operationManager.notifyOperationUndone(lastOperation);
            this.undoLastOperations(--numberOfOperations);
        }
        this.updateDirtyState();
    }

    @Override
    public PrimaryVersionSpec update(IProgressMonitor monitor) throws ESException {
        return this.update((VersionSpec)Versions.createHEAD((VersionSpec)this.getBaseVersion()), null, monitor);
    }

    @Override
    public PrimaryVersionSpec update(VersionSpec version) throws ESException {
        return this.update(version, null, null);
    }

    @Override
    public PrimaryVersionSpec update(VersionSpec version, ESUpdateCallback callback, IProgressMonitor progress) throws ESException {
        return (PrimaryVersionSpec)new UpdateController(this, version, callback, progress).execute();
    }

    public void updateDirtyState() {
        boolean isEmpty = true;
        AbstractChangePackage localChangePackage = this.getLocalChangePackage();
        if (localChangePackage == null) {
            return;
        }
        isEmpty = localChangePackage.isEmpty();
        if (this.isDirty() == !isEmpty) {
            return;
        }
        this.setDirty(!isEmpty);
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.stopChangeRecording();
        if (this.crossReferenceAdapter != null) {
            this.getProject().eAdapters().remove((Object)this.crossReferenceAdapter);
        }
        ESCommandStack commandStack = (ESCommandStack)ESWorkspaceProviderImpl.getInstance().getEditingDomain().getCommandStack();
        commandStack.removeCommandStackObserver(this.operationManager);
        commandStack.removeCommandStackObserver(this.resourcePersister);
        this.getProject().removeIdEObjectCollectionChangeObserver((IdEObjectCollectionChangeObserver)this.operationManager);
        this.getProject().removeIdEObjectCollectionChangeObserver((IdEObjectCollectionChangeObserver)this.resourcePersister);
        ESWorkspaceProviderImpl.getObserverBus().unregister((ESObserver)this.resourcePersister);
        ESWorkspaceProviderImpl.getObserverBus().unregister((ESObserver)this, new Class[]{ESLoginObserver.class});
        ESWorkspaceProviderImpl.getObserverBus().unregister((ESObserver)this);
        this.operationManager.dispose();
        this.resourcePersister.dispose();
        this.disposed = true;
    }

    @Override
    public boolean isShared() {
        return this.getUsersession() != null && this.getBaseVersion() != null;
    }

    private void notifyPreRevertMyChanges(AbstractChangePackage changePackage) {
        ((ESMergeObserver)ESWorkspaceProviderImpl.getObserverBus().notify(ESMergeObserver.class)).preRevertMyChanges(this.toAPI(), changePackage.toAPI());
    }

    private void notifyPostRevertMyChanges() {
        ((ESMergeObserver)ESWorkspaceProviderImpl.getObserverBus().notify(ESMergeObserver.class)).postRevertMyChanges(this.toAPI());
    }

    private void notifyPostApplyTheirChanges(List<AbstractChangePackage> theirChangePackages) {
        ArrayList<ESChangePackage> changePackages = new ArrayList<ESChangePackage>();
        for (AbstractChangePackage theirChangePackage : theirChangePackages) {
            changePackages.add(theirChangePackage.toAPI());
        }
        ((ESMergeObserver)ESWorkspaceProviderImpl.getObserverBus().notify(ESMergeObserver.class)).postApplyTheirChanges(this.toAPI(), changePackages);
    }

    private void notifyPostApplyMergedChanges(AbstractChangePackage changePackage) {
        ((ESMergeObserver)ESWorkspaceProviderImpl.getObserverBus().notify(ESMergeObserver.class)).postApplyMergedChanges(this.toAPI(), changePackage.toAPI());
    }

    public ESLocalProjectImpl toAPI() {
        if (this.esLocalProjectImpl == null) {
            this.esLocalProjectImpl = this.createAPI();
        }
        return this.esLocalProjectImpl;
    }

    public ESLocalProjectImpl createAPI() {
        return new ESLocalProjectImpl(this);
    }

    public ESRunnableContext getRunnableContext() {
        return this.runnableContext;
    }
}

