/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.editor.controls;

import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecp.edit.internal.swt.Activator;
import org.eclipse.emf.ecp.ide.view.internal.service.IDEViewModelRegistryImpl;
import org.eclipse.emf.ecp.ide.view.service.IDEViewModelRegistry;
import org.eclipse.emf.ecp.view.internal.editor.controls.ControlRootEClassControl2SWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.osgi.framework.ServiceReference;

public class ControlRootEClassControlChangeableSWTRenderer
extends ControlRootEClassControl2SWTRenderer {
    @Override
    protected Control createSWTControl(final Composite parent2, EStructuralFeature.Setting setting) {
        final Composite composite = (Composite)super.createSWTControl(parent2, setting);
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(0, 0).equalWidth(false).applyTo(composite);
        Button selectClass = new Button(composite, 8);
        selectClass.setText("Link Root EClass");
        selectClass.setToolTipText("Link Root EClass");
        selectClass.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ControlRootEClassControlChangeableSWTRenderer.this.selectAndSetEClass(parent2.getShell());
                composite.layout(true, true);
            }
        });
        return composite;
    }

    private void selectAndSetEClass(Shell shell) {
        Object selection;
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)labelProvider, this.getContentProvider());
        dialog.setAllowMultiple(false);
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length != 0 && EClass.class.isInstance(selection[0])) {
                    return Status.OK_STATUS;
                }
                return new Status(4, "org.eclipse.emf.ecp.view.editor.controls", "This is not an EClass.");
            }
        });
        dialog.setInput(this.getInput());
        dialog.setMessage("Select an EClass.");
        dialog.setTitle("Select an EClass.");
        dialog.setComparator(new ViewerComparator());
        int result = dialog.open();
        if (result == 0 && EClass.class.isInstance(selection = dialog.getFirstResult())) {
            EClass selectedFeature = (EClass)selection;
            VView view = (VView)((EStructuralFeature.Setting)((VControl)this.getVElement()).getDomainModelReference().getIterator().next()).getEObject();
            if (view.getRootEClass() != null) {
                this.getViewModelRegistry().unregister(view.getRootEClass().eResource().getURI().toString(), view);
            }
            view.setRootEClass(selectedFeature);
            this.getViewModelRegistry().register(view.getRootEClass().eResource().getURI().toString(), view);
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Map map = resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap();
            map.put("*", new XMIResourceFactoryImpl());
            ResourceSet rs = selectedFeature.eContainer().eResource().getResourceSet();
            URI uri = null;
            for (Resource r : rs.getResources()) {
                if (!r.getURI().isPlatform()) continue;
                uri = r.getURI();
            }
            Resource ecore = resourceSet.getResource(uri, true);
            if (ecore == null) {
                return;
            }
            EList contents = ecore.getContents();
            if (contents.size() != 1) {
                return;
            }
            EObject object = (EObject)contents.get(0);
            if (!(object instanceof EPackage)) {
                return;
            }
            IDEViewModelRegistryImpl registry = (IDEViewModelRegistryImpl)this.getViewModelRegistry();
            if (registry == null) {
                return;
            }
            view.setEcorePath(ecore.getURI().toPlatformString(true));
        }
        labelProvider.dispose();
    }

    private IDEViewModelRegistry getViewModelRegistry() {
        ServiceReference serviceReference = Activator.getDefault().getBundle().getBundleContext().getServiceReference(IDEViewModelRegistry.class);
        if (serviceReference == null) {
            return null;
        }
        return (IDEViewModelRegistry)Activator.getDefault().getBundle().getBundleContext().getService(serviceReference);
    }

    private ITreeContentProvider getContentProvider() {
        return new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                if (EPackage.class.isInstance(element)) {
                    return true;
                }
                if (EPackage.Descriptor.class.isInstance(element)) {
                    EPackage.Descriptor descriptor = (EPackage.Descriptor)element;
                    descriptor.getEPackage();
                    return true;
                }
                return false;
            }

            public Object getParent(Object element) {
                if (EClass.class.isInstance(element)) {
                    return ((EClass)element).eContainer();
                }
                return null;
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public Object[] getChildren(Object parentElement) {
                if (EPackage.class.isInstance(parentElement)) {
                    EPackage ePackage = (EPackage)parentElement;
                    LinkedHashSet<EClass> result = new LinkedHashSet<EClass>();
                    for (EClassifier classifier : ePackage.getEClassifiers()) {
                        if (!EClass.class.isInstance(classifier)) continue;
                        result.add((EClass)classifier);
                    }
                    return result.toArray();
                }
                if (EPackage.Descriptor.class.isInstance(parentElement)) {
                    return this.getChildren(((EPackage.Descriptor)parentElement).getEPackage());
                }
                if (EPackage.Registry.class.isInstance(parentElement)) {
                    return ((EPackage.Registry)parentElement).values().toArray();
                }
                return null;
            }
        };
    }

    private Object getInput() {
        return EPackage.Registry.INSTANCE;
    }
}

