/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.util;

import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.core.util.IndividualSpacings;
import org.eclipse.elk.core.util.adapters.GraphAdapters;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.IPropertyHolder;
import org.eclipse.elk.graph.properties.Property;

public final class PropertyConstantsDelegator {
    private Map<IProperty<?>, IProperty<?>> propertyDelegates = Maps.newHashMap();

    private PropertyConstantsDelegator() {
    }

    public static PropertyConstantsDelegator createEmpty() {
        return new PropertyConstantsDelegator();
    }

    public static PropertyConstantsDelegator createForLayoutAlgorithmData(LayoutAlgorithmData algorithmData) {
        PropertyConstantsDelegator delegator = new PropertyConstantsDelegator();
        for (String optionId : algorithmData.getKnownOptionIds()) {
            delegator.addDelegate((IProperty<?>)new Property(optionId, algorithmData.getDefaultValue(optionId)));
        }
        return delegator;
    }

    public static PropertyConstantsDelegator createForLayoutAlgorithmWithId(String algorithmId) {
        LayoutAlgorithmData algorithmData = LayoutMetaDataService.getInstance().getAlgorithmData(algorithmId);
        return algorithmData != null ? PropertyConstantsDelegator.createForLayoutAlgorithmData(algorithmData) : PropertyConstantsDelegator.createEmpty();
    }

    public PropertyConstantsDelegator addDelegate(IProperty<?> delegate) {
        this.propertyDelegates.put(delegate, delegate);
        return this;
    }

    public <T> IProperty<T> getPropertyOrDelegate(IProperty<T> property) {
        IProperty<T> actualProperty = this.propertyDelegates.containsKey(property) ? this.propertyDelegates.get(property) : property;
        return actualProperty;
    }

    public <T> T getProperty(IPropertyHolder propertyHolder, IProperty<T> property) {
        return (T)propertyHolder.getProperty(this.getPropertyOrDelegate(property));
    }

    public <T> T getProperty(GraphAdapters.GraphElementAdapter<?> adapter, IProperty<T> property) {
        return adapter.getProperty(this.getPropertyOrDelegate(property));
    }

    public <T> T getIndividualOrInheritedProperty(ElkNode node, IProperty<T> property) {
        return IndividualSpacings.getIndividualOrInherited(node, this.getPropertyOrDelegate(property));
    }

    public <T> T getIndividualOrInheritedProperty(GraphAdapters.NodeAdapter<?> nodeAdapter, IProperty<T> property) {
        return IndividualSpacings.getIndividualOrInherited(nodeAdapter, this.getPropertyOrDelegate(property));
    }
}

