/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.rectpacking.firstiteration;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.elk.alg.rectpacking.firstiteration.BestCandidateFilter;
import org.eclipse.elk.alg.rectpacking.util.DrawingData;
import org.eclipse.elk.core.math.ElkPadding;

public class AspectRatioFilter
implements BestCandidateFilter {
    @Override
    public List<DrawingData> filterList(List<DrawingData> candidates, double aspectRatio, ElkPadding padding) {
        ArrayList<DrawingData> remainingCandidates = new ArrayList<DrawingData>();
        double smallestDeviation = Double.POSITIVE_INFINITY;
        for (DrawingData opt : candidates) {
            smallestDeviation = Math.min(smallestDeviation, Math.abs((opt.getDrawingWidth() + padding.getHorizontal()) / (opt.getDrawingHeight() + padding.getVertical()) - aspectRatio));
        }
        for (DrawingData candidate : candidates) {
            if (Math.abs((candidate.getDrawingWidth() + padding.getHorizontal()) / (candidate.getDrawingHeight() + padding.getVertical()) - aspectRatio) != smallestDeviation) continue;
            remainingCandidates.add(candidate);
        }
        return remainingCandidates;
    }
}

