/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.debug.model;

import com.google.common.collect.Lists;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.core.util.LoggedGraph;

public final class ExecutionInfo {
    private String name;
    private ExecutionInfo parent;
    private List<ExecutionInfo> children;
    private String fileName;
    private boolean laidOutAfterLoad;
    private boolean executionTimeMeasured;
    private double executionTimeIncludingChildren;
    private double executionTimeLocal;
    private Path debugFolder;
    private List<String> logMessages;
    private boolean hasDescendantsWithLogMessages;
    private List<LoggedGraph> logGraphs;
    private boolean hasDescendantsWithLogGraphs;

    private ExecutionInfo() {
    }

    public static ExecutionInfo fromProgressMonitor(IElkProgressMonitor monitor) {
        return ExecutionInfo.fromProgressMonitor(monitor, null);
    }

    public static ExecutionInfo fromProgressMonitorAndFile(IElkProgressMonitor monitor, String fileName, boolean laidOutAfterLoad) {
        ExecutionInfo info = ExecutionInfo.fromProgressMonitor(monitor);
        info.fileName = fileName;
        info.laidOutAfterLoad = laidOutAfterLoad;
        return info;
    }

    private static ExecutionInfo fromProgressMonitor(IElkProgressMonitor monitor, ExecutionInfo parent) {
        ExecutionInfo execution = new ExecutionInfo();
        execution.name = monitor.getTaskName() != null ? monitor.getTaskName() : "Unnamed";
        execution.executionTimeMeasured = monitor.isExecutionTimeMeasured();
        execution.executionTimeIncludingChildren = monitor.getExecutionTime();
        execution.debugFolder = monitor.getDebugFolder();
        execution.parent = parent;
        List log = monitor.getLogs();
        if (log == null) {
            log = Collections.emptyList();
        }
        execution.logMessages = Collections.unmodifiableList(Lists.newArrayList(log));
        List graphs = monitor.getLoggedGraphs();
        if (graphs == null) {
            graphs = Collections.emptyList();
        }
        execution.logGraphs = Collections.unmodifiableList(Lists.newArrayList(graphs));
        execution.executionTimeLocal = execution.executionTimeIncludingChildren;
        ArrayList<ExecutionInfo> childExecutions = new ArrayList<ExecutionInfo>(monitor.getSubMonitors().size());
        for (IElkProgressMonitor child : monitor.getSubMonitors()) {
            ExecutionInfo childExecution = ExecutionInfo.fromProgressMonitor(child, execution);
            childExecutions.add(childExecution);
            execution.executionTimeLocal -= child.getExecutionTime();
            execution.hasDescendantsWithLogMessages = execution.hasDescendantsWithLogMessages | (childExecution.hasLogMessages() || childExecution.hasDescendantsWithLogMessages());
            execution.hasDescendantsWithLogGraphs = execution.hasDescendantsWithLogGraphs | (childExecution.hasLoggedGraphs() || childExecution.hasDescendantsWithLoggedGraphs());
        }
        execution.children = childExecutions;
        execution.executionTimeLocal = Math.max(execution.executionTimeLocal, 0.0);
        return execution;
    }

    public String getName() {
        return this.name;
    }

    public ExecutionInfo getParent() {
        return this.parent;
    }

    public List<ExecutionInfo> getChildren() {
        return this.children;
    }

    public boolean isLoadedFromFile() {
        return this.fileName != null;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isLaidOutAfterLoad() {
        return this.laidOutAfterLoad;
    }

    public boolean isExecutionTimeMeasured() {
        return this.executionTimeMeasured;
    }

    public double getExecutionTimeIncludingChildren() {
        return this.executionTimeIncludingChildren;
    }

    public double getExecutionTimeLocal() {
        return this.executionTimeLocal;
    }

    public Path getDebugFolder() {
        return this.debugFolder;
    }

    public List<String> getLogMessages() {
        return this.logMessages;
    }

    public boolean hasLogMessages() {
        return !this.logMessages.isEmpty();
    }

    public boolean hasDescendantsWithLogMessages() {
        return this.hasDescendantsWithLogMessages;
    }

    public List<LoggedGraph> getLoggedGraphs() {
        return this.logGraphs;
    }

    public boolean hasLoggedGraphs() {
        return !this.logGraphs.isEmpty();
    }

    public boolean hasDescendantsWithLoggedGraphs() {
        return this.hasDescendantsWithLogGraphs;
    }
}

