/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.loops.calculators;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopComponent;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopEdge;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNode;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNodeSide;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopPort;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopRoutingDirection;
import org.eclipse.elk.core.options.PortSide;

public final class SelfLoopComponentDependencyGraphCalculator {
    private static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$elk$alg$layered$p5edges$loops$SelfLoopRoutingDirection;

    private SelfLoopComponentDependencyGraphCalculator() {
    }

    public static void calculateComponentDependecies(SelfLoopNode nodeRep) {
        for (SelfLoopNodeSide nodeSide : nodeRep.getSides()) {
            List<SelfLoopPort> sidePorts = nodeSide.getPorts();
            sidePorts = sidePorts.stream().filter(port -> !port.getLPort().getOutgoingEdges().isEmpty() || !port.getLPort().getIncomingEdges().isEmpty() || port.getComponent().getPorts().size() != 1).collect(Collectors.toList());
            Set<SelfLoopComponent> dependencies = SelfLoopComponentDependencyGraphCalculator.getDependencyComponents(nodeSide, sidePorts, sidePorts, new HashSet<SelfLoopPort>());
            nodeSide.getComponentDependencies().clear();
            nodeSide.getComponentDependencies().addAll(dependencies);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static Set<SelfLoopComponent> getDependencyComponents(SelfLoopNodeSide side, List<SelfLoopPort> sidePorts, List<SelfLoopPort> relevantPorts, Set<SelfLoopPort> visitedPorts) {
        dependencyComponents = new HashSet<SelfLoopComponent>();
        i = 0;
        while (i < relevantPorts.size()) {
            block13: {
                port = relevantPorts.get(i);
                component = port.getComponent();
                dependenciesOfSide = component.getDependencyComponents();
                if (visitedPorts.contains(port)) break block13;
                direction = port.getDirection();
                lastPortOfComponent = SelfLoopComponentDependencyGraphCalculator.getLastPortOnSide(side, component);
                lastPortIndex = i;
                if (direction == null) break block13;
                switch (SelfLoopComponentDependencyGraphCalculator.$SWITCH_TABLE$org$eclipse$elk$alg$layered$p5edges$loops$SelfLoopRoutingDirection()[direction.ordinal()]) {
                    case 1: {
                        dependenciesOfSide.put(side, new ArrayList<SelfLoopComponent>(dependencyComponents));
                        dependencyComponents.removeAll(dependencyComponents);
                        dependencyComponents.add(component);
                        ** GOTO lbl57
                    }
                    case 2: {
                        portsOfSide = component.getPortsOfSide(side.getSide());
                        visitedPorts.addAll(portsOfSide);
                        dependencyComponents.add(component);
                        if (lastPortOfComponent != null && lastPortOfComponent != port) {
                            lastPortIndex = sidePorts.indexOf(lastPortOfComponent);
                        } else if (lastPortOfComponent == port) {
                            lastPortIndex = sidePorts.size();
                        }
                        wrappedPorts = sidePorts.subList(i + 1, lastPortIndex);
                        rightSideOpenDependencies = SelfLoopComponentDependencyGraphCalculator.getDependencyComponents(side, sidePorts, wrappedPorts, visitedPorts);
                        dependenciesOfSide.put(side, new ArrayList<SelfLoopComponent>(rightSideOpenDependencies));
                        ** GOTO lbl57
                    }
                    case 3: {
                        if (lastPortOfComponent != port) {
                            visitedPorts.add(port);
                            break;
                        }
                        dependencies = new ArrayList<SelfLoopComponent>(dependencyComponents);
                        dependencyComponents.removeAll(dependencyComponents);
                        dependencyComponents.add(component);
                        if (lastPortOfComponent != null && lastPortOfComponent != port) {
                            lastPortIndex = sidePorts.indexOf(lastPortOfComponent);
                        } else if (lastPortOfComponent == port) {
                            lastPortIndex = sidePorts.size();
                        }
                        rightSideOpenDependencies2 = SelfLoopComponentDependencyGraphCalculator.getDependencyComponents(side, sidePorts, sidePorts.subList(i + 1, lastPortIndex), visitedPorts);
                        dependencies.addAll(new ArrayList<SelfLoopComponent>(rightSideOpenDependencies2));
                        dependenciesOfSide.put(side, dependencies);
                    }
lbl57:
                    // 4 sources

                    default: {
                        portsOfSide = component.getPortsOfSide(side.getSide());
                        visitedPorts.addAll(portsOfSide);
                    }
                }
            }
            ++i;
        }
        return dependencyComponents;
    }

    private static SelfLoopPort getLastPortOnSide(SelfLoopNodeSide side, SelfLoopComponent component) {
        SelfLoopPort lastPort = null;
        List<SelfLoopPort> ports = side.getPorts();
        int i = ports.size() - 1;
        while (i >= 0) {
            SelfLoopPort currentPort = ports.get(i);
            if (currentPort.getComponent() == component) {
                lastPort = currentPort;
                break;
            }
            --i;
        }
        return lastPort;
    }

    public static void calculateEdgeDependecies(List<SelfLoopComponent> components) {
        for (SelfLoopComponent component : components) {
            int numberOfPortSides = PortSide.values().length - 1;
            List<SelfLoopPort> ports = component.getPorts();
            PortSide currentSide = ports.get(0).getPortSide();
            int i = 0;
            while (i < numberOfPortSides) {
                List<SelfLoopPort> sidePorts = component.getPortsOfSide(currentSide);
                if (component.getPorts().size() > 1) {
                    List<SelfLoopEdge> dependencies = SelfLoopComponentDependencyGraphCalculator.calculateEdgeOrder(ports, sidePorts, new HashSet<SelfLoopEdge>(), currentSide, false);
                    component.getEdgeDependencies().put(currentSide, dependencies);
                } else {
                    component.getEdgeDependencies().put(currentSide, new ArrayList());
                }
                currentSide = currentSide.right();
                ++i;
            }
        }
    }

    private static List<SelfLoopEdge> calculateEdgeOrder(List<SelfLoopPort> allPorts, List<SelfLoopPort> portsToVisit, Set<SelfLoopEdge> visitedEdges, PortSide side, boolean ignoreLeftPointing) {
        ArrayList<SelfLoopEdge> dependencyEdges = new ArrayList<SelfLoopEdge>();
        ArrayList<SelfLoopEdge> previousEdges = new ArrayList();
        int i = 0;
        while (i < portsToVisit.size()) {
            SelfLoopPort port = portsToVisit.get(i);
            ArrayList<SelfLoopEdge> portEdges = new ArrayList<SelfLoopEdge>(port.getConnectedEdges());
            portEdges.removeAll(visitedEdges);
            if (!portEdges.isEmpty()) {
                if (portEdges.size() == 1) {
                    SelfLoopEdge onlyPortEdge = (SelfLoopEdge)portEdges.get(0);
                    visitedEdges.add(onlyPortEdge);
                    SelfLoopPort targetPort = SelfLoopComponentDependencyGraphCalculator.oppositePort(port, onlyPortEdge);
                    int targetIndexAllPorts = allPorts.indexOf(targetPort);
                    int targetIndexSidePorts = portsToVisit.indexOf(targetPort);
                    int portIndex = allPorts.indexOf(port);
                    ArrayList<SelfLoopPort> nextPortsToVisit = new ArrayList();
                    if (targetPort.getPortSide() != side && targetIndexAllPorts < portIndex) {
                        if (!ignoreLeftPointing) {
                            SelfLoopComponentDependencyGraphCalculator.addEdgeDependencyToEdge(onlyPortEdge, new ArrayList<SelfLoopEdge>(dependencyEdges), side);
                            dependencyEdges.clear();
                            dependencyEdges.add(onlyPortEdge);
                            --i;
                        }
                    } else if (targetPort.getPortSide() != side) {
                        nextPortsToVisit = portsToVisit.subList(i, portsToVisit.size() - 1);
                        previousEdges = SelfLoopComponentDependencyGraphCalculator.calculateEdgeOrder(allPorts, nextPortsToVisit, visitedEdges, side, true);
                        SelfLoopComponentDependencyGraphCalculator.addEdgeDependencyToEdge(onlyPortEdge, previousEdges, side);
                        dependencyEdges.add(onlyPortEdge);
                    } else if (targetIndexAllPorts == portIndex + 1) {
                        dependencyEdges.add(onlyPortEdge);
                    } else {
                        nextPortsToVisit = portsToVisit.subList(i, targetIndexSidePorts);
                        previousEdges = SelfLoopComponentDependencyGraphCalculator.calculateEdgeOrder(allPorts, nextPortsToVisit, visitedEdges, side, true);
                        SelfLoopComponentDependencyGraphCalculator.addEdgeDependencyToEdge(onlyPortEdge, previousEdges, side);
                        dependencyEdges.add(onlyPortEdge);
                    }
                } else {
                    List<SelfLoopEdge> leftPointingEdges = SelfLoopComponentDependencyGraphCalculator.getLeftwardPointingEdges(port, visitedEdges, allPorts);
                    if (leftPointingEdges.isEmpty()) {
                        portEdges.sort((edge1, edge2) -> {
                            SelfLoopPort targetPort1 = SelfLoopComponentDependencyGraphCalculator.oppositePort(port, edge1);
                            SelfLoopPort targetPort2 = SelfLoopComponentDependencyGraphCalculator.oppositePort(port, edge2);
                            int index1 = allPorts.indexOf(targetPort1);
                            int index2 = allPorts.indexOf(targetPort2);
                            return -1 * Integer.compare(index1, index2);
                        });
                        SelfLoopEdge outermostEdge = (SelfLoopEdge)portEdges.get(0);
                        visitedEdges.add(outermostEdge);
                        dependencyEdges.add(outermostEdge);
                        SelfLoopPort otherPort = SelfLoopComponentDependencyGraphCalculator.oppositePort(port, outermostEdge);
                        List<Object> nextPortsToVisit = new ArrayList();
                        if (otherPort.getPortSide() == side) {
                            List<SelfLoopEdge> hasOtherPortsConnected = SelfLoopComponentDependencyGraphCalculator.getLeftwardPointingEdges(otherPort, visitedEdges, allPorts);
                            int otherEdgeIndex = portsToVisit.indexOf(otherPort);
                            nextPortsToVisit = hasOtherPortsConnected.isEmpty() ? portsToVisit.subList(0, otherEdgeIndex) : portsToVisit.subList(0, otherEdgeIndex + 1);
                        } else {
                            nextPortsToVisit = portsToVisit;
                        }
                        previousEdges = SelfLoopComponentDependencyGraphCalculator.calculateEdgeOrder(allPorts, nextPortsToVisit, visitedEdges, side, false);
                        SelfLoopComponentDependencyGraphCalculator.addEdgeDependencyToEdge(outermostEdge, previousEdges, side);
                    } else if (!ignoreLeftPointing) {
                        portEdges.sort((edge1, edge2) -> {
                            SelfLoopPort targetPort1 = SelfLoopComponentDependencyGraphCalculator.oppositePort(port, edge1);
                            SelfLoopPort targetPort2 = SelfLoopComponentDependencyGraphCalculator.oppositePort(port, edge2);
                            int index1 = allPorts.indexOf(targetPort1);
                            int index2 = allPorts.indexOf(targetPort2);
                            return Integer.compare(index1, index2);
                        });
                        SelfLoopEdge innermostLeftPointingEdge = (SelfLoopEdge)portEdges.get(0);
                        visitedEdges.add(innermostLeftPointingEdge);
                        SelfLoopComponentDependencyGraphCalculator.addEdgeDependencyToEdge(innermostLeftPointingEdge, new ArrayList<SelfLoopEdge>(dependencyEdges), side);
                        dependencyEdges.clear();
                        dependencyEdges.add(innermostLeftPointingEdge);
                        --i;
                    }
                }
            }
            ++i;
        }
        return dependencyEdges;
    }

    private static List<SelfLoopEdge> getLeftwardPointingEdges(SelfLoopPort port, Set<SelfLoopEdge> visitedEdges, List<SelfLoopPort> allPorts) {
        List<SelfLoopEdge> connectedEdges = port.getConnectedEdges();
        connectedEdges.removeAll(visitedEdges);
        int portIndex = allPorts.indexOf(port);
        HashSet<SelfLoopPort> perviousPorts = new HashSet<SelfLoopPort>(allPorts.subList(0, portIndex));
        ArrayList<SelfLoopEdge> leftwardEdges = new ArrayList<SelfLoopEdge>();
        for (SelfLoopEdge edge : connectedEdges) {
            SelfLoopPort otherEndPort = SelfLoopComponentDependencyGraphCalculator.oppositePort(port, edge);
            if (!perviousPorts.contains(otherEndPort)) continue;
            leftwardEdges.add(edge);
        }
        return leftwardEdges;
    }

    private static void addEdgeDependencyToEdge(SelfLoopEdge edge, List<SelfLoopEdge> newDependencies, PortSide side) {
        Map<PortSide, List<SelfLoopEdge>> dependencyMap = edge.getDependencyEdges();
        List<SelfLoopEdge> sideDependencies = dependencyMap.get(side);
        if (sideDependencies == null) {
            dependencyMap.put(side, newDependencies);
        } else {
            sideDependencies.addAll(newDependencies);
        }
    }

    private static SelfLoopPort oppositePort(SelfLoopPort port, SelfLoopEdge edge) {
        assert (edge.getSource() == port || edge.getTarget() == port);
        if (port == edge.getSource()) {
            return edge.getTarget();
        }
        return edge.getSource();
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$elk$alg$layered$p5edges$loops$SelfLoopRoutingDirection() {
        if ($SWITCH_TABLE$org$eclipse$elk$alg$layered$p5edges$loops$SelfLoopRoutingDirection != null) {
            return $SWITCH_TABLE$org$eclipse$elk$alg$layered$p5edges$loops$SelfLoopRoutingDirection;
        }
        int[] nArray = new int[SelfLoopRoutingDirection.values().length];
        try {
            nArray[SelfLoopRoutingDirection.BOTH.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SelfLoopRoutingDirection.LEFT.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SelfLoopRoutingDirection.RIGHT.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$eclipse$elk$alg$layered$p5edges$loops$SelfLoopRoutingDirection = nArray;
        return nArray;
    }
}

