/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.loops.labeling;

import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopComponent;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopEdge;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopLabel;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopLabelPosition;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNode;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopPort;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopRoutingDirection;
import org.eclipse.elk.alg.layered.p5edges.loops.labeling.AbstractSelfLoopLabelPositionGenerator;
import org.eclipse.elk.alg.layered.p5edges.loops.util.SelfLoopBendpointCalculationUtil;
import org.eclipse.elk.alg.layered.p5edges.splines.SplinesMath;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.PortSide;

public class ThreeCornerLoopLabelPositionGenerator
extends AbstractSelfLoopLabelPositionGenerator {
    public ThreeCornerLoopLabelPositionGenerator(SelfLoopNode slNode) {
        super(slNode);
    }

    @Override
    public void generatePositions(SelfLoopComponent component) {
        List<SelfLoopPort> ports = component.getPorts();
        SelfLoopPort startPort = ports.get(0);
        SelfLoopPort endPort = ports.get(ports.size() - 1);
        double edgeEdgeSpacing = this.getEdgeEdgeSpacing();
        double edgeLabelSpacing = this.getEdgeLabelSpacing();
        KVector startPosition = startPort.getLPort().getPosition().clone().add(startPort.getLPort().getAnchor());
        KVector endPosition = endPort.getLPort().getPosition().clone().add(endPort.getLPort().getAnchor());
        double directionStart = SplinesMath.portSideToDirection(startPort.getPortSide());
        KVector dirVectorStart = new KVector(directionStart);
        double directionEnd = SplinesMath.portSideToDirection(endPort.getPortSide());
        KVector dirVectorEnd = new KVector(directionEnd);
        KVector firstBend = startPosition.clone().add(dirVectorStart.clone().scale((double)startPort.getMaximumLevel() * edgeEdgeSpacing + edgeLabelSpacing));
        KVector secondBend = endPosition.clone().add(dirVectorEnd.clone().scale((double)endPort.getMaximumLevel() * edgeEdgeSpacing + edgeLabelSpacing));
        SelfLoopEdge edge = (SelfLoopEdge)Iterables.get(component.getConnectedEdges(), (int)0);
        List<KVector> cornerBends = SelfLoopBendpointCalculationUtil.generateCornerBendpoints(this.getSelfLoopNode(), startPort, endPort, firstBend, secondBend, edge);
        PortSide[] segmentSides = new PortSide[2];
        PortSide startSide = startPort.getPortSide();
        if (startPort.getDirection() == SelfLoopRoutingDirection.RIGHT) {
            segmentSides[0] = startSide.right();
            segmentSides[1] = segmentSides[0].right();
        } else {
            segmentSides[0] = startSide.left();
            segmentSides[1] = segmentSides[0].left();
        }
        this.addPositions(component, startPort, endPort, segmentSides, firstBend, cornerBends, secondBend);
    }

    private void addPositions(SelfLoopComponent component, SelfLoopPort startPort, SelfLoopPort endPort, PortSide[] segmentSides, KVector firstBend, List<KVector> cornerBends, KVector lastBend) {
        SelfLoopLabel label = component.getSelfLoopLabel();
        List<SelfLoopLabelPosition> positions = label.getCandidatePositions();
        positions.add(this.longSegmentPosition(label, segmentSides[0], cornerBends.get(0), cornerBends.get(1), AbstractSelfLoopLabelPositionGenerator.Alignment.CENTERED));
        positions.add(this.longSegmentPosition(label, segmentSides[0], cornerBends.get(0), cornerBends.get(1), AbstractSelfLoopLabelPositionGenerator.Alignment.LEFT_OR_TOP));
        positions.add(this.longSegmentPosition(label, segmentSides[0], cornerBends.get(0), cornerBends.get(1), AbstractSelfLoopLabelPositionGenerator.Alignment.RIGHT_OR_BOTTOM));
        positions.add(this.longSegmentPosition(label, segmentSides[0], cornerBends.get(1), cornerBends.get(2), AbstractSelfLoopLabelPositionGenerator.Alignment.CENTERED));
        positions.add(this.longSegmentPosition(label, segmentSides[0], cornerBends.get(1), cornerBends.get(2), AbstractSelfLoopLabelPositionGenerator.Alignment.LEFT_OR_TOP));
        positions.add(this.longSegmentPosition(label, segmentSides[0], cornerBends.get(1), cornerBends.get(2), AbstractSelfLoopLabelPositionGenerator.Alignment.RIGHT_OR_BOTTOM));
        positions.add(this.shortSegmentPosition(label, startPort, firstBend, cornerBends.get(0), AbstractSelfLoopLabelPositionGenerator.Alignment.CENTERED, true));
        positions.add(this.shortSegmentPosition(label, startPort, firstBend, cornerBends.get(0), AbstractSelfLoopLabelPositionGenerator.Alignment.LEFT_OR_TOP, true));
        positions.add(this.shortSegmentPosition(label, startPort, firstBend, cornerBends.get(0), AbstractSelfLoopLabelPositionGenerator.Alignment.RIGHT_OR_BOTTOM, true));
        positions.add(this.shortSegmentPosition(label, endPort, lastBend, cornerBends.get(2), AbstractSelfLoopLabelPositionGenerator.Alignment.CENTERED, true));
        positions.add(this.shortSegmentPosition(label, endPort, lastBend, cornerBends.get(2), AbstractSelfLoopLabelPositionGenerator.Alignment.LEFT_OR_TOP, true));
        positions.add(this.shortSegmentPosition(label, endPort, lastBend, cornerBends.get(2), AbstractSelfLoopLabelPositionGenerator.Alignment.RIGHT_OR_BOTTOM, true));
    }
}

