/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.loops.labeling;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopComponent;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopEdge;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopLabel;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopLabelPosition;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNode;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNodeSide;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopOpposingSegment;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopPort;
import org.eclipse.elk.alg.layered.p5edges.loops.calculators.SelfLoopOffsetCalculator;
import org.eclipse.elk.core.math.ElkRectangle;
import org.eclipse.elk.core.math.KVector;

public final class SelfLoopLabelPositionEvaluator {
    private static final double LABEL_NODE_CROSSING_PENALTY = 100.0;
    private static final double LABEL_EDGE_CROSSING_PENALTY = 10.0;
    private static final double LABEL_LABEL_CROSSING_PENALTY = 40.0;
    private final SelfLoopNode slNode;
    private final List<SelfLoopComponent> components;
    private final boolean debugMode;
    private double assignmentPenalty;

    public SelfLoopLabelPositionEvaluator(SelfLoopNode slNode) {
        this.slNode = slNode;
        this.debugMode = (Boolean)slNode.getNode().getGraph().getProperty(LayeredOptions.DEBUG_MODE);
        this.components = slNode.getSelfLoopComponents().stream().filter(c -> c.getSelfLoopLabel() != null).collect(Collectors.toList());
        this.assignDefaultPositions();
        this.assignmentPenalty = this.calculatePenalty();
    }

    private void assignDefaultPositions() {
        for (SelfLoopComponent component : this.components) {
            SelfLoopLabel slLabel = component.getSelfLoopLabel();
            assert (slLabel != null);
            assert (!slLabel.getCandidatePositions().isEmpty());
            slLabel.setLabelPosition(slLabel.getCandidatePositions().get(0));
        }
    }

    public void evaluatePositions() {
        if (this.debugMode) {
            KVector nodeSize = this.slNode.getNode().getSize();
            System.out.println("----------------------------------------");
            System.out.println("SETUP");
            System.out.println();
            System.out.println("Node (" + nodeSize.x + ", " + nodeSize.y + ")");
            for (SelfLoopComponent component : this.components) {
                SelfLoopLabel slLabel = component.getSelfLoopLabel();
                StringJoiner joiner = new StringJoiner(", ");
                for (LLabel llabel : slLabel.getLabels()) {
                    joiner.add(llabel.getText());
                }
                System.out.println(String.valueOf(joiner.toString()) + " (" + slLabel.getWidth() + ", " + slLabel.getHeight() + ")");
                for (SelfLoopLabelPosition position : slLabel.getCandidatePositions()) {
                    System.out.println("    " + position.getPosition().toString());
                    System.out.println("        Base penalty: " + position.getBasePenalty());
                    System.out.println("        Side: " + position.getSide());
                    System.out.println("        Label alignment: " + (Object)((Object)position.getLabelAlignment()));
                }
            }
        }
        double previousPenalty = Double.MAX_VALUE;
        int run = 1;
        while (this.assignmentPenalty < previousPenalty) {
            if (this.debugMode) {
                System.out.println();
                System.out.println();
                System.out.println("RUN " + run++);
                System.out.println();
                System.out.println("Previous Penalty: " + this.assignmentPenalty);
                System.out.println();
            }
            previousPenalty = this.assignmentPenalty;
            double currMinimum = Double.MAX_VALUE;
            for (SelfLoopComponent component : this.components) {
                if (this.debugMode) {
                    StringJoiner joiner = new StringJoiner(", ");
                    for (LLabel llabel : component.getSelfLoopLabel().getLabels()) {
                        joiner.add(llabel.getText());
                    }
                    System.out.println(joiner.toString());
                }
                SelfLoopLabel slLabel = component.getSelfLoopLabel();
                List<SelfLoopLabelPosition> positions = slLabel.getCandidatePositions();
                SelfLoopLabelPosition currMinPosition = slLabel.getLabelPosition();
                for (SelfLoopLabelPosition currPosition : positions) {
                    slLabel.setLabelPosition(currPosition);
                    if (this.debugMode) {
                        System.out.println("    " + currPosition.getPosition().toString());
                    }
                    currMinimum = this.calculatePenalty();
                    if (this.debugMode) {
                        System.out.println("        Penalty: " + currMinimum);
                    }
                    if (!(currMinimum < this.assignmentPenalty)) continue;
                    if (this.debugMode) {
                        System.out.println("    -> chosen");
                    }
                    this.assignmentPenalty = currMinimum;
                    currMinPosition = currPosition;
                }
                component.getSelfLoopLabel().setLabelPosition(currMinPosition);
            }
            if (!this.debugMode) continue;
            System.out.println();
            System.out.println("New Penalty: " + this.assignmentPenalty);
            System.out.println();
        }
        if (this.debugMode) {
            System.out.println();
            System.out.println();
            System.out.println("RESULT");
            System.out.println();
            for (SelfLoopComponent component : this.components) {
                StringJoiner joiner = new StringJoiner(", ");
                for (LLabel llabel : component.getSelfLoopLabel().getLabels()) {
                    joiner.add(llabel.getText());
                }
                System.out.println(joiner.toString());
                System.out.println("    -> " + component.getSelfLoopLabel().getLabelPosition().getPosition().toString());
            }
        }
    }

    private double calculatePenalty() {
        double totalBasePenalty = 0.0;
        for (SelfLoopComponent component : this.components) {
            SelfLoopLabelPosition position = component.getSelfLoopLabel().getLabelPosition();
            position.resetPosition();
            totalBasePenalty += position.getBasePenalty();
        }
        SelfLoopOffsetCalculator.calculatePortLabelOffsets(this.slNode);
        SelfLoopOffsetCalculator.calculateOpposingSegmentLabelOffsets(this.slNode);
        List<ElkRectangle> labelRects = this.createLabelPositionRects();
        int labelNodeCrossings = this.calculateLabelNodeCrossings(labelRects);
        int labelLabelCrossings = this.calculateLabelLabelCrossings(labelRects);
        int labelEdgeCrossings = this.calculateLabelEdgeCrossings();
        if (this.debugMode) {
            System.out.println("        Label-Node: " + labelNodeCrossings);
            System.out.println("        Label-Label: " + labelLabelCrossings);
            System.out.println("        Label-Edge: " + labelEdgeCrossings);
        }
        return 100.0 * (double)labelNodeCrossings + 10.0 * (double)labelEdgeCrossings + 40.0 * (double)labelLabelCrossings + totalBasePenalty;
    }

    private List<ElkRectangle> createLabelPositionRects() {
        ArrayList<ElkRectangle> labelRects = new ArrayList<ElkRectangle>(this.components.size());
        for (SelfLoopComponent comp : this.components) {
            SelfLoopLabel slLabel = comp.getSelfLoopLabel();
            SelfLoopLabelPosition slPos = slLabel.getLabelPosition();
            ElkRectangle labelRect = new ElkRectangle(slPos.getPosition().x, slPos.getPosition().y, slLabel.getWidth(), slLabel.getHeight());
            labelRects.add(labelRect);
        }
        return labelRects;
    }

    private int calculateLabelNodeCrossings(List<ElkRectangle> labelRects) {
        KVector nodeSize = this.slNode.getNode().getSize();
        ElkRectangle nodeRect = new ElkRectangle(0.0, 0.0, nodeSize.x, nodeSize.y);
        int labelNodeCrossings = 0;
        for (ElkRectangle labelRect : labelRects) {
            if (!nodeRect.intersects(labelRect)) continue;
            ++labelNodeCrossings;
        }
        return labelNodeCrossings;
    }

    private int calculateLabelLabelCrossings(List<ElkRectangle> labelRects) {
        int labelLabelCrossings = 0;
        int currIdx = 0;
        while (currIdx < labelRects.size()) {
            ElkRectangle currRect = labelRects.get(currIdx);
            int otherIdx = currIdx + 1;
            while (otherIdx < labelRects.size()) {
                if (currRect.intersects(labelRects.get(otherIdx))) {
                    ++labelLabelCrossings;
                }
                ++otherIdx;
            }
            ++currIdx;
        }
        return labelLabelCrossings;
    }

    private int calculateLabelEdgeCrossings() {
        int labelEdgeCrossings = 0;
        for (SelfLoopComponent component : this.components) {
            SelfLoopLabel slLabel = component.getSelfLoopLabel();
            SelfLoopLabelPosition slLabelPos = slLabel.getLabelPosition();
            for (SelfLoopPort slPort : this.slNode.getNodeSide(slLabelPos.getSide()).getPorts()) {
                if (slPort.getComponent() == component || !this.isCrossing(slLabel, component, slPort)) continue;
                ++labelEdgeCrossings;
            }
        }
        return labelEdgeCrossings;
    }

    private boolean isCrossing(SelfLoopLabel slLabel, SelfLoopComponent slLabelComponent, SelfLoopPort slPort) {
        int labelEdgeLevel = this.computeEdgeLevel(slLabel, slLabelComponent);
        if (labelEdgeLevel < 0) {
            return false;
        }
        int otherEdgeLevel = slPort.getMaximumLevel();
        if (otherEdgeLevel <= labelEdgeLevel) {
            return false;
        }
        SelfLoopLabelPosition slLabelPos = slLabel.getLabelPosition();
        ElkRectangle labelRect = new ElkRectangle(slLabelPos.getPosition().x, slLabelPos.getPosition().y, slLabel.getWidth(), slLabel.getHeight());
        LPort lPort = slPort.getLPort();
        KVector portPos = lPort.getPosition().clone().add(lPort.getAnchor());
        switch (slPort.getPortSide()) {
            case NORTH: 
            case SOUTH: {
                return labelRect.x < portPos.x && portPos.x < labelRect.getMaxX();
            }
            case EAST: 
            case WEST: {
                return labelRect.y < portPos.y && portPos.y < labelRect.getMaxY();
            }
        }
        assert (false);
        return false;
    }

    private int computeEdgeLevel(SelfLoopLabel slLabel, SelfLoopComponent slComponent) {
        for (SelfLoopPort slPort : slComponent.getPortsOfSide(slLabel.getLabelPosition().getSide())) {
            int maxLevel = slPort.getMaximumLevel();
            if (maxLevel < 0) continue;
            return maxLevel;
        }
        SelfLoopNodeSide slSide = this.slNode.getNodeSide(slLabel.getLabelPosition().getSide());
        int maxSegmentLevel = -1;
        for (SelfLoopEdge slEdge : slComponent.getConnectedEdges()) {
            SelfLoopOpposingSegment slSegment = slSide.getOpposingSegments().get(slEdge);
            if (slSegment == null) continue;
            maxSegmentLevel = Math.max(maxSegmentLevel, slSegment.getLevel());
        }
        return maxSegmentLevel;
    }
}

