/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.loops;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopEdge;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopLabel;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNode;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNodeSide;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopPort;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopRoutingDirection;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopType;
import org.eclipse.elk.core.options.PortSide;

public class SelfLoopComponent {
    private List<SelfLoopPort> ports = new ArrayList<SelfLoopPort>();
    private SelfLoopLabel selfLoopLabel;
    private Map<SelfLoopNodeSide, List<SelfLoopComponent>> dependencyComponents = new HashMap<SelfLoopNodeSide, List<SelfLoopComponent>>();
    private Map<PortSide, List<SelfLoopEdge>> edgeDependencies = new HashMap<PortSide, List<SelfLoopEdge>>();

    public SelfLoopComponent(List<LPort> ports) {
        this.addAllPorts(ports);
        this.calculateConnectedEdges();
    }

    public static void createSelfLoopComponents(SelfLoopNode slNode) {
        LNode lNode = slNode.getNode();
        ArrayList<LPort> nodePorts = new ArrayList<LPort>(lNode.getPorts());
        while (!nodePorts.isEmpty()) {
            List<LPort> ports = SelfLoopComponent.findAllConnectedPorts(lNode, (LPort)((Object)nodePorts.get(0)), new HashSet<LPort>());
            ports.sort(Comparator.comparing(lNode.getPorts()::indexOf));
            SelfLoopComponent component = new SelfLoopComponent(ports);
            slNode.getSelfLoopComponents().add(component);
            nodePorts.removeAll(ports);
        }
    }

    private static List<LPort> findAllConnectedPorts(LNode node, LPort lPort, Set<LPort> visitedPorts) {
        if (!visitedPorts.contains((Object)lPort)) {
            visitedPorts.add(lPort);
            for (LEdge edge : lPort.getIncomingEdges()) {
                LPort source = edge.getSource();
                if (!((Object)((Object)source.getNode())).equals((Object)node) || visitedPorts.contains((Object)source)) continue;
                visitedPorts.addAll(SelfLoopComponent.findAllConnectedPorts(node, source, visitedPorts));
            }
            for (LEdge edge : lPort.getOutgoingEdges()) {
                LPort target = edge.getTarget();
                if (!((Object)((Object)target.getNode())).equals((Object)node) || visitedPorts.contains((Object)target)) continue;
                visitedPorts.addAll(SelfLoopComponent.findAllConnectedPorts(node, target, visitedPorts));
            }
        }
        return new ArrayList<LPort>(visitedPorts);
    }

    public void addPort(LPort port) {
        this.ports.add(new SelfLoopPort(port, this));
    }

    private void addAllPorts(List<LPort> newPorts) {
        for (LPort port : newPorts) {
            this.addPort(port);
        }
    }

    public List<SelfLoopPort> getPorts() {
        return this.ports;
    }

    public SelfLoopPort findPort(LPort port) {
        for (SelfLoopPort selfLoopPort : this.ports) {
            if (selfLoopPort.getLPort() != port) continue;
            return selfLoopPort;
        }
        return null;
    }

    public SelfLoopPort getNextPort(SelfLoopPort port) {
        int index = this.ports.indexOf(port);
        if (index != this.ports.size() - 1) {
            return this.ports.get(index + 1);
        }
        return null;
    }

    public SelfLoopPort getLastPort() {
        if (this.ports.isEmpty()) {
            return null;
        }
        return this.ports.get(this.ports.size() - 1);
    }

    public Set<PortSide> getPortSides() {
        return this.ports.stream().map(port -> port.getPortSide()).collect(Collectors.toSet());
    }

    public List<SelfLoopPort> getPortsOfSide(PortSide side) {
        return this.ports.stream().filter(port -> port.getPortSide() == side).collect(Collectors.toList());
    }

    public SelfLoopLabel getSelfLoopLabel() {
        return this.selfLoopLabel;
    }

    public void setSelfLoopLabel(SelfLoopLabel selfLoopLabel) {
        this.selfLoopLabel = selfLoopLabel;
    }

    public Set<SelfLoopEdge> getConnectedEdges() {
        return this.ports.stream().flatMap(port -> port.getConnectedEdges().stream()).collect(Collectors.toSet());
    }

    private void calculateConnectedEdges() {
        for (SelfLoopPort port : this.ports) {
            for (LEdge edge : port.getLPort().getOutgoingEdges()) {
                SelfLoopPort targetPort = this.findPort(edge.getTarget());
                SelfLoopEdge selfLoopEdge = new SelfLoopEdge(this, port, targetPort, edge);
                port.getConnectedEdges().add(selfLoopEdge);
                if (targetPort == null) continue;
                targetPort.getConnectedEdges().add(selfLoopEdge);
            }
        }
    }

    public Map<SelfLoopNodeSide, List<SelfLoopComponent>> getDependencyComponents() {
        return this.dependencyComponents;
    }

    public Map<PortSide, List<SelfLoopEdge>> getEdgeDependencies() {
        return this.edgeDependencies;
    }

    /*
     * Unable to fully structure code
     */
    public List<PortSide> getComponentSpanningSides() {
        block2: {
            sides = new LinkedHashSet<PortSide>();
            currentPortSide = this.ports.get(0).getPortSide();
            lastPortSide = this.ports.get(this.ports.size() - 1).getPortSide();
            sides.add(lastPortSide);
            if (currentPortSide != lastPortSide || this.ports.get(0).getOriginalIndex() <= this.ports.get(this.ports.size() - 1).getOriginalIndex()) ** GOTO lbl15
            do {
                sides.add(currentPortSide);
            } while ((currentPortSide = currentPortSide.right()) != lastPortSide);
            break block2;
lbl-1000:
            // 1 sources

            {
                sides.add(currentPortSide);
                currentPortSide = currentPortSide.right();
lbl15:
                // 2 sources

                ** while (currentPortSide != lastPortSide)
            }
        }
        return new ArrayList<PortSide>(sides);
    }

    public boolean isCornerComponent() {
        Set<PortSide> portSide = this.getPortSides();
        if (portSide.size() == 2) {
            Iterator<PortSide> portSideIterator = portSide.iterator();
            PortSide side1 = portSideIterator.next();
            PortSide side2 = portSideIterator.next();
            return side1.areAdjacent(side2);
        }
        return false;
    }

    public boolean isOpposingComponent() {
        return this.getPortSides().size() == 2 && !this.isCornerComponent();
    }

    public SelfLoopType getType(SelfLoopNode nodeRep) {
        boolean leftDir;
        if (this.ports.size() == 1) {
            return SelfLoopType.NON_LOOP;
        }
        SelfLoopPort source = this.ports.get(0);
        PortSide sourceSide = source.getPortSide();
        SelfLoopPort target = this.ports.get(this.ports.size() - 1);
        PortSide targetSide = target.getPortSide();
        boolean rightDir = source.getDirection() == SelfLoopRoutingDirection.RIGHT;
        boolean bl = leftDir = source.getDirection() == SelfLoopRoutingDirection.LEFT;
        if (source.getLPort().getNode() != target.getLPort().getNode()) {
            return SelfLoopType.NON_LOOP;
        }
        if (sourceSide == targetSide) {
            SelfLoopNodeSide nodeRepside = nodeRep.getNodeSide(sourceSide);
            int sourceIndex = nodeRepside.getPorts().indexOf(source);
            int targetIndex = nodeRepside.getPorts().indexOf(target);
            if (leftDir && sourceIndex < targetIndex || rightDir && targetIndex < sourceIndex) {
                return SelfLoopType.FOUR_CORNER;
            }
            return SelfLoopType.SIDE;
        }
        if (sourceSide.left() == targetSide || sourceSide.right() == targetSide) {
            if (leftDir && source.getPortSide().right() == target.getPortSide() || rightDir && source.getPortSide().left() == target.getPortSide()) {
                return SelfLoopType.THREE_CORNER;
            }
            return SelfLoopType.CORNER;
        }
        return SelfLoopType.OPPOSING;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        for (SelfLoopPort port : this.ports) {
            builder.append(port);
            if (this.ports.indexOf(port) == this.ports.size() - 1) continue;
            builder.append(", ");
        }
        builder.append(")");
        return builder.toString();
    }
}

