/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.graph.json;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.EdgeCoords;
import org.eclipse.elk.core.options.ShapeCoords;
import org.eclipse.elk.core.util.IndividualSpacings;
import org.eclipse.elk.graph.EMapPropertyHolder;
import org.eclipse.elk.graph.ElkBendPoint;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.ElkShape;
import org.eclipse.elk.graph.json.JsonAdapter;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.IPropertyHolder;
import org.eclipse.elk.graph.util.ElkGraphUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.DoubleExtensions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public final class JsonImporter {
    @Extension
    private JsonAdapter _jsonAdapter = new JsonAdapter();
    private final BiMap<Object, ElkNode> nodeIdMap = HashBiMap.create();
    private final BiMap<Object, ElkPort> portIdMap = HashBiMap.create();
    private final Map<Object, ElkEdge> edgeIdMap = Maps.newHashMap();
    private final BiMap<Object, ElkEdgeSection> edgeSectionIdMap = HashBiMap.create();
    private final BiMap<ElkNode, Object> nodeJsonMap = HashBiMap.create();
    private final Map<ElkPort, Object> portJsonMap = Maps.newHashMap();
    private final Map<ElkEdge, Object> edgeJsonMap = Maps.newHashMap();
    private final Map<ElkEdgeSection, Object> edgeSectionJsonMap = Maps.newHashMap();
    private final Map<ElkLabel, Object> labelJsonMap = Maps.newHashMap();
    private final Map<ElkEdge, ElkNode> edgeOriginalParentMap = Maps.newHashMap();
    private final Map<ElkShape, Double> globalXMap = Maps.newHashMap();
    private final Map<ElkShape, Double> globalYMap = Maps.newHashMap();
    private final Map<ElkGraphElement, ShapeCoords> shapeCoordsMap = Maps.newHashMap();
    private final Map<ElkGraphElement, EdgeCoords> edgeCoordsMap = Maps.newHashMap();
    private Object inputModel;

    public ElkNode transform(Object graph) {
        this.inputModel = graph;
        this.clearMaps();
        ElkNode root = this.transformNode(graph, null);
        this.transformEdges(graph);
        return root;
    }

    public Object getInputModel() {
        return this.inputModel;
    }

    private void clearMaps() {
        this.nodeIdMap.clear();
        this.portIdMap.clear();
        this.edgeIdMap.clear();
        this.edgeSectionIdMap.clear();
        this.nodeJsonMap.clear();
        this.portJsonMap.clear();
        this.edgeJsonMap.clear();
        this.edgeSectionJsonMap.clear();
        this.labelJsonMap.clear();
        this.edgeOriginalParentMap.clear();
        this.globalXMap.clear();
        this.globalYMap.clear();
        this.shapeCoordsMap.clear();
        this.edgeCoordsMap.clear();
    }

    private JsonArray transformChildNodes(Object jsonNodeA, ElkNode parent) {
        JsonArray _xblockexpression = null;
        JsonObject jsonNode = this._jsonAdapter.toJsonObject(jsonNodeA);
        JsonArray _optJSONArray = this._jsonAdapter.optJSONArray(jsonNode, "children");
        Procedures.Procedure1 _function = children -> {
            if (children != null) {
                int _sizeJsonArr = this._jsonAdapter.sizeJsonArr((JsonArray)children);
                ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _sizeJsonArr, true);
                for (Integer i : _doubleDotLessThan) {
                    JsonObject _optJSONObject = this._jsonAdapter.optJSONObject((JsonArray)children, i);
                    if (_optJSONObject == null) continue;
                    this.transformNode(_optJSONObject, parent);
                }
            }
        };
        _xblockexpression = (JsonArray)ObjectExtensions.operator_doubleArrow((Object)_optJSONArray, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    private ElkNode transformNode(Object jsonNode, ElkNode parent) {
        ElkNode node = this.register(ElkGraphUtil.createNode((ElkNode)parent), jsonNode);
        node.setIdentifier(this._jsonAdapter.getIdSave(this._jsonAdapter.toJsonObject(jsonNode)));
        this.transformProperties(jsonNode, (IPropertyHolder)node);
        this.transformIndividualSpacings(jsonNode, (IPropertyHolder)node);
        this.transformShapeLayout(jsonNode, (ElkShape)node);
        this.transformPorts(jsonNode, node);
        this.transformLabels(jsonNode, (ElkGraphElement)node);
        this.transformChildNodes(jsonNode, node);
        return node;
    }

    private void transformEdges(Object jsonObjA) {
        JsonObject jsonObj = this._jsonAdapter.toJsonObject(jsonObjA);
        ElkNode node = (ElkNode)this.nodeJsonMap.inverse().get((Object)jsonObj);
        if (node == null) {
            String _idSave = this._jsonAdapter.getIdSave(jsonObj);
            String _plus = "Unable to find elk node for json object '" + _idSave;
            String _plus_1 = _plus + "' Panic!";
            throw this._jsonAdapter.formatError(_plus_1);
        }
        JsonArray _optJSONArray = this._jsonAdapter.optJSONArray(jsonObj, "edges");
        Procedures.Procedure1 _function = edges -> {
            if (edges != null) {
                int _sizeJsonArr = this._jsonAdapter.sizeJsonArr((JsonArray)edges);
                ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _sizeJsonArr, true);
                for (Integer i : _doubleDotLessThan) {
                    JsonObject edge = this._jsonAdapter.optJSONObject((JsonArray)edges, i);
                    if (this._jsonAdapter.hasJsonObj(edge, "sources") || this._jsonAdapter.hasJsonObj(edge, "targets")) {
                        this.transformEdge(edge, node);
                    } else {
                        this.transformPrimitiveEdge(edge, node);
                    }
                    ElkGraphUtil.updateContainment((ElkEdge)this.edgeIdMap.get(this._jsonAdapter.getId(edge)));
                }
            }
        };
        ObjectExtensions.operator_doubleArrow((Object)_optJSONArray, (Procedures.Procedure1)_function);
        JsonArray _optJSONArray_1 = this._jsonAdapter.optJSONArray(jsonObj, "children");
        Procedures.Procedure1 _function_1 = children -> {
            if (children != null) {
                int _sizeJsonArr = this._jsonAdapter.sizeJsonArr((JsonArray)children);
                ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _sizeJsonArr, true);
                for (Integer i : _doubleDotLessThan) {
                    JsonObject _optJSONObject = this._jsonAdapter.optJSONObject((JsonArray)children, i);
                    if (_optJSONObject == null) continue;
                    this.transformEdges(_optJSONObject);
                }
            }
        };
        ObjectExtensions.operator_doubleArrow((Object)_optJSONArray_1, (Procedures.Procedure1)_function_1);
    }

    private JsonArray transformPrimitiveEdge(Object jsonObjA, ElkNode parent) {
        JsonArray _xblockexpression = null;
        JsonObject jsonObj = this._jsonAdapter.toJsonObject(jsonObjA);
        ElkEdge edge = this.register(ElkGraphUtil.createEdge((ElkNode)parent), (Object)jsonObj);
        edge.setIdentifier(this._jsonAdapter.getIdSave(jsonObj));
        ElkNode srcNode = (ElkNode)this.nodeIdMap.get(this._jsonAdapter.asId(this._jsonAdapter.getJsonObj(jsonObj, "source")));
        JsonElement _jsonObj = this._jsonAdapter.getJsonObj(jsonObj, "sourcePort");
        Object _asId = null;
        if (_jsonObj != null) {
            _asId = this._jsonAdapter.asId(_jsonObj);
        }
        ElkPort srcPort = (ElkPort)this.portIdMap.get(_asId);
        if (srcNode == null) {
            Object _id = this._jsonAdapter.getId(jsonObj);
            String _plus = "An edge must have a source node (edge id: '" + String.valueOf(_id);
            String _plus_1 = _plus + "').";
            throw this._jsonAdapter.formatError(_plus_1);
        }
        if (srcPort != null && !Objects.equals(srcPort.getParent(), srcNode)) {
            String _idSave = this._jsonAdapter.getIdSave(jsonObj);
            String _plus_2 = "The source port of an edge must be a port of the edge's source node (edge id: '" + _idSave;
            String _plus_3 = _plus_2 + "').";
            throw this._jsonAdapter.formatError(_plus_3);
        }
        EList _sources = edge.getSources();
        Object _elvis = null;
        _elvis = srcPort != null ? srcPort : srcNode;
        _sources.add(_elvis);
        ElkNode tgtNode = (ElkNode)this.nodeIdMap.get(this._jsonAdapter.asId(this._jsonAdapter.getJsonObj(jsonObj, "target")));
        JsonElement _jsonObj_1 = this._jsonAdapter.getJsonObj(jsonObj, "targetPort");
        Object _asId_1 = null;
        if (_jsonObj_1 != null) {
            _asId_1 = this._jsonAdapter.asId(_jsonObj_1);
        }
        ElkPort tgtPort = (ElkPort)this.portIdMap.get(_asId_1);
        if (tgtNode == null) {
            Object _id_1 = this._jsonAdapter.getId(jsonObj);
            String _plus_4 = "An edge must have a target node (edge id: '" + String.valueOf(_id_1);
            String _plus_5 = _plus_4 + "').";
            throw this._jsonAdapter.formatError(_plus_5);
        }
        if (tgtPort != null && !Objects.equals(tgtPort.getParent(), tgtNode)) {
            String _idSave_1 = this._jsonAdapter.getIdSave(jsonObj);
            String _plus_6 = "The target port of an edge must be a port of the edge's target node (edge id: '" + _idSave_1;
            String _plus_7 = _plus_6 + "').";
            throw this._jsonAdapter.formatError(_plus_7);
        }
        EList _targets = edge.getTargets();
        Object _elvis_1 = null;
        _elvis_1 = tgtPort != null ? tgtPort : tgtNode;
        _targets.add(_elvis_1);
        if (edge.getSources().isEmpty() || edge.getTargets().isEmpty()) {
            String _idSave_2 = this._jsonAdapter.getIdSave(jsonObj);
            String _plus_8 = "An edge must have at least one source and one target (edge id: '" + _idSave_2;
            String _plus_9 = _plus_8 + "').";
            throw this._jsonAdapter.formatError(_plus_9);
        }
        this.transformProperties(jsonObj, (IPropertyHolder)edge);
        this.transformPrimitiveEdgeLayout(jsonObj, edge);
        _xblockexpression = this.transformLabels(jsonObj, (ElkGraphElement)edge);
        return _xblockexpression;
    }

    private JsonArray transformPrimitiveEdgeLayout(Object jsonObjA, ElkEdge edge) {
        JsonArray _xblockexpression = null;
        JsonObject jsonObj = this._jsonAdapter.toJsonObject(jsonObjA);
        JsonArray _xifexpression = null;
        if (this._jsonAdapter.hasJsonObj(jsonObj, "sourcePoint") || this._jsonAdapter.hasJsonObj(jsonObj, "targetPoint") || this._jsonAdapter.hasJsonObj(jsonObj, "bendPoints")) {
            JsonArray _xblockexpression_1 = null;
            ElkEdgeSection section = ElkGraphUtil.createEdgeSection((ElkEdge)edge);
            JsonObject _optJSONObject = this._jsonAdapter.optJSONObject(jsonObj, "sourcePoint");
            Procedures.Procedure1 _function = srcPnt -> {
                if (srcPnt != null) {
                    Double _optDouble = this._jsonAdapter.optDouble((JsonObject)srcPnt, "x");
                    Procedures.Procedure1 _function_1 = it -> section.setStartX(it.doubleValue());
                    ObjectExtensions.operator_doubleArrow((Object)_optDouble, (Procedures.Procedure1)_function_1);
                    Double _optDouble_1 = this._jsonAdapter.optDouble((JsonObject)srcPnt, "y");
                    Procedures.Procedure1 _function_2 = it -> section.setStartY(it.doubleValue());
                    ObjectExtensions.operator_doubleArrow((Object)_optDouble_1, (Procedures.Procedure1)_function_2);
                }
            };
            ObjectExtensions.operator_doubleArrow((Object)_optJSONObject, (Procedures.Procedure1)_function);
            JsonObject _optJSONObject_1 = this._jsonAdapter.optJSONObject(jsonObj, "targetPoint");
            Procedures.Procedure1 _function_1 = tgtPnt -> {
                if (tgtPnt != null) {
                    Double _optDouble = this._jsonAdapter.optDouble((JsonObject)tgtPnt, "x");
                    Procedures.Procedure1 _function_2 = it -> section.setEndX(it.doubleValue());
                    ObjectExtensions.operator_doubleArrow((Object)_optDouble, (Procedures.Procedure1)_function_2);
                    Double _optDouble_1 = this._jsonAdapter.optDouble((JsonObject)tgtPnt, "y");
                    Procedures.Procedure1 _function_3 = it -> section.setEndY(it.doubleValue());
                    ObjectExtensions.operator_doubleArrow((Object)_optDouble_1, (Procedures.Procedure1)_function_3);
                }
            };
            ObjectExtensions.operator_doubleArrow((Object)_optJSONObject_1, (Procedures.Procedure1)_function_1);
            JsonArray _optJSONArray = this._jsonAdapter.optJSONArray(jsonObj, "bendPoints");
            Procedures.Procedure1 _function_2 = bendPoints -> {
                if (bendPoints != null) {
                    int _sizeJsonArr = this._jsonAdapter.sizeJsonArr((JsonArray)bendPoints);
                    ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _sizeJsonArr, true);
                    for (Integer i : _doubleDotLessThan) {
                        JsonObject _optJSONObject_2 = this._jsonAdapter.optJSONObject((JsonArray)bendPoints, i);
                        Procedures.Procedure1 _function_3 = bendPoint -> ElkGraphUtil.createBendPoint((ElkEdgeSection)section, (double)this._jsonAdapter.optDouble((JsonObject)bendPoint, "x"), (double)this._jsonAdapter.optDouble((JsonObject)bendPoint, "y"));
                        ObjectExtensions.operator_doubleArrow((Object)_optJSONObject_2, (Procedures.Procedure1)_function_3);
                    }
                }
            };
            _xifexpression = _xblockexpression_1 = (JsonArray)ObjectExtensions.operator_doubleArrow((Object)_optJSONArray, (Procedures.Procedure1)_function_2);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private JsonArray transformEdge(Object jsonObjA, ElkNode parent) {
        JsonArray _xblockexpression = null;
        JsonObject jsonObj = this._jsonAdapter.toJsonObject(jsonObjA);
        ElkEdge edge = this.register(ElkGraphUtil.createEdge((ElkNode)parent), (Object)jsonObj);
        edge.setIdentifier(this._jsonAdapter.getIdSave(jsonObj));
        JsonArray _optJSONArray = this._jsonAdapter.optJSONArray(jsonObj, "sources");
        Procedures.Procedure1 _function = sources -> {
            if (sources != null) {
                int _sizeJsonArr = this._jsonAdapter.sizeJsonArr((JsonArray)sources);
                ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _sizeJsonArr, true);
                for (Integer i : _doubleDotLessThan) {
                    ElkConnectableShape sourceElement = this.shapeById(this._jsonAdapter.asId(this._jsonAdapter.getJsonArr((JsonArray)sources, i)));
                    if (sourceElement == null) continue;
                    EList _sources = edge.getSources();
                    _sources.add((Object)sourceElement);
                }
            }
        };
        ObjectExtensions.operator_doubleArrow((Object)_optJSONArray, (Procedures.Procedure1)_function);
        JsonArray _optJSONArray_1 = this._jsonAdapter.optJSONArray(jsonObj, "targets");
        Procedures.Procedure1 _function_1 = targets -> {
            if (targets != null) {
                int _sizeJsonArr = this._jsonAdapter.sizeJsonArr((JsonArray)targets);
                ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _sizeJsonArr, true);
                for (Integer i : _doubleDotLessThan) {
                    ElkConnectableShape targetElement = this.shapeById(this._jsonAdapter.asId(this._jsonAdapter.getJsonArr((JsonArray)targets, i)));
                    if (targetElement == null) continue;
                    EList _targets = edge.getTargets();
                    _targets.add((Object)targetElement);
                }
            }
        };
        ObjectExtensions.operator_doubleArrow((Object)_optJSONArray_1, (Procedures.Procedure1)_function_1);
        if (edge.getSources().isEmpty() || edge.getTargets().isEmpty()) {
            String _idSave = this._jsonAdapter.getIdSave(jsonObj);
            String _plus = "An edge must have at least one source and one target (edge id: '" + _idSave;
            String _plus_1 = _plus + "').";
            throw this._jsonAdapter.formatError(_plus_1);
        }
        this.transformProperties(jsonObj, (IPropertyHolder)edge);
        this.transformEdgeSections(jsonObj, edge);
        _xblockexpression = this.transformLabels(jsonObj, (ElkGraphElement)edge);
        return _xblockexpression;
    }

    private void transformEdgeSections(Object jsonObjA, ElkEdge edge) {
        ElkEdgeSection section_2;
        JsonObject jsonObj = this._jsonAdapter.toJsonObject(jsonObjA);
        HashMultimap incomingSectionIdentifiers = HashMultimap.create();
        HashMultimap outgoingSectionIdentifiers = HashMultimap.create();
        JsonArray _optJSONArray = this._jsonAdapter.optJSONArray(jsonObj, "sections");
        Procedures.Procedure1 _function = arg_0 -> this.lambda$13(edge, (Multimap)incomingSectionIdentifiers, (Multimap)outgoingSectionIdentifiers, arg_0);
        ObjectExtensions.operator_doubleArrow((Object)_optJSONArray, (Procedures.Procedure1)_function);
        Set _keySet = incomingSectionIdentifiers.keySet();
        for (ElkEdgeSection section : _keySet) {
            Collection _get = incomingSectionIdentifiers.get((Object)section);
            for (Object id : _get) {
                ElkEdgeSection referencedSection = (ElkEdgeSection)this.edgeSectionIdMap.get(id);
                if (referencedSection != null) {
                    EList _incomingSections = section.getIncomingSections();
                    _incomingSections.add((Object)referencedSection);
                    continue;
                }
                String _idSave = this._jsonAdapter.getIdSave(jsonObj);
                String _plus = "Referenced edge section does not exist: " + String.valueOf(id) + " (edge id: '" + _idSave;
                String _plus_1 = _plus + "').";
                throw this._jsonAdapter.formatError(_plus_1);
            }
        }
        Set _keySet_1 = outgoingSectionIdentifiers.keySet();
        for (ElkEdgeSection section_1 : _keySet_1) {
            Collection _get_1 = outgoingSectionIdentifiers.get((Object)section_1);
            for (Object id_1 : _get_1) {
                ElkEdgeSection referencedSection = (ElkEdgeSection)this.edgeSectionIdMap.get(id_1);
                if (referencedSection != null) {
                    EList _outgoingSections = section_1.getOutgoingSections();
                    _outgoingSections.add((Object)referencedSection);
                    continue;
                }
                String _idSave = this._jsonAdapter.getIdSave(jsonObj);
                String _plus = "Referenced edge section does not exist: " + String.valueOf(id_1) + " (edge id: '" + _idSave;
                String _plus_1 = _plus + "').";
                throw this._jsonAdapter.formatError(_plus_1);
            }
        }
        if (edge.isConnected() && !edge.isHyperedge() && edge.getSections().size() == 1 && (section_2 = (ElkEdgeSection)edge.getSections().get(0)).getIncomingShape() == null && section_2.getOutgoingShape() == null) {
            section_2.setIncomingShape((ElkConnectableShape)edge.getSources().get(0));
            section_2.setOutgoingShape((ElkConnectableShape)edge.getTargets().get(0));
        }
    }

    private JsonArray fillEdgeSectionCoordinates(Object jsonObjA, ElkEdgeSection section) {
        JsonArray _xblockexpression = null;
        JsonObject jsonObj = this._jsonAdapter.toJsonObject(jsonObjA);
        JsonObject _optJSONObject = this._jsonAdapter.optJSONObject(jsonObj, "startPoint");
        Procedures.Procedure1 _function = startPoint -> {
            if (startPoint == null) {
                throw this._jsonAdapter.formatError("All edge sections need a start point.");
            }
            Double _optDouble = this._jsonAdapter.optDouble((JsonObject)startPoint, "x");
            Procedures.Procedure1 _function_1 = it -> section.setStartX(it.doubleValue());
            ObjectExtensions.operator_doubleArrow((Object)_optDouble, (Procedures.Procedure1)_function_1);
            Double _optDouble_1 = this._jsonAdapter.optDouble((JsonObject)startPoint, "y");
            Procedures.Procedure1 _function_2 = it -> section.setStartY(it.doubleValue());
            ObjectExtensions.operator_doubleArrow((Object)_optDouble_1, (Procedures.Procedure1)_function_2);
        };
        ObjectExtensions.operator_doubleArrow((Object)_optJSONObject, (Procedures.Procedure1)_function);
        JsonObject _optJSONObject_1 = this._jsonAdapter.optJSONObject(jsonObj, "endPoint");
        Procedures.Procedure1 _function_1 = endPoint -> {
            if (endPoint == null) {
                throw this._jsonAdapter.formatError("All edge sections need an end point.");
            }
            Double _optDouble = this._jsonAdapter.optDouble((JsonObject)endPoint, "x");
            Procedures.Procedure1 _function_2 = it -> section.setEndX(it.doubleValue());
            ObjectExtensions.operator_doubleArrow((Object)_optDouble, (Procedures.Procedure1)_function_2);
            Double _optDouble_1 = this._jsonAdapter.optDouble((JsonObject)endPoint, "y");
            Procedures.Procedure1 _function_3 = it -> section.setEndY(it.doubleValue());
            ObjectExtensions.operator_doubleArrow((Object)_optDouble_1, (Procedures.Procedure1)_function_3);
        };
        ObjectExtensions.operator_doubleArrow((Object)_optJSONObject_1, (Procedures.Procedure1)_function_1);
        JsonArray _optJSONArray = this._jsonAdapter.optJSONArray(jsonObj, "bendPoints");
        Procedures.Procedure1 _function_2 = bendPoints -> {
            if (bendPoints != null) {
                int _sizeJsonArr = this._jsonAdapter.sizeJsonArr((JsonArray)bendPoints);
                ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _sizeJsonArr, true);
                for (Integer i : _doubleDotLessThan) {
                    JsonObject _optJSONObject_2 = this._jsonAdapter.optJSONObject((JsonArray)bendPoints, i);
                    Procedures.Procedure1 _function_3 = bendPoint -> ElkGraphUtil.createBendPoint((ElkEdgeSection)section, (double)this._jsonAdapter.optDouble((JsonObject)bendPoint, "x"), (double)this._jsonAdapter.optDouble((JsonObject)bendPoint, "y"));
                    ObjectExtensions.operator_doubleArrow((Object)_optJSONObject_2, (Procedures.Procedure1)_function_3);
                }
            }
        };
        _xblockexpression = (JsonArray)ObjectExtensions.operator_doubleArrow((Object)_optJSONArray, (Procedures.Procedure1)_function_2);
        return _xblockexpression;
    }

    private void transformProperties(Object jsonObjA, IPropertyHolder layoutData) {
        JsonObject jsonObj = this._jsonAdapter.toJsonObject(jsonObjA);
        JsonObject layoutOptions = this._jsonAdapter.optJSONObject(jsonObj, "layoutOptions");
        if (layoutOptions == null) {
            layoutOptions = this._jsonAdapter.optJSONObject(jsonObj, "properties");
        }
        if (layoutOptions != null) {
            JsonObject opts = layoutOptions;
            Iterable<String> _keysJsonObj = null;
            if (opts != null) {
                _keysJsonObj = this._jsonAdapter.keysJsonObj(opts);
            }
            if (_keysJsonObj != null) {
                Consumer<String> _function = k -> {
                    JsonElement _jsonObj = this._jsonAdapter.getJsonObj(opts, (String)k);
                    String _stringVal = null;
                    if (_jsonObj != null) {
                        _stringVal = this._jsonAdapter.stringVal(_jsonObj);
                    }
                    String value = _stringVal;
                    this.setOption(layoutData, (String)k, value);
                };
                _keysJsonObj.forEach(_function);
            }
        }
    }

    private void transformIndividualSpacings(Object jsonObjA, IPropertyHolder layoutData) {
        JsonObject jsonObj = this._jsonAdapter.toJsonObject(jsonObjA);
        JsonObject jsonIndividualSpacings = this._jsonAdapter.optJSONObject(jsonObj, "individualSpacings");
        if (jsonIndividualSpacings != null) {
            boolean _not;
            boolean _hasProperty = layoutData.hasProperty(CoreOptions.SPACING_INDIVIDUAL);
            boolean bl = _not = !_hasProperty;
            if (_not) {
                IndividualSpacings _individualSpacings = new IndividualSpacings();
                layoutData.setProperty(CoreOptions.SPACING_INDIVIDUAL, (Object)_individualSpacings);
            }
            IndividualSpacings individualSpacings = (IndividualSpacings)layoutData.getProperty(CoreOptions.SPACING_INDIVIDUAL);
            JsonObject opts = jsonIndividualSpacings;
            Iterable<String> _keysJsonObj = null;
            if (opts != null) {
                _keysJsonObj = this._jsonAdapter.keysJsonObj(opts);
            }
            if (_keysJsonObj != null) {
                Consumer<String> _function = k -> {
                    JsonElement _jsonObj = this._jsonAdapter.getJsonObj(opts, (String)k);
                    String _stringVal = null;
                    if (_jsonObj != null) {
                        _stringVal = this._jsonAdapter.stringVal(_jsonObj);
                    }
                    String value = _stringVal;
                    this.setOption((IPropertyHolder)individualSpacings, (String)k, value);
                };
                _keysJsonObj.forEach(_function);
            }
        }
    }

    private IPropertyHolder setOption(IPropertyHolder e, String id, String value) {
        IPropertyHolder _xblockexpression = null;
        LayoutOptionData optionData = LayoutMetaDataService.getInstance().getOptionDataBySuffix(id);
        IPropertyHolder _xifexpression = null;
        if (optionData != null) {
            IPropertyHolder _xblockexpression_1 = null;
            Object parsed = optionData.parseValue(value);
            IPropertyHolder _xifexpression_1 = null;
            if (parsed != null) {
                _xifexpression_1 = e.setProperty((IProperty)optionData, parsed);
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private JsonArray transformLabels(Object jsonObjA, ElkGraphElement element) {
        JsonArray _xblockexpression = null;
        JsonObject jsonObj = this._jsonAdapter.toJsonObject(jsonObjA);
        JsonArray _optJSONArray = this._jsonAdapter.optJSONArray(jsonObj, "labels");
        Procedures.Procedure1 _function = labels -> {
            if (labels != null) {
                int _sizeJsonArr = this._jsonAdapter.sizeJsonArr((JsonArray)labels);
                ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _sizeJsonArr, true);
                for (Integer i : _doubleDotLessThan) {
                    JsonObject jsonLabel = this._jsonAdapter.optJSONObject((JsonArray)labels, i);
                    if (jsonLabel == null) continue;
                    ElkLabel label = ElkGraphUtil.createLabel((String)this._jsonAdapter.optString(jsonLabel, "text"), (ElkGraphElement)element);
                    this.labelJsonMap.put(label, jsonLabel);
                    boolean _hasJsonObj = this._jsonAdapter.hasJsonObj(jsonLabel, "id");
                    if (_hasJsonObj) {
                        label.setIdentifier(this._jsonAdapter.getIdSave(jsonLabel));
                    }
                    this.transformProperties(jsonLabel, (IPropertyHolder)label);
                    this.transformShapeLayout(jsonLabel, (ElkShape)label);
                }
            }
        };
        _xblockexpression = (JsonArray)ObjectExtensions.operator_doubleArrow((Object)_optJSONArray, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    private JsonArray transformPorts(Object jsonObjA, ElkNode parent) {
        JsonArray _xblockexpression = null;
        JsonObject jsonObj = this._jsonAdapter.toJsonObject(jsonObjA);
        JsonArray _optJSONArray = this._jsonAdapter.optJSONArray(jsonObj, "ports");
        Procedures.Procedure1 _function = ports -> {
            if (ports != null) {
                int _sizeJsonArr = this._jsonAdapter.sizeJsonArr((JsonArray)ports);
                ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _sizeJsonArr, true);
                for (Integer i : _doubleDotLessThan) {
                    JsonObject _optJSONObject = this._jsonAdapter.optJSONObject((JsonArray)ports, i);
                    if (_optJSONObject == null) continue;
                    this.transformPort(_optJSONObject, parent);
                }
            }
        };
        _xblockexpression = (JsonArray)ObjectExtensions.operator_doubleArrow((Object)_optJSONArray, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    private JsonArray transformPort(Object jsonPort, ElkNode parent) {
        JsonArray _xblockexpression = null;
        ElkPort port = this.register(ElkGraphUtil.createPort((ElkNode)parent), jsonPort);
        port.setIdentifier(this._jsonAdapter.getIdSave(this._jsonAdapter.toJsonObject(jsonPort)));
        this.transformProperties(jsonPort, (IPropertyHolder)port);
        this.transformShapeLayout(jsonPort, (ElkShape)port);
        _xblockexpression = this.transformLabels(jsonPort, (ElkGraphElement)port);
        return _xblockexpression;
    }

    private Double transformShapeLayout(Object jsonObjA, ElkShape shape) {
        Double _xblockexpression = null;
        JsonObject jsonObj = this._jsonAdapter.toJsonObject(jsonObjA);
        Double _optDouble = this._jsonAdapter.optDouble(jsonObj, "x");
        Procedures.Procedure1 _function = it -> shape.setX(this.doubleValueValid((Double)it));
        ObjectExtensions.operator_doubleArrow((Object)_optDouble, (Procedures.Procedure1)_function);
        Double _optDouble_1 = this._jsonAdapter.optDouble(jsonObj, "y");
        Procedures.Procedure1 _function_1 = it -> shape.setY(this.doubleValueValid((Double)it));
        ObjectExtensions.operator_doubleArrow((Object)_optDouble_1, (Procedures.Procedure1)_function_1);
        Double _optDouble_2 = this._jsonAdapter.optDouble(jsonObj, "width");
        Procedures.Procedure1 _function_2 = it -> shape.setWidth(this.doubleValueValid((Double)it));
        ObjectExtensions.operator_doubleArrow((Object)_optDouble_2, (Procedures.Procedure1)_function_2);
        Double _optDouble_3 = this._jsonAdapter.optDouble(jsonObj, "height");
        Procedures.Procedure1 _function_3 = it -> shape.setHeight(this.doubleValueValid((Double)it));
        _xblockexpression = (Double)ObjectExtensions.operator_doubleArrow((Object)_optDouble_3, (Procedures.Procedure1)_function_3);
        return _xblockexpression;
    }

    private double doubleValueValid(Double d) {
        if (d == null || d.isInfinite() || d.isNaN()) {
            return 0.0;
        }
        return d;
    }

    private ElkConnectableShape shapeById(Object id) {
        ElkNode node = (ElkNode)this.nodeIdMap.get(id);
        if (node != null) {
            return node;
        }
        ElkPort port = (ElkPort)this.portIdMap.get(id);
        if (port != null) {
            return port;
        }
        throw this._jsonAdapter.formatError("Referenced shape does not exist: " + String.valueOf(id));
    }

    public void transferLayout(ElkNode graph) {
        Procedures.Procedure1 _function = element -> this.transferLayoutInt1(element);
        IteratorExtensions.forEach((Iterator)ElkGraphUtil.propertiesSkippingIteratorFor((EObject)graph, (boolean)true), (Procedures.Procedure1)_function);
        Procedures.Procedure1 _function_1 = element -> this.transferLayoutInt2(element);
        IteratorExtensions.forEach((Iterator)ElkGraphUtil.propertiesSkippingIteratorFor((EObject)graph, (boolean)true), (Procedures.Procedure1)_function_1);
    }

    private Object _transferLayoutInt1(ElkNode node) {
        Object jsonObj = this.nodeJsonMap.get((Object)node);
        if (jsonObj == null) {
            throw this._jsonAdapter.formatError("Node did not exist in input.");
        }
        this.recordGlobalCoords((ElkShape)node);
        this.recordCoordinateModes((ElkGraphElement)node);
        this.transferShapeLayout((ElkShape)node, jsonObj);
        return null;
    }

    private Object _transferLayoutInt1(ElkPort port) {
        Object jsonObj = this.portJsonMap.get(port);
        if (jsonObj == null) {
            throw this._jsonAdapter.formatError("Port did not exist in input.");
        }
        this.recordGlobalCoords((ElkShape)port);
        this.recordCoordinateModes((ElkGraphElement)port);
        this.transferShapeLayout((ElkShape)port, jsonObj);
        return null;
    }

    private Object _transferLayoutInt2(ElkEdge edge) {
        EdgeCoords _edgeCoordsMode;
        boolean _tripleEquals;
        boolean _hasProperty;
        boolean _not;
        JsonObject jsonObj = this._jsonAdapter.toJsonObject(this.edgeJsonMap.get(edge));
        if (jsonObj == null) {
            throw this._jsonAdapter.formatError("Edge did not exist in input.");
        }
        this.recordCoordinateModes((ElkGraphElement)edge);
        Object edgeId = this._jsonAdapter.getId(jsonObj);
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)edge.getSections());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            JsonArray sections = this._jsonAdapter.newJsonArray();
            Procedures.Procedure2 _function = (elkSection, i) -> {
                boolean _isEmpty_1;
                boolean _not_3;
                boolean _isEmpty;
                boolean _not_2;
                ElkConnectableShape _outgoingShape;
                boolean _tripleNotEquals_1;
                ElkConnectableShape _incomingShape;
                boolean _tripleNotEquals;
                boolean _not_1;
                Object maybeSection = this.edgeSectionJsonMap.get(elkSection);
                if (maybeSection == null) {
                    maybeSection = this._jsonAdapter.newJsonObject();
                    JsonObject _jsonObject = this._jsonAdapter.toJsonObject(maybeSection);
                    String _plus = String.valueOf(edgeId) + "_s";
                    String _plus_1 = _plus + String.valueOf(i);
                    this._jsonAdapter.addJsonObj(_jsonObject, "id", _plus_1);
                }
                JsonObject jsonSection = this._jsonAdapter.toJsonObject(maybeSection);
                this._jsonAdapter.addJsonArr(sections, (JsonElement)jsonSection);
                JsonObject startPoint = this._jsonAdapter.newJsonObject();
                this._jsonAdapter.addJsonObj(startPoint, "x", this.adjustX((ElkGraphElement)edge, elkSection.getStartX()));
                this._jsonAdapter.addJsonObj(startPoint, "y", this.adjustY((ElkGraphElement)edge, elkSection.getStartY()));
                this._jsonAdapter.addJsonObj(jsonSection, "startPoint", (JsonElement)startPoint);
                JsonObject endPoint = this._jsonAdapter.newJsonObject();
                this._jsonAdapter.addJsonObj(endPoint, "x", this.adjustX((ElkGraphElement)edge, elkSection.getEndX()));
                this._jsonAdapter.addJsonObj(endPoint, "y", this.adjustY((ElkGraphElement)edge, elkSection.getEndY()));
                this._jsonAdapter.addJsonObj(jsonSection, "endPoint", (JsonElement)endPoint);
                boolean _isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)elkSection.getBendPoints());
                boolean bl = _not_1 = !_isNullOrEmpty_1;
                if (_not_1) {
                    JsonArray bendPoints = this._jsonAdapter.newJsonArray();
                    Consumer<ElkBendPoint> _function_1 = pnt -> {
                        JsonObject jsonPnt = this._jsonAdapter.newJsonObject();
                        this._jsonAdapter.addJsonObj(jsonPnt, "x", this.adjustX((ElkGraphElement)edge, pnt.getX()));
                        this._jsonAdapter.addJsonObj(jsonPnt, "y", this.adjustY((ElkGraphElement)edge, pnt.getY()));
                        this._jsonAdapter.addJsonArr(bendPoints, (JsonElement)jsonPnt);
                    };
                    elkSection.getBendPoints().forEach(_function_1);
                    this._jsonAdapter.addJsonObj(jsonSection, "bendPoints", (JsonElement)bendPoints);
                }
                boolean bl2 = _tripleNotEquals = (_incomingShape = elkSection.getIncomingShape()) != null;
                if (_tripleNotEquals) {
                    this._jsonAdapter.addJsonObj(jsonSection, "incomingShape", this.idByElement((EMapPropertyHolder)elkSection.getIncomingShape()));
                }
                boolean bl3 = _tripleNotEquals_1 = (_outgoingShape = elkSection.getOutgoingShape()) != null;
                if (_tripleNotEquals_1) {
                    this._jsonAdapter.addJsonObj(jsonSection, "outgoingShape", this.idByElement((EMapPropertyHolder)elkSection.getOutgoingShape()));
                }
                boolean bl4 = _not_2 = !(_isEmpty = elkSection.getIncomingSections().isEmpty());
                if (_not_2) {
                    JsonArray incomingSections = this._jsonAdapter.newJsonArray();
                    Consumer<ElkEdgeSection> _function_2 = sec -> this._jsonAdapter.addJsonArr(incomingSections, this.idByElement((EMapPropertyHolder)sec));
                    elkSection.getIncomingSections().forEach(_function_2);
                    this._jsonAdapter.addJsonObj(jsonSection, "incomingSections", (JsonElement)incomingSections);
                }
                boolean bl5 = _not_3 = !(_isEmpty_1 = elkSection.getOutgoingSections().isEmpty());
                if (_not_3) {
                    JsonArray outgoingSections = this._jsonAdapter.newJsonArray();
                    Consumer<ElkEdgeSection> _function_3 = sec -> this._jsonAdapter.addJsonArr(outgoingSections, this.idByElement((EMapPropertyHolder)sec));
                    elkSection.getOutgoingSections().forEach(_function_3);
                    this._jsonAdapter.addJsonObj(jsonSection, "outgoingSections", (JsonElement)outgoingSections);
                }
            };
            IterableExtensions.forEach((Iterable)edge.getSections(), (Procedures.Procedure2)_function);
            this._jsonAdapter.removeJsonObj(jsonObj, "sections");
            this._jsonAdapter.addJsonObj(jsonObj, "sections", (JsonElement)sections);
        }
        if (_hasProperty = edge.hasProperty(CoreOptions.JUNCTION_POINTS)) {
            boolean _not_1;
            KVectorChain jps = (KVectorChain)edge.getProperty(CoreOptions.JUNCTION_POINTS);
            boolean _isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)jps);
            boolean bl2 = _not_1 = !_isNullOrEmpty_1;
            if (_not_1) {
                JsonArray jsonJPs = this._jsonAdapter.newJsonArray();
                Consumer<KVector> _function_1 = jp -> {
                    JsonObject jsonPnt = this._jsonAdapter.newJsonObject();
                    this._jsonAdapter.addJsonObj(jsonPnt, "x", this.adjustX((ElkGraphElement)edge, jp.x));
                    this._jsonAdapter.addJsonObj(jsonPnt, "y", this.adjustY((ElkGraphElement)edge, jp.y));
                    this._jsonAdapter.addJsonArr(jsonJPs, (JsonElement)jsonPnt);
                };
                jps.forEach(_function_1);
                this._jsonAdapter.addJsonObj(jsonObj, "junctionPoints", (JsonElement)jsonJPs);
            }
        }
        boolean bl3 = _tripleEquals = (_edgeCoordsMode = this.edgeCoordsMode((ElkGraphElement)this.originalParent(edge))) == EdgeCoords.CONTAINER;
        if (_tripleEquals) {
            this._jsonAdapter.addJsonObj(jsonObj, "container", edge.getContainingNode().getIdentifier());
        }
        return null;
    }

    private Object _transferLayoutInt2(ElkLabel label) {
        Object jsonObj = this.labelJsonMap.get(label);
        this.recordGlobalCoords((ElkShape)label);
        this.recordCoordinateModes((ElkGraphElement)label);
        this.transferShapeLayout((ElkShape)label, jsonObj);
        return null;
    }

    private Object _transferLayoutInt1(Object obj) {
        return null;
    }

    private Object _transferLayoutInt2(Object obj) {
        return null;
    }

    private void transferShapeLayout(ElkShape shape, Object jsonObjA) {
        JsonObject jsonObj = this._jsonAdapter.toJsonObject(jsonObjA);
        ElkGraphElement parent = this.jsonParent((ElkGraphElement)shape);
        Double _elvis = null;
        Double _adjustX = null;
        if (parent != null) {
            _adjustX = this.adjustX(parent, shape.getX());
        }
        if (_adjustX != null) {
            _elvis = _adjustX;
        } else {
            double _x = shape.getX();
            _elvis = _x;
        }
        this._jsonAdapter.addJsonObj(jsonObj, "x", _elvis);
        Double _elvis_1 = null;
        Double _adjustY = null;
        if (parent != null) {
            _adjustY = this.adjustY(parent, shape.getY());
        }
        if (_adjustY != null) {
            _elvis_1 = _adjustY;
        } else {
            double _y = shape.getY();
            _elvis_1 = _y;
        }
        this._jsonAdapter.addJsonObj(jsonObj, "y", _elvis_1);
        this._jsonAdapter.addJsonObj(jsonObj, "width", shape.getWidth());
        this._jsonAdapter.addJsonObj(jsonObj, "height", shape.getHeight());
    }

    private Double _adjustX(ElkEdge edge, Double x) {
        EdgeCoords mode = this.edgeCoordsMode((ElkGraphElement)this.originalParent(edge));
        Double _switchResult = null;
        if (mode != null) {
            switch (mode) {
                case ROOT: {
                    Double _globalX = this.globalX((ElkShape)edge.getContainingNode());
                    _switchResult = DoubleExtensions.operator_plus((Double)x, (Number)_globalX);
                    break;
                }
                case PARENT: {
                    Double _globalX_1 = this.globalX((ElkShape)edge.getContainingNode());
                    double _plus = DoubleExtensions.operator_plus((Double)x, (Number)_globalX_1);
                    Double _globalX_2 = this.globalX((ElkShape)this.originalParent(edge));
                    _switchResult = _plus - _globalX_2;
                    break;
                }
                default: {
                    _switchResult = x;
                    break;
                }
            }
        } else {
            _switchResult = x;
        }
        return _switchResult;
    }

    private Double _adjustX(ElkShape shape, Double x) {
        ShapeCoords mode = this.shapeCoordsMode((ElkGraphElement)shape);
        Double _switchResult = null;
        if (mode != null) {
            switch (mode) {
                case ROOT: {
                    Double _globalX = this.globalX(shape);
                    _switchResult = DoubleExtensions.operator_plus((Double)x, (Number)_globalX);
                    break;
                }
                default: {
                    _switchResult = x;
                    break;
                }
            }
        } else {
            _switchResult = x;
        }
        return _switchResult;
    }

    private Double _adjustY(ElkEdge edge, Double y) {
        EdgeCoords mode = this.edgeCoordsMode((ElkGraphElement)this.originalParent(edge));
        Double _switchResult = null;
        if (mode != null) {
            switch (mode) {
                case ROOT: {
                    Double _globalY = this.globalY((ElkShape)edge.getContainingNode());
                    _switchResult = DoubleExtensions.operator_plus((Double)y, (Number)_globalY);
                    break;
                }
                case PARENT: {
                    Double _globalY_1 = this.globalY((ElkShape)edge.getContainingNode());
                    double _plus = DoubleExtensions.operator_plus((Double)y, (Number)_globalY_1);
                    Double _globalY_2 = this.globalY((ElkShape)this.originalParent(edge));
                    _switchResult = _plus - _globalY_2;
                    break;
                }
                default: {
                    _switchResult = y;
                    break;
                }
            }
        } else {
            _switchResult = y;
        }
        return _switchResult;
    }

    private Double _adjustY(ElkShape shape, Double y) {
        ShapeCoords mode = this.shapeCoordsMode((ElkGraphElement)shape);
        Double _switchResult = null;
        if (mode != null) {
            switch (mode) {
                case ROOT: {
                    Double _globalY = this.globalY(shape);
                    _switchResult = DoubleExtensions.operator_plus((Double)y, (Number)_globalY);
                    break;
                }
                default: {
                    _switchResult = y;
                    break;
                }
            }
        } else {
            _switchResult = y;
        }
        return _switchResult;
    }

    private Object _idByElement(ElkNode node) {
        return this.nodeIdMap.inverse().get((Object)node);
    }

    private Object _idByElement(ElkPort port) {
        return this.portIdMap.inverse().get((Object)port);
    }

    private Object _idByElement(ElkEdgeSection section) {
        return this.edgeSectionIdMap.inverse().get((Object)section);
    }

    private ElkNode register(ElkNode node, Object obj) {
        Object id = this._jsonAdapter.getId(this._jsonAdapter.toJsonObject(obj));
        this.nodeIdMap.put(id, (Object)node);
        this.nodeJsonMap.put((Object)node, obj);
        return node;
    }

    private ElkPort register(ElkPort port, Object obj) {
        Object id = this._jsonAdapter.getId(this._jsonAdapter.toJsonObject(obj));
        this.portIdMap.put(id, (Object)port);
        this.portJsonMap.put(port, obj);
        return port;
    }

    private ElkEdge register(ElkEdge edge, Object obj) {
        Object id = this._jsonAdapter.getId(this._jsonAdapter.toJsonObject(obj));
        this.edgeIdMap.put(id, edge);
        this.edgeJsonMap.put(edge, obj);
        this.edgeOriginalParentMap.put(edge, edge.getContainingNode());
        return edge;
    }

    private ElkEdgeSection register(ElkEdgeSection edgeSection, Object obj) {
        Object id = this._jsonAdapter.getId(this._jsonAdapter.toJsonObject(obj));
        this.edgeSectionIdMap.put(id, (Object)edgeSection);
        this.edgeSectionJsonMap.put(edgeSection, obj);
        return edgeSection;
    }

    private EdgeCoords recordCoordinateModes(ElkGraphElement element) {
        EdgeCoords _xblockexpression = null;
        ElkGraphElement parent = this.jsonParent(element);
        ShapeCoords _elvis = null;
        ShapeCoords _property = (ShapeCoords)element.getProperty(CoreOptions.JSON_SHAPE_COORDS);
        _elvis = _property != null ? _property : ShapeCoords.INHERIT;
        ShapeCoords scm = _elvis;
        if (scm == ShapeCoords.INHERIT) {
            ShapeCoords _elvis_1 = null;
            ShapeCoords _shapeCoordsMode = this.shapeCoordsMode(parent);
            _elvis_1 = _shapeCoordsMode != null ? _shapeCoordsMode : ShapeCoords.PARENT;
            scm = _elvis_1;
        }
        this.shapeCoordsMap.put(element, scm);
        EdgeCoords _elvis_2 = null;
        EdgeCoords _property_1 = (EdgeCoords)element.getProperty(CoreOptions.JSON_EDGE_COORDS);
        _elvis_2 = _property_1 != null ? _property_1 : EdgeCoords.INHERIT;
        EdgeCoords ecm = _elvis_2;
        if (ecm == EdgeCoords.INHERIT) {
            EdgeCoords _elvis_3 = null;
            EdgeCoords _edgeCoordsMode = this.edgeCoordsMode(parent);
            _elvis_3 = _edgeCoordsMode != null ? _edgeCoordsMode : EdgeCoords.CONTAINER;
            ecm = _elvis_3;
        }
        _xblockexpression = this.edgeCoordsMap.put(element, ecm);
        return _xblockexpression;
    }

    private Double recordGlobalCoords(ElkShape shape) {
        Double _xblockexpression = null;
        ElkGraphElement parent = this.jsonParent((ElkGraphElement)shape);
        ElkShape _shapeAncestor = null;
        if (parent != null) {
            _shapeAncestor = this.shapeAncestor(parent);
        }
        ElkShape shapeA = _shapeAncestor;
        Number _elvis = null;
        Double _globalX = this.globalX(shapeA);
        _elvis = _globalX != null ? (Number)_globalX : (Number)0;
        Number dx = _elvis;
        Number _elvis_1 = null;
        Double _globalY = this.globalY(shapeA);
        _elvis_1 = _globalY != null ? (Number)_globalY : (Number)0;
        Number dy = _elvis_1;
        double _x = shape.getX();
        double _plus = DoubleExtensions.operator_plus((Double)_x, (Number)dx);
        this.globalXMap.put(shape, _plus);
        double _y = shape.getY();
        double _plus_1 = DoubleExtensions.operator_plus((Double)_y, (Number)dy);
        _xblockexpression = this.globalYMap.put(shape, _plus_1);
        return _xblockexpression;
    }

    private ElkShape _shapeAncestor(ElkEdge edge) {
        return this.originalParent(edge);
    }

    private ElkShape _shapeAncestor(ElkShape shape) {
        return shape;
    }

    private ElkGraphElement _jsonParent(ElkNode node) {
        return node.getParent();
    }

    private ElkGraphElement _jsonParent(ElkPort port) {
        return port.getParent();
    }

    private ElkGraphElement _jsonParent(ElkEdge edge) {
        return this.originalParent(edge);
    }

    private ElkGraphElement _jsonParent(ElkLabel label) {
        return label.getParent();
    }

    private ElkNode originalParent(ElkEdge edge) {
        return this.edgeOriginalParentMap.get(edge);
    }

    private Double globalX(ElkShape shape) {
        return this.globalXMap.get(shape);
    }

    private Double globalY(ElkShape shape) {
        return this.globalYMap.get(shape);
    }

    private ShapeCoords shapeCoordsMode(ElkGraphElement element) {
        return this.shapeCoordsMap.get(element);
    }

    private EdgeCoords edgeCoordsMode(ElkGraphElement element) {
        return this.edgeCoordsMap.get(element);
    }

    @XbaseGenerated
    private Object transferLayoutInt1(Object node) {
        if (node instanceof ElkNode) {
            return this._transferLayoutInt1((ElkNode)node);
        }
        if (node instanceof ElkPort) {
            return this._transferLayoutInt1((ElkPort)node);
        }
        if (node != null) {
            return this._transferLayoutInt1(node);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(node).toString());
    }

    @XbaseGenerated
    private Object transferLayoutInt2(Object label) {
        if (label instanceof ElkLabel) {
            return this._transferLayoutInt2((ElkLabel)label);
        }
        if (label instanceof ElkEdge) {
            return this._transferLayoutInt2((ElkEdge)label);
        }
        if (label != null) {
            return this._transferLayoutInt2(label);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(label).toString());
    }

    @XbaseGenerated
    private Double adjustX(ElkGraphElement edge, Double x) {
        if (edge instanceof ElkEdge) {
            return this._adjustX((ElkEdge)edge, x);
        }
        if (edge instanceof ElkShape) {
            return this._adjustX((ElkShape)edge, x);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(edge, x).toString());
    }

    @XbaseGenerated
    private Double adjustY(ElkGraphElement edge, Double y) {
        if (edge instanceof ElkEdge) {
            return this._adjustY((ElkEdge)edge, y);
        }
        if (edge instanceof ElkShape) {
            return this._adjustY((ElkShape)edge, y);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(edge, y).toString());
    }

    @XbaseGenerated
    private Object idByElement(EMapPropertyHolder node) {
        if (node instanceof ElkNode) {
            return this._idByElement((ElkNode)node);
        }
        if (node instanceof ElkPort) {
            return this._idByElement((ElkPort)node);
        }
        if (node instanceof ElkEdgeSection) {
            return this._idByElement((ElkEdgeSection)node);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(node).toString());
    }

    @XbaseGenerated
    private ElkShape shapeAncestor(ElkGraphElement edge) {
        if (edge instanceof ElkEdge) {
            return this._shapeAncestor((ElkEdge)edge);
        }
        if (edge instanceof ElkShape) {
            return this._shapeAncestor((ElkShape)edge);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(edge).toString());
    }

    @XbaseGenerated
    private ElkGraphElement jsonParent(ElkGraphElement node) {
        if (node instanceof ElkNode) {
            return this._jsonParent((ElkNode)node);
        }
        if (node instanceof ElkPort) {
            return this._jsonParent((ElkPort)node);
        }
        if (node instanceof ElkLabel) {
            return this._jsonParent((ElkLabel)node);
        }
        if (node instanceof ElkEdge) {
            return this._jsonParent((ElkEdge)node);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(node).toString());
    }

    private /* synthetic */ void lambda$13(ElkEdge elkEdge, Multimap multimap, Multimap multimap2, JsonArray sections) {
        if (sections != null) {
            int _sizeJsonArr = this._jsonAdapter.sizeJsonArr(sections);
            ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _sizeJsonArr, true);
            for (Integer i : _doubleDotLessThan) {
                JsonObject _optJSONObject = this._jsonAdapter.optJSONObject(sections, i);
                Procedures.Procedure1 _function_1 = jsonSection -> {
                    ElkEdgeSection elkSection = this.register(ElkGraphUtil.createEdgeSection((ElkEdge)elkEdge), jsonSection);
                    elkSection.setIdentifier(this._jsonAdapter.getIdSave((JsonObject)jsonSection));
                    this.fillEdgeSectionCoordinates(jsonSection, elkSection);
                    String _optString = this._jsonAdapter.optString((JsonObject)jsonSection, "incomingShape");
                    Procedures.Procedure1 _function_2 = jsonShapeId -> {
                        if (jsonShapeId != null) {
                            elkSection.setIncomingShape(this.shapeById(jsonShapeId));
                        }
                    };
                    ObjectExtensions.operator_doubleArrow((Object)_optString, (Procedures.Procedure1)_function_2);
                    String _optString_1 = this._jsonAdapter.optString((JsonObject)jsonSection, "outgoingShape");
                    Procedures.Procedure1 _function_3 = jsonShapeId -> {
                        if (jsonShapeId != null) {
                            elkSection.setOutgoingShape(this.shapeById(jsonShapeId));
                        }
                    };
                    ObjectExtensions.operator_doubleArrow((Object)_optString_1, (Procedures.Procedure1)_function_3);
                    JsonArray _optJSONArray_1 = this._jsonAdapter.optJSONArray((JsonObject)jsonSection, "incomingSections");
                    Procedures.Procedure1 _function_4 = jsonSectionIds -> {
                        if (jsonSectionIds != null) {
                            int _sizeJsonArr_1 = this._jsonAdapter.sizeJsonArr((JsonArray)jsonSectionIds);
                            ExclusiveRange _doubleDotLessThan_1 = new ExclusiveRange(0, _sizeJsonArr_1, true);
                            for (Integer j : _doubleDotLessThan_1) {
                                multimap.put((Object)elkSection, this._jsonAdapter.asId(this._jsonAdapter.getJsonArr((JsonArray)jsonSectionIds, j)));
                            }
                        }
                    };
                    ObjectExtensions.operator_doubleArrow((Object)_optJSONArray_1, (Procedures.Procedure1)_function_4);
                    JsonArray _optJSONArray_2 = this._jsonAdapter.optJSONArray((JsonObject)jsonSection, "outgoingSections");
                    Procedures.Procedure1 _function_5 = jsonSectionIds -> {
                        if (jsonSectionIds != null) {
                            int _sizeJsonArr_1 = this._jsonAdapter.sizeJsonArr((JsonArray)jsonSectionIds);
                            ExclusiveRange _doubleDotLessThan_1 = new ExclusiveRange(0, _sizeJsonArr_1, true);
                            for (Integer j : _doubleDotLessThan_1) {
                                multimap2.put((Object)elkSection, this._jsonAdapter.asId(this._jsonAdapter.getJsonArr((JsonArray)jsonSectionIds, j)));
                            }
                        }
                    };
                    ObjectExtensions.operator_doubleArrow((Object)_optJSONArray_2, (Procedures.Procedure1)_function_5);
                };
                ObjectExtensions.operator_doubleArrow((Object)_optJSONObject, (Procedures.Procedure1)_function_1);
            }
        }
    }
}

