/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.platform.internal.pde;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.pde.core.IEditableModel;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.build.Build;
import org.eclipse.pde.internal.core.build.BuildModel;

public class DirectoryBuildModel
extends BuildModel
implements IEditableModel {
    private static final long serialVersionUID = 1L;
    private File _file;

    public DirectoryBuildModel(File file) {
        this._file = file;
    }

    public String getContents() {
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        this.save(writer);
        writer.flush();
        try {
            swriter.close();
            writer.close();
        }
        catch (IOException e) {
            PDECore.logException((Throwable)e);
        }
        return swriter.toString();
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isEditable() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void load() {
        if (this._file.exists()) {
            FileInputStream stream = null;
            try {
                try {
                    stream = new FileInputStream(this._file);
                    this.load(stream, false);
                    return;
                }
                catch (Exception e) {
                    PDECore.logException((Throwable)e);
                    try {
                        if (stream == null) return;
                        ((InputStream)stream).close();
                        return;
                    }
                    catch (IOException e2) {
                        PDECore.logException((Throwable)e2);
                    }
                }
                return;
            }
            finally {
                try {
                    if (stream != null) {
                        ((InputStream)stream).close();
                    }
                }
                catch (IOException e) {
                    PDECore.logException((Throwable)e);
                }
            }
        }
        this.fBuild = new Build(){

            public IBuildModel getModel() {
                return DirectoryBuildModel.this;
            }
        };
        this.setLoaded(true);
    }

    public boolean isInSync() {
        return true;
    }

    protected void updateTimeStamp() {
    }

    public void save() {
    }

    public void save(PrintWriter writer) {
        this.getBuild().write("", writer);
    }

    public void setDirty(boolean dirty) {
    }

    public void setEditable(boolean editable) {
    }

    public String getInstallLocation() {
        return null;
    }
}

