/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.dialogs;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.egf.core.ui.EGFCoreUIPlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.dialogs.ITypeInfoFilterExtension;
import org.eclipse.jdt.ui.dialogs.ITypeInfoRequestor;
import org.eclipse.jdt.ui.dialogs.TypeSelectionExtension;

public class SubTypeSelectionExtension
extends TypeSelectionExtension {
    private IJavaProject _javaProject;
    private IType _type;
    private IType[] _subTypes;

    public SubTypeSelectionExtension(IType type) throws CoreException {
        try {
            this._javaProject = type.getJavaProject();
            this._type = type;
            this._subTypes = type.newTypeHierarchy(this._javaProject, (IProgressMonitor)new NullProgressMonitor()).getAllSubtypes(type);
        }
        catch (Throwable t) {
            throw new CoreException(EGFCoreUIPlugin.getDefault().newStatus(4, t.getMessage(), t));
        }
    }

    public ITypeInfoFilterExtension getFilterExtension() {
        return new ITypeInfoFilterExtension(){

            public boolean select(ITypeInfoRequestor typeInfoRequestor) {
                Object type = null;
                try {
                    type = SubTypeSelectionExtension.this._javaProject.findType(String.valueOf(typeInfoRequestor.getPackageName()) + "." + typeInfoRequestor.getTypeName());
                }
                catch (JavaModelException jme) {
                    EGFCoreUIPlugin.getDefault().logError(jme);
                }
                if (type == null) {
                    return false;
                }
                if (type.equals(SubTypeSelectionExtension.this._type)) {
                    return true;
                }
                if (SubTypeSelectionExtension.this._subTypes != null) {
                    IType[] iTypeArray = SubTypeSelectionExtension.this._subTypes;
                    int n = iTypeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IType subType = iTypeArray[n2];
                        if (subType.equals(type)) {
                            return true;
                        }
                        ++n2;
                    }
                }
                return false;
            }
        };
    }
}

