/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.internal.genmodel;

import org.eclipse.core.internal.registry.Handle;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.egf.core.genmodel.IPlatformGenModel;
import org.eclipse.egf.core.internal.genmodel.PlatformGenModel;
import org.eclipse.egf.core.platform.pde.IPlatformBundle;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPointFactory;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlatformGenModelFactory
implements IPlatformExtensionPointFactory<IPlatformGenModel> {
    public IPlatformGenModel createExtensionPoint(IPlatformBundle platformBundle, Object object) {
        if (object instanceof IPluginElement) {
            return this.create(platformBundle, (IPluginElement)object);
        }
        if (object instanceof IConfigurationElement) {
            return this.create(platformBundle, (IConfigurationElement)object);
        }
        throw new UnsupportedOperationException();
    }

    private IPlatformGenModel create(IPlatformBundle platformBundle, IPluginElement element) {
        if (element == null) {
            return null;
        }
        if (!"package".equals(element.getName())) {
            return null;
        }
        IPluginAttribute uri = element.getAttribute("uri");
        if (uri == null || uri.getValue() == null || uri.getValue().trim().length() == 0) {
            return null;
        }
        IPluginAttribute className = element.getAttribute("class");
        if (className == null || className.getValue() == null || className.getValue().trim().length() == 0) {
            return null;
        }
        IPluginAttribute genModel = element.getAttribute("genModel");
        return new PlatformGenModel(platformBundle, uri.getValue(), className.getValue(), genModel != null ? genModel.getValue() : null);
    }

    private IPlatformGenModel create(IPlatformBundle platformBundle, IConfigurationElement element) {
        if (element == null) {
            return null;
        }
        IExtension declaringExtension = element.getDeclaringExtension();
        String uniqueIdentifier = declaringExtension.getUniqueIdentifier();
        int handleId = -1;
        if (declaringExtension instanceof Handle) {
            handleId = ((Handle)declaringExtension).getId();
        }
        if (!"package".equals(element.getName())) {
            return null;
        }
        String uri = element.getAttribute("uri");
        if (uri == null || uri.trim().length() == 0) {
            return null;
        }
        String className = element.getAttribute("class");
        if (className == null || className.trim().length() == 0) {
            return null;
        }
        String genModel = element.getAttribute("genModel");
        return new PlatformGenModel(platformBundle, uri, uniqueIdentifier, handleId, className, genModel);
    }
}

