/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.editors;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.RelatedChangeAndCommitInfo;
import org.eclipse.egerrit.internal.ui.editors.ChangeDetailEditor;
import org.eclipse.egerrit.internal.ui.editors.QueryHelpers;
import org.eclipse.egerrit.internal.ui.editors.model.ChangeDetailEditorInput;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PlatformUI;

public class RefreshRelatedEditors
extends Job {
    private ChangeInfo fChangeInfo;
    private GerritClient fGerritClient;

    public RefreshRelatedEditors(ChangeInfo changeInfo, GerritClient gerritClient) {
        super(Messages.ChangeDetailEditor_updatingRelatedChanges);
        this.fChangeInfo = changeInfo;
        this.fGerritClient = gerritClient;
    }

    public IStatus run(IProgressMonitor monitor) {
        ArrayList<String> changeIds = new ArrayList<String>();
        for (RelatedChangeAndCommitInfo change : this.fChangeInfo.getRelatedChanges().getChanges()) {
            if (change.getChange_id() == null || change.getChange_id().equals(this.fChangeInfo.getChange_id())) continue;
            changeIds.add(change.getChange_id());
        }
        if (changeIds.size() == 0) {
            return Status.OK_STATUS;
        }
        IEditorReference[][] editorRefs = new IEditorReference[1][];
        Display.getDefault().syncExec(() -> {
            iEditorReferenceArray[0] = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        });
        IEditorReference[] iEditorReferenceArray = editorRefs[0];
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeDetailEditorInput changeInput;
            IEditorReference editorRef = iEditorReferenceArray[n2];
            IEditorPart part = editorRef.getEditor(false);
            if (part instanceof ChangeDetailEditor && !(changeInput = (ChangeDetailEditorInput)part.getEditorInput()).getChange().getChange_id().equals(this.fChangeInfo.getChange_id()) && changeIds.contains(changeInput.getChange().getChange_id())) {
                QueryHelpers.loadBasicInformation(this.fGerritClient, changeInput.getChange(), true);
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }
}

