/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.table;

import org.eclipse.egerrit.internal.ui.table.model.HistoryTableModel;
import org.eclipse.egerrit.internal.ui.table.model.HistoryTableSorter;
import org.eclipse.egerrit.internal.ui.table.model.ITableModel;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class UIHistoryTable {
    public static final String HISTORY_TABLE = "historyTable";
    private final int TABLE_STYLE = 66304;
    private TableViewer fViewer;

    public TableViewer createTableViewerSection(Composite aParent) {
        this.fViewer = new TableViewer(aParent, 66304);
        this.fViewer = this.buildAndLayoutTable(this.fViewer);
        HistoryTableSorter.bind(this.fViewer);
        this.fViewer.setComparator((ViewerComparator)new HistoryTableSorter(1));
        this.fViewer.getTable().addListener(9, this.initPaintListener());
        return this.fViewer;
    }

    private Listener initPaintListener() {
        Listener paint = new Listener(){

            public void handleEvent(Event event) {
                if (UIHistoryTable.this.fViewer.getTable().getItemCount() > 0) {
                    UIHistoryTable.this.fViewer.getTable().select(0);
                    UIHistoryTable.this.fViewer.setSelection(UIHistoryTable.this.fViewer.getSelection());
                    UIHistoryTable.this.resizeTable(UIHistoryTable.this.fViewer.getTable());
                    UIHistoryTable.this.fViewer.getTable().removeListener(9, (Listener)this);
                }
            }
        };
        return paint;
    }

    private void resizeTable(Table table) {
        int index = 1;
        while (index < table.getColumnCount()) {
            TableColumn tc = table.getColumn(index);
            tc.pack();
            ++index;
        }
    }

    private TableViewer buildAndLayoutTable(TableViewer aViewer) {
        Table table = aViewer.getTable();
        HistoryTableModel[] tableInfo = HistoryTableModel.values();
        int size = tableInfo.length;
        int index = 0;
        while (index < size) {
            this.createTableViewerColumn(tableInfo[index]);
            ++index;
        }
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setData((Object)HISTORY_TABLE);
        return aViewer;
    }

    private TableViewerColumn createTableViewerColumn(ITableModel tableInfo) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.fViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(tableInfo.getName());
        column.setWidth(tableInfo.getWidth());
        column.setAlignment(tableInfo.getAlignment());
        column.setResizable(tableInfo.getResize());
        column.setMoveable(tableInfo.getMoveable());
        return viewerColumn;
    }

    public TableViewer getViewer() {
        return this.fViewer;
    }
}

