/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.table.provider;

import java.util.Set;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.egerrit.internal.model.FileInfo;
import org.eclipse.egerrit.internal.ui.EGerritImages;
import org.eclipse.egerrit.internal.ui.compare.GerritDiffNode;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;

public class FileInfoCompareCellLabelProvider
extends CellLabelProvider {
    final String EMPTY_STRING = "";
    private static final String NEW = Messages.FileInfoCompareCellLabelProvider_0;
    private static final String COMMENTS = Messages.FileInfoCompareCellLabelProvider_1;
    private static final String DRAFTS = Messages.FileInfoCompareCellLabelProvider_2;
    public static final String CHECKED_IMAGE = "greenCheck.png";
    private boolean nameFirst = true;
    private IMapChangeListener mapChangeListener = new IMapChangeListener(){

        public void handleMapChange(MapChangeEvent event) {
            Set affectedElements = event.diff.getChangedKeys();
            if (!affectedElements.isEmpty()) {
                LabelProviderChangedEvent newEvent = new LabelProviderChangedEvent((IBaseLabelProvider)FileInfoCompareCellLabelProvider.this, affectedElements.toArray());
                FileInfoCompareCellLabelProvider.this.fireLabelProviderChanged(newEvent);
            }
        }
    };

    public FileInfoCompareCellLabelProvider(IObservableMap ... attributeMaps) {
        IObservableMap[] iObservableMapArray = attributeMaps;
        int n = attributeMaps.length;
        int n2 = 0;
        while (n2 < n) {
            IObservableMap attributeMap = iObservableMapArray[n2];
            attributeMap.addMapChangeListener(this.mapChangeListener);
            ++n2;
        }
    }

    public String getLabel(Object element, int columnIdx) {
        GerritDiffNode gerrritNode = (GerritDiffNode)((Object)element);
        FileInfo fileInfo = gerrritNode.getFileInfo();
        switch (columnIdx) {
            case 0: {
                if (fileInfo.isReviewed()) {
                    return "1";
                }
                return "";
            }
            case 1: {
                return fileInfo.getStatus();
            }
            case 2: {
                String path = null;
                if (this.nameFirst) {
                    path = fileInfo.getPath();
                    int index = path.lastIndexOf("/");
                    if (index != -1) {
                        String firstName;
                        String fileName = path.substring(index + 1);
                        path = firstName = String.valueOf(fileName) + " - " + path.substring(0, index);
                    }
                } else {
                    path = fileInfo.getPath();
                }
                if (fileInfo.getOld_path() != null) {
                    path = String.valueOf(path) + Messages.FileTableLabelProvider_3 + fileInfo.getOld_path() + Messages.FileTableLabelProvider_4;
                }
                return path;
            }
            case 3: {
                String commentString = "";
                int commentsCount = fileInfo.getCommentsCount();
                int draftsCount = fileInfo.getDraftsCount();
                if (draftsCount != 0) {
                    commentString = String.valueOf(commentString) + DRAFTS + draftsCount;
                    if (commentsCount != 0) {
                        commentString = String.valueOf(commentString) + " ";
                    }
                } else {
                    commentString = "                     ";
                }
                if (commentsCount != 0) {
                    commentString = String.valueOf(commentString) + COMMENTS + commentsCount;
                }
                return commentString;
            }
            case 4: {
                StringBuilder modifySize = new StringBuilder();
                modifySize.append('+');
                modifySize.append(Integer.toString(fileInfo.getLines_inserted()));
                modifySize.append('/');
                modifySize.append('-');
                modifySize.append(Integer.toString(fileInfo.getLines_deleted()));
                return modifySize.toString();
            }
        }
        return "";
    }

    public void update(ViewerCell cell) {
        Object obj;
        if (cell != null && (obj = cell.getElement()) instanceof GerritDiffNode) {
            cell.setText(this.getLabel(obj, cell.getColumnIndex()));
            if (cell.getColumnIndex() == 0) {
                GerritDiffNode gerrritNode = (GerritDiffNode)((Object)obj);
                FileInfo fileInfo = gerrritNode.getFileInfo();
                Image image = this.getReviewedStateImage(fileInfo.isReviewed());
                cell.setImage(image);
            }
        }
    }

    private Image getReviewedStateImage(boolean aState) {
        if (aState) {
            return EGerritImages.get("icons/greenCheck.png");
        }
        return null;
    }

    public void setFileNameFirst(boolean b) {
        this.nameFirst = b;
    }

    public boolean getFileOrder() {
        return this.nameFirst;
    }
}

