/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.table.model;

import org.eclipse.egerrit.internal.ui.table.provider.FileInfoCompareCellLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class ReviewTableSorter
extends ViewerComparator {
    private int fColumnIndex = 0;

    public ReviewTableSorter(int columnIndex) {
        this.fColumnIndex = columnIndex;
    }

    public int compare(Viewer viewer, Object item1, Object item2) {
        int sortDirection = 0;
        if (viewer instanceof TableViewer) {
            sortDirection = ((TableViewer)viewer).getTable().getSortDirection();
        } else if (viewer instanceof TreeViewer) {
            sortDirection = ((TreeViewer)viewer).getTree().getSortDirection();
        }
        int result = 0;
        if (viewer instanceof TableViewer) {
            String l1 = ((ITableLabelProvider)((TableViewer)viewer).getLabelProvider()).getColumnText(item1, this.fColumnIndex);
            String l2 = ((ITableLabelProvider)((TableViewer)viewer).getLabelProvider()).getColumnText(item2, this.fColumnIndex);
            result = this.getComparator().compare(l1, l2);
        } else {
            result = this.defaultCompare(viewer, item1, item2);
        }
        return sortDirection == 128 ? -result : result;
    }

    private int defaultCompare(Viewer aViewer, Object aE1, Object aE2) {
        if (aViewer instanceof TreeViewer) {
            TreeViewer tv = (TreeViewer)aViewer;
            FileInfoCompareCellLabelProvider provider = (FileInfoCompareCellLabelProvider)tv.getLabelProvider(this.fColumnIndex);
            return this.getComparator().compare(provider.getLabel(aE1, this.fColumnIndex), provider.getLabel(aE2, this.fColumnIndex));
        }
        return 0;
    }

    public static void bind(final TableViewer aTableViewer) {
        int i = 0;
        while (i < aTableViewer.getTable().getColumnCount()) {
            final int columnNum = i;
            TableColumn column = aTableViewer.getTable().getColumn(i);
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ReviewTableSorter sorter = new ReviewTableSorter(columnNum);
                    Table table = aTableViewer.getTable();
                    TableColumn currentColumn = (TableColumn)e.widget;
                    table.setSortColumn(currentColumn);
                    table.setSortDirection(table.getSortDirection() == 128 ? 1024 : 128);
                    aTableViewer.setComparator((ViewerComparator)sorter);
                }
            });
            ++i;
        }
    }

    public static void bind(final TreeViewer aTreeViewer) {
        int i = 0;
        while (i < aTreeViewer.getTree().getColumnCount()) {
            final int columnNum = i;
            TreeColumn column = aTreeViewer.getTree().getColumn(i);
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ReviewTableSorter sorter = new ReviewTableSorter(columnNum);
                    Tree table = aTreeViewer.getTree();
                    TreeColumn currentColumn = (TreeColumn)e.widget;
                    table.setSortColumn(currentColumn);
                    table.setSortDirection(table.getSortDirection() == 128 ? 1024 : 128);
                    aTreeViewer.setComparator((ViewerComparator)sorter);
                }
            });
            ++i;
        }
    }
}

