/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.dashboard.ui.menus;

import java.util.HashMap;
import java.util.List;
import org.eclipse.egerrit.internal.core.GerritServerInformation;
import org.eclipse.egerrit.internal.core.ServersStore;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class DynamicMenuAddition
extends CompoundContributionItem
implements IWorkbenchContribution {
    private IServiceLocator fServiceLocator;

    protected IContributionItem[] getContributionItems() {
        List servers = ServersStore.getAllServers();
        if (servers == null || servers.isEmpty()) {
            return new CommandContributionItem[0];
        }
        CommandContributionItem[] contributionItems = new CommandContributionItem[servers.size()];
        int count = 0;
        for (GerritServerInformation server : servers) {
            CommandContributionItemParameter menuEntry = new CommandContributionItemParameter(this.fServiceLocator, server.getName(), "org.eclipse.egerrit.dashboard.ui.selectCurrentGerrit", 32);
            menuEntry.label = !server.getName().isEmpty() ? server.getName() : server.getServerURI();
            menuEntry.visibleEnabled = true;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("org.eclipse.egerrit.dashboard.ui.selectCurrentGerrit.serverId", Integer.toString(server.hashCode()));
            menuEntry.parameters = params;
            contributionItems[count++] = new CommandContributionItem(menuEntry);
        }
        return contributionItems;
    }

    public void initialize(IServiceLocator aServiceLocator) {
        this.fServiceLocator = aServiceLocator;
    }
}

