/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.table;

import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.FileInfo;
import org.eclipse.egerrit.internal.model.ModelPackage;
import org.eclipse.egerrit.internal.model.impl.StringToFileInfoImpl;
import org.eclipse.egerrit.internal.ui.editors.ModelLoader;
import org.eclipse.egerrit.internal.ui.editors.OpenCompareEditor;
import org.eclipse.egerrit.internal.ui.editors.QueryHelpers;
import org.eclipse.egerrit.internal.ui.table.model.FilesTableModel;
import org.eclipse.egerrit.internal.ui.table.model.ITableModel;
import org.eclipse.egerrit.internal.ui.table.model.ReviewTableSorter;
import org.eclipse.egerrit.internal.ui.table.provider.FileTableLabelProvider;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.egerrit.internal.ui.utils.UIUtils;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class UIFilesTable {
    private final int TABLE_STYLE = 66304;
    private TableViewer fViewer;
    private IDoubleClickListener fdoubleClickListener;
    private GerritClient fGerritClient;
    private ChangeInfo fChangeInfo;
    private ModelLoader loader;

    public UIFilesTable(GerritClient gerritClient, ChangeInfo changeInfo) {
        this.fGerritClient = gerritClient;
        this.fChangeInfo = changeInfo;
        this.loader = ModelLoader.initialize(gerritClient, changeInfo);
        this.loader.loadCurrentRevision();
    }

    public TableViewer createTableViewerSection(Composite aParent) {
        this.fViewer = new TableViewer(aParent, 66304);
        this.buildAndLayoutTable();
        this.adjustTableData();
        ReviewTableSorter.bind(this.fViewer);
        this.fViewer.setComparator((ViewerComparator)new ReviewTableSorter(2));
        return this.fViewer;
    }

    private void buildAndLayoutTable() {
        Table table = this.fViewer.getTable();
        FilesTableModel[] tableInfo = FilesTableModel.values();
        int size = tableInfo.length;
        int index = 0;
        while (index < size) {
            this.createTableViewerColumn(tableInfo[index]);
            ++index;
        }
        GridData gribData = new GridData(4, 4, true, true);
        gribData.minimumWidth = tableInfo[0].getWidth();
        this.fViewer.getTable().setLayoutData((Object)gribData);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.addPulldownMenu();
    }

    private TableViewerColumn createTableViewerColumn(ITableModel tableInfo) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.fViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(tableInfo.getName());
        column.setWidth(tableInfo.getWidth());
        column.setAlignment(tableInfo.getAlignment());
        column.setResizable(tableInfo.getResize());
        column.setMoveable(tableInfo.getMoveable());
        return viewerColumn;
    }

    public TableViewer getViewer() {
        return this.fViewer;
    }

    private void adjustTableData() {
        this.fViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 10, 1));
        this.fdoubleClickListener = new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                Object element = sel.getFirstElement();
                if (element instanceof StringToFileInfoImpl) {
                    FileInfo selectedFile = ((StringToFileInfoImpl)element).getValue();
                    if (!UIFilesTable.this.fGerritClient.getRepository().getServerInfo().isAnonymous()) {
                        UIFilesTable.this.showEditorTip();
                    }
                    OpenCompareEditor compareEditor = new OpenCompareEditor(UIFilesTable.this.fGerritClient, UIFilesTable.this.fChangeInfo);
                    String left = "BASE";
                    String right = UIFilesTable.this.fChangeInfo.getUserSelectedRevision().getId();
                    compareEditor.compareFiles(left, right, selectedFile);
                }
            }
        };
        this.fViewer.addDoubleClickListener(this.fdoubleClickListener);
        if (!this.fGerritClient.getRepository().getServerInfo().isAnonymous()) {
            this.fViewer.getTable().addMouseListener((MouseListener)this.toggleReviewedStateListener());
        }
        this.filesTabDataBindings();
    }

    public void selectRow() {
        if (this.fViewer.getElementAt(0) != null) {
            this.fViewer.setSelection((ISelection)new StructuredSelection(this.fViewer.getElementAt(0)), true);
            IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
            DoubleClickEvent event = new DoubleClickEvent((Viewer)this.fViewer, (ISelection)selection);
            this.fdoubleClickListener.doubleClick(event);
        }
    }

    private MouseAdapter toggleReviewedStateListener() {
        return new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ISelection selection;
                ViewerCell viewerCell = UIFilesTable.this.fViewer.getCell(new Point(e.x, e.y));
                if (viewerCell != null && viewerCell.getColumnIndex() == 0 && (selection = UIFilesTable.this.fViewer.getSelection()) instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    Object element = structuredSelection.getFirstElement();
                    FileInfo fileInfo = ((StringToFileInfoImpl)element).getValue();
                    UIFilesTable.this.toggleReviewed(fileInfo);
                }
            }
        };
    }

    private void toggleReviewed(FileInfo fileInfo) {
        if (fileInfo.isReviewed()) {
            QueryHelpers.markAsNotReviewed(this.fGerritClient, fileInfo);
        } else {
            QueryHelpers.markAsReviewed(this.fGerritClient, fileInfo);
        }
        this.fViewer.refresh();
    }

    protected void filesTabDataBindings() {
        if (this.fViewer != null) {
            FeaturePath changerev = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ModelPackage.Literals.CHANGE_INFO__USER_SELECTED_REVISION, ModelPackage.Literals.REVISION_INFO__FILES});
            IObservableList revisionsChanges = EMFProperties.list((FeaturePath)changerev).observe((Object)this.fChangeInfo);
            FeaturePath reviewed = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ModelPackage.Literals.STRING_TO_FILE_INFO__VALUE, ModelPackage.Literals.FILE_INFO__REVIEWED});
            FeaturePath commentsCount = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ModelPackage.Literals.STRING_TO_FILE_INFO__VALUE, ModelPackage.Literals.FILE_INFO__COMMENTS_COUNT});
            FeaturePath draftCount = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ModelPackage.Literals.STRING_TO_FILE_INFO__VALUE, ModelPackage.Literals.FILE_INFO__DRAFTS_COUNT});
            ObservableListContentProvider contentProvider = new ObservableListContentProvider();
            this.fViewer.setContentProvider((IContentProvider)contentProvider);
            IObservableMap[] watchedProperties = Properties.observeEach((IObservableSet)contentProvider.getKnownElements(), (IValueProperty[])new IValueProperty[]{EMFProperties.value((FeaturePath)reviewed), EMFProperties.value((FeaturePath)commentsCount), EMFProperties.value((FeaturePath)draftCount)});
            this.fViewer.setLabelProvider((IBaseLabelProvider)new FileTableLabelProvider(watchedProperties));
            this.fViewer.setInput((Object)revisionsChanges);
        }
    }

    private void showEditorTip() {
        IEclipsePreferences prefs = ConfigurationScope.INSTANCE.getNode("org.eclipse.egerrit.prefs");
        Preferences editorPrefs = prefs.node("editor");
        boolean choice = editorPrefs.getBoolean("editortip", false);
        if (choice) {
            return;
        }
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openInformation((Shell)this.fViewer.getControl().getShell(), (String)Messages.FileTabView_EGerriTip, (String)Messages.FileTabView_EGerriTipValue, (String)Messages.FileTabView_EGerriTipShowAgain, (boolean)false, null, null);
        if (dialog.getToggleState()) {
            editorPrefs.putBoolean("editortip", true);
            try {
                editorPrefs.flush();
            }
            catch (BackingStoreException backingStoreException) {}
        }
    }

    private void addPulldownMenu() {
        MenuManager menuManager = new MenuManager();
        final Menu menu = menuManager.createContextMenu((Control)this.fViewer.getTable());
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                UIFilesTable.this.addMenuItem(menu);
            }
        });
        this.fViewer.getTable().setMenu(menu);
        menuManager.update(true);
    }

    private void addMenuItem(Menu menu) {
        if (menu.getItemCount() == 0) {
            MenuItem openFile = new MenuItem(menu, 8);
            openFile.setText(Messages.UIFilesTable_0);
            final FileTableLabelProvider labelProvider = (FileTableLabelProvider)this.fViewer.getLabelProvider();
            openFile.setSelection(labelProvider.getFileOrder());
            openFile.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ISelection selection = UIFilesTable.this.fViewer.getSelection();
                    if (selection instanceof IStructuredSelection) {
                        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                        Object element = structuredSelection.getFirstElement();
                        if (element == null) {
                            return;
                        }
                        FileInfo fileInfo = ((StringToFileInfoImpl)element).getValue();
                        UIUtils.openSingleFile(((StringToFileInfoImpl)element).getKey(), UIFilesTable.this.fGerritClient, fileInfo.getRevision(), 0);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            MenuItem nameFirst = new MenuItem(menu, 32);
            nameFirst.setText(Messages.UIFilesTable_1);
            nameFirst.setSelection(labelProvider.getFileOrder());
            nameFirst.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    MenuItem menuItem = (MenuItem)e.getSource();
                    labelProvider.setFileNameFirst(menuItem.getSelection());
                    UIFilesTable.this.fViewer.refresh();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.addVisibleColumnSelection(menu);
        }
    }

    private void addVisibleColumnSelection(Menu menu) {
        FilesTableModel[] tableInfo;
        new MenuItem(menu, 2);
        MenuItem visible = new MenuItem(menu, 64);
        visible.setText("Visible column");
        FilesTableModel[] filesTableModelArray = tableInfo = FilesTableModel.values();
        int n = tableInfo.length;
        int n2 = 0;
        while (n2 < n) {
            FilesTableModel element = filesTableModelArray[n2];
            MenuItem menuItem = new MenuItem(menu, 32);
            if (element.getName().isEmpty()) {
                menuItem.setText("Column: " + element.ordinal());
            } else {
                menuItem.setText(element.getName());
            }
            menuItem.setData((Object)element);
            menuItem.setSelection(element.isColumnVisible());
            menuItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    MenuItem subMenuItem = (MenuItem)e.getSource();
                    FilesTableModel tablemodel = (FilesTableModel)subMenuItem.getData();
                    tablemodel.setColumnVisible(subMenuItem.getSelection());
                    UIFilesTable.this.fViewer.getTable().getColumn(tablemodel.ordinal()).setWidth(tablemodel.getWidth());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            ++n2;
        }
    }

    public void dispose() {
        this.loader.dispose();
    }
}

