/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.fxml.wizards;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.fx.ide.fxml.wizards.FXMLWizardPage;
import org.eclipse.fx.ide.fxml.wizards.template.FXMLElement;
import org.eclipse.fx.ide.fxml.wizards.template.FXMLTemplate;
import org.eclipse.fx.ide.ui.wizards.AbstractNewJDTElementWizard;
import org.eclipse.fx.ide.ui.wizards.template.IGenerator;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;

public class NewFXMLWizard
extends AbstractNewJDTElementWizard<FXMLElement> {
    private static final String SETTINGS_FILE = "new-fxml-settings.xml";
    static final String KEY_LAST_SELECTIONS = "KEY_LAST_SELECTIONS";
    private static final int MAX_HISTORY_SIZE = 20;

    public NewFXMLWizard() {
        if (this.getDialogSettings() == null) {
            DialogSettings settings = new DialogSettings("new-fxml");
            try {
                settings.load(SETTINGS_FILE);
            }
            catch (IOException iOException) {}
            this.setDialogSettings((IDialogSettings)settings);
        }
    }

    protected IGenerator<FXMLElement> getGenerator() {
        return new FXMLTemplate();
    }

    public void addPages() {
        this.addPage((IWizardPage)new FXMLWizardPage(this.getInitialRoot(), this.getInitialFragment(), ResourcesPlugin.getWorkspace().getRoot()));
    }

    public boolean performFinish() {
        boolean finish = super.performFinish();
        if (finish && this.getDialogSettings() != null) {
            IFile propFile = this.getPropertiesFile();
            if (!propFile.exists()) {
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("tpl_fxml-preview.properties");){
                        if (in != null) {
                            try {
                                propFile.create(in, true, null);
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            IDialogSettings settings = this.getDialogSettings();
            String typeName = ((FXMLElement)this.getDomainClass()).getRootElement().getFullyQualifiedName();
            String[] elements = settings.getArray(KEY_LAST_SELECTIONS);
            if (elements == null) {
                settings.put(KEY_LAST_SELECTIONS, new String[]{typeName});
            } else {
                ArrayList<String> ar = new ArrayList<String>(Arrays.asList(elements));
                ar.remove(typeName);
                ar.add(0, typeName);
                if (ar.size() > 20) {
                    while (ar.size() > 20) {
                        ar.remove(20);
                    }
                }
                settings.put(KEY_LAST_SELECTIONS, ar.toArray(new String[0]));
            }
            try {
                settings.save(SETTINGS_FILE);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return finish;
    }

    protected IFile createFile() {
        if (this.getFragment() != null) {
            String fxgraph = String.valueOf(((FXMLElement)this.getDomainClass()).getName()) + ".fxml";
            IFolder p = (IFolder)this.getFragment().getResource();
            IFile resource = p.getFile(fxgraph);
            return resource;
        }
        String fxgraph = String.valueOf(((FXMLElement)this.getDomainClass()).getName()) + ".fxml";
        IFolder p = (IFolder)((FXMLElement)this.getDomainClass()).getFragmentRoot().getResource();
        return p.getFile(fxgraph);
    }

    private IFile getPropertiesFile() {
        IProject p = (IProject)((FXMLElement)this.getDomainClass()).getFragmentRoot().getJavaProject().getResource();
        return p.getFile("fxml-preview.properties");
    }
}

