/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.filesystem.skin;

import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.stream.Collectors;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.eclipse.fx.core.FilesystemService;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.core.Util;
import org.eclipse.fx.ui.controls.filesystem.DirItem;
import org.eclipse.fx.ui.controls.filesystem.FileItem;
import org.eclipse.fx.ui.controls.filesystem.ResourceItem;
import org.eclipse.fx.ui.controls.filesystem.RootDirItem;
import org.eclipse.jdt.annotation.NonNull;

public abstract class PathItemImpl
implements ResourceItem {
    public final Path path;
    private ReadOnlyObjectWrapper<@NonNull LocalDateTime> lastModified;

    PathItemImpl(Path path) {
        this.path = path;
    }

    @Override
    public String getName() {
        return this.path.getFileName().toString();
    }

    @Override
    public Path getNativeResourceObject() {
        return this.path;
    }

    @Override
    public String getUri() {
        try {
            return this.path.toUri().toURL().toExternalForm();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ReadOnlyObjectProperty<@NonNull LocalDateTime> lastModifiedProperty() {
        if (this.lastModified == null) {
            try {
                FileTime t = Files.getLastModifiedTime(this.path, new LinkOption[0]);
                this.lastModified = new ReadOnlyObjectWrapper((Object)this, "lastModified", (Object)LocalDateTime.ofInstant(t.toInstant(), ZoneId.systemDefault()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.lastModified.getReadOnlyProperty();
    }

    @Override
    public void refresh() {
    }

    public static @NonNull RootDirItem createObservedPath(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            return new RootPathItemImpl(path, true);
        }
        throw new IllegalArgumentException("Given path '" + path + "' is not a directory");
    }

    public static @NonNull RootDirItem createPath(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            return new RootPathItemImpl(path, false);
        }
        throw new IllegalArgumentException("Given path '" + path + "' is not a directory");
    }

    static class DirPathItemImpl
    extends PathItemImpl
    implements DirItem {
        private ObservableList<@NonNull ResourceItem> children;
        private final boolean observe;
        private Subscription fsSubscription;

        DirPathItemImpl(Path path, boolean observe) {
            super(path);
            this.observe = observe;
        }

        @Override
        public ObservableList<@NonNull ResourceItem> getChildren() {
            if (this.children == null) {
                FilesystemService service;
                this.children = FXCollections.observableArrayList();
                try {
                    this.children.addAll((Collection)Files.walk(this.path, 1, new FileVisitOption[0]).filter(p -> p != this.path).map(p -> Files.isDirectory(p, new LinkOption[0]) ? new DirPathItemImpl((Path)p, this.observe) : new FileItemImpl((Path)p)).collect(Collectors.toList()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (this.observe && (service = (FilesystemService)Util.lookupService(FilesystemService.class)) != null) {
                    this.fsSubscription = service.observePath(this.path, this::handlePathModification);
                }
            }
            return this.children;
        }

        private void handlePathModification(FilesystemService.Kind k, Path p) {
            switch (k) {
                case CREATE: {
                    if (this.children.stream().filter(i -> i.getNativeResourceObject().equals(p)).findFirst().isPresent()) break;
                    this.children.add((Object)(Files.isDirectory(p, new LinkOption[0]) ? new DirPathItemImpl(p, this.observe) : new FileItemImpl(p)));
                    break;
                }
                case DELETE: {
                    this.children.removeIf(i -> i.getNativeResourceObject().equals(p));
                    break;
                }
                case MODIFY: {
                    this.children.stream().filter(i -> i.getNativeResourceObject().equals(p)).findFirst().ifPresent(i -> i.refresh());
                    break;
                }
            }
        }

        void dispose() {
            if (this.fsSubscription != null) {
                this.fsSubscription.dispose();
                if (this.children != null) {
                    this.children.filtered(i -> i instanceof DirPathItemImpl).forEach(i -> ((DirPathItemImpl)i).dispose());
                }
            }
        }
    }

    static class FileItemImpl
    extends PathItemImpl
    implements FileItem {
        private ReadOnlyObjectWrapper<Long> fileSize;
        private static NumberFormat BYTE_FORMAT = new DecimalFormat("#,##0 'Bytes'");
        private static NumberFormat KB_FORMAT = new DecimalFormat("#,##0 'KB'");
        private static NumberFormat MB_FORMAT = new DecimalFormat("#,##0.0 'MB'");

        FileItemImpl(Path path) {
            super(path);
        }

        @Override
        public String getFormattedSize() {
            if ((Long)this.fileSizeProperty().get() >= 1000000L) {
                return MB_FORMAT.format((double)((Long)this.fileSizeProperty().get()).longValue() / 1048576.0);
            }
            if ((Long)this.fileSizeProperty().get() >= 1000L) {
                return KB_FORMAT.format((double)((Long)this.fileSizeProperty().get()).longValue() / 1000.0);
            }
            return BYTE_FORMAT.format((Long)this.fileSizeProperty().get());
        }

        @Override
        public ReadOnlyObjectProperty<Long> fileSizeProperty() {
            if (this.fileSize == null) {
                try {
                    this.fileSize = new ReadOnlyObjectWrapper((Object)this, "fileSize", (Object)Files.size(this.path));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return this.fileSize.getReadOnlyProperty();
        }
    }

    static class RootPathItemImpl
    extends DirPathItemImpl
    implements RootDirItem {
        RootPathItemImpl(Path path, boolean observe) {
            super(path, observe);
        }

        @Override
        public void dispose() {
            super.dispose();
        }
    }
}

