/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.css.cssext.ui.adapter;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.ide.css.cssext.CssExtDslStandaloneSetupGenerated;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CssExtension;
import org.eclipse.fx.osgi.util.LoggerCreator;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.linking.impl.XtextLinkingDiagnostic;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.scoping.impl.AbstractGlobalScopeDelegatingScopeProvider;
import org.eclipse.xtext.scoping.impl.IDelegatingScopeProvider;
import org.eclipse.xtext.scoping.impl.IScopeWrapper;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xtext.XtextLinker;

public class ExtensionRegistry {
    public static final ExtensionRegistry REGISTRY = new ExtensionRegistry();
    private Map<URI, ExtensionHolder> extensions = new HashMap<URI, ExtensionHolder>();
    private Logger logger;
    private IElementChangedListener listener = new IElementChangedListener(){

        public void elementChanged(ElementChangedEvent event) {
            ArrayList changedExtensions = new ArrayList();
            ExtensionRegistry.this.recCheckChangedExtensions(event.getDelta(), changedExtensions);
            for (URI changedEx : changedExtensions) {
                ExtensionRegistry.this.invalidateExtension(changedEx);
            }
        }
    };

    private void recCheckChangedExtensions(IJavaElementDelta d, List<URI> changedExtensions) {
        int n;
        int n2;
        IResourceDelta[] iResourceDeltaArray;
        if (1 == (1 & d.getFlags())) {
            iResourceDeltaArray = d.getResourceDeltas();
            n2 = iResourceDeltaArray.length;
            n = 0;
            while (n < n2) {
                IResourceDelta rd = iResourceDeltaArray[n];
                IResource res = rd.getResource();
                if ("cssext".equals(res.getFileExtension())) {
                    changedExtensions.add(URI.createPlatformResourceURI((String)(String.valueOf(res.getProject().getName()) + "/" + res.getProjectRelativePath().toString()), (boolean)true));
                }
                ++n;
            }
        }
        if (8 == (8 & d.getFlags())) {
            iResourceDeltaArray = d.getChangedChildren();
            n2 = iResourceDeltaArray.length;
            n = 0;
            while (n < n2) {
                IResourceDelta child = iResourceDeltaArray[n];
                this.recCheckChangedExtensions((IJavaElementDelta)child, changedExtensions);
                ++n;
            }
        }
    }

    private ExtensionRegistry() {
        JavaCore.addElementChangedListener((IElementChangedListener)this.listener, (int)1);
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = LoggerCreator.createLogger(ExtensionRegistry.class);
        }
        return this.logger;
    }

    public ExtensionHolder getExtension(URI uri) {
        this.getLogger().debug("getExtension(" + uri + ")");
        ExtensionHolder holder = this.extensions.get(uri);
        if (holder == null) {
            this.getLogger().debug(" => creating new holder");
            holder = new ExtensionHolder(uri);
            this.extensions.put(uri, holder);
        } else {
            this.getLogger().debug(" => result from cache");
        }
        return holder;
    }

    public void invalidateExtension(URI uri) {
        this.getLogger().debug("invalidateExtension(" + uri + ")");
        ExtensionHolder holder = this.extensions.get(uri);
        if (holder != null) {
            this.getLogger().debug(" invalididating " + uri);
            holder.invalidate();
        } else {
            this.getLogger().debug(" not found!");
        }
    }

    public static class Dummy {
        @Inject
        XtextLinker linker;
    }

    public static class ExtensionHolder {
        public final URI uri;
        private CssExtension model;
        private static ResourceSet rs;
        private static IResourceDescription.Manager manager;
        private static IResourceDescriptions x;
        Dummy dummy;
        public static Set<CssExtension> exts;
        final IScopeWrapper wrap = new IScopeWrapper(){

            public IScope wrap(final IScope scope) {
                return new IScope(){

                    public IEObjectDescription getSingleElement(EObject object) {
                        System.err.println("WRAPPING FUN getSingleElement " + object);
                        return scope.getSingleElement(object);
                    }

                    public IEObjectDescription getSingleElement(QualifiedName name) {
                        System.err.println("WRAPPING FUN getSingleElement " + name);
                        return scope.getSingleElement(name);
                    }

                    public Iterable<IEObjectDescription> getElements(EObject object) {
                        return scope.getElements(object);
                    }

                    public Iterable<IEObjectDescription> getElements(QualifiedName name) {
                        return scope.getElements(name);
                    }

                    public Iterable<IEObjectDescription> getAllElements() {
                        return scope.getAllElements();
                    }
                };
            }
        };

        static {
            exts = new HashSet<CssExtension>();
        }

        public static Dummy create() {
            Injector injector = new CssExtDslStandaloneSetupGenerated().createInjector();
            return (Dummy)injector.getInstance(Dummy.class);
        }

        protected ExtensionHolder(URI uri) {
            this.uri = uri;
            this.dummy = ExtensionHolder.create();
        }

        public CssExtension getModel() {
            return this.loadModel();
        }

        private void register(IScopeProvider scopeProvider, IScopeWrapper wrap) {
            if (scopeProvider instanceof AbstractGlobalScopeDelegatingScopeProvider) {
                AbstractGlobalScopeDelegatingScopeProvider provider = (AbstractGlobalScopeDelegatingScopeProvider)scopeProvider;
                provider.setWrapper(wrap);
                System.err.println("REGISTERED WRAPPER on " + scopeProvider);
            } else if (scopeProvider instanceof IDelegatingScopeProvider) {
                IDelegatingScopeProvider cfr_ignored_0 = (IDelegatingScopeProvider)scopeProvider;
                this.register(((IDelegatingScopeProvider)scopeProvider).getDelegate(), wrap);
            }
        }

        private void logScope(IScopeProvider scopeProvider) {
            System.err.println(" * " + scopeProvider);
            if (scopeProvider instanceof IDelegatingScopeProvider) {
                IDelegatingScopeProvider cfr_ignored_0 = (IDelegatingScopeProvider)scopeProvider;
                this.logScope(((IDelegatingScopeProvider)scopeProvider).getDelegate());
            }
        }

        private void load(URI uri) {
            System.err.println("LOADING " + uri);
            rs.getResource(uri, true);
            System.err.println("(re)linking all");
            for (Resource r : rs.getResources()) {
                System.err.println(" * " + r);
                EcoreUtil2.resolveLazyCrossReferences((Resource)r, (CancelIndicator)CancelIndicator.NullImpl);
                for (Resource.Diagnostic d : r.getErrors()) {
                    if (!(d instanceof XtextLinkingDiagnostic)) continue;
                    XtextLinkingDiagnostic x = (XtextLinkingDiagnostic)d;
                    System.err.println("  x " + x.getMessage());
                }
            }
        }

        private CssExtension loadModel() {
            LazyLinkingResource resource;
            System.err.println("LOADING " + this.uri);
            if (rs == null) {
                IResourceServiceProvider rsp = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(this.uri);
                IResourceSetProvider rp = (IResourceSetProvider)rsp.get(IResourceSetProvider.class);
                rs = rp.get(ResourcesPlugin.getWorkspace().getRoot().getProject("javap"));
                manager = rsp.getResourceDescriptionManager();
            }
            if ((resource = (LazyLinkingResource)rs.getResource(this.uri, true)).getContents().isEmpty()) {
                System.err.println("COULD NOT LOAD " + this.uri);
                return null;
            }
            CssExtension ext = (CssExtension)resource.getContents().get(0);
            exts.add(ext);
            System.err.println("(re)linking");
            for (Resource r : rs.getResources()) {
                System.err.println(" * " + r);
                r.getErrors().clear();
                EcoreUtil2.resolveLazyCrossReferences((Resource)r, (CancelIndicator)CancelIndicator.NullImpl);
                for (Resource.Diagnostic d : r.getErrors()) {
                    if (!(d instanceof XtextLinkingDiagnostic)) continue;
                    XtextLinkingDiagnostic x = (XtextLinkingDiagnostic)d;
                    System.err.println("   x " + x.getMessage());
                }
            }
            return ext;
        }

        public String getRootPackageName() {
            CssExtension model = this.getModel();
            if (model != null) {
                return this.getModel().getPackageDef().getName();
            }
            return "error";
        }

        public void invalidate() {
            this.model = null;
        }
    }
}

