/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.fxml;

import javafx.scene.image.Image;
import javafx.util.Builder;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ImageBuilder
implements Builder<Image> {
    private String url = "";
    private double requestedWidth = 0.0;
    private double requestedHeight = 0.0;
    private boolean preserveRatio = false;
    private boolean smooth = false;
    private boolean backgroundLoading = false;

    @NonNull
    public static ImageBuilder create() {
        return new ImageBuilder();
    }

    @NonNull
    public ImageBuilder url(@Nullable String url) {
        this.url = url;
        return this;
    }

    @NonNull
    public ImageBuilder requestedWidth(double requestedWidth) {
        this.requestedWidth = requestedWidth;
        return this;
    }

    @NonNull
    public ImageBuilder requestedHeight(double requestedHeight) {
        this.requestedHeight = requestedHeight;
        return this;
    }

    @NonNull
    public ImageBuilder preserveRatio(boolean preserveRatio) {
        this.preserveRatio = preserveRatio;
        return this;
    }

    @NonNull
    public ImageBuilder smooth(boolean smooth) {
        this.smooth = smooth;
        return this;
    }

    @NonNull
    public ImageBuilder backgroundLoading(boolean backgroundLoading) {
        this.backgroundLoading = backgroundLoading;
        return this;
    }

    @NonNull
    public Image build() {
        return new Image(this.url, this.requestedWidth, this.requestedHeight, this.preserveRatio, this.smooth, this.backgroundLoading);
    }
}

