/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.tree;

import java.util.List;
import java.util.function.Function;
import javafx.beans.binding.Bindings;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;

public class LazyTreeItem<T>
extends TreeItem<T> {
    private boolean hasLoaded;
    private Function<TreeItem<T>, List<TreeItem<T>>> listCreator;

    public LazyTreeItem(T value, Function<TreeItem<T>, List<TreeItem<T>>> listCreator) {
        super(value);
        this.listCreator = listCreator;
        this.getChildren().add((Object)new TreeItem());
        this.expandedProperty().addListener(o -> {
            if (this.isExpanded() && !this.hasLoaded) {
                this.loadItems();
            }
        });
    }

    private void loadItems() {
        List<TreeItem<T>> list = this.listCreator.apply(this);
        if (list instanceof ObservableList) {
            Bindings.unbindContent((Object)this.getChildren(), (Object)((ObservableList)list));
            this.getChildren().clear();
            Bindings.bindContent((List)this.getChildren(), (ObservableList)((ObservableList)list));
        } else {
            this.getChildren().setAll(list);
        }
        this.hasLoaded = true;
    }

    public void refresh() {
        List<TreeItem<T>> list = this.listCreator.apply(this);
        if (list instanceof ObservableList) {
            this.getChildren().clear();
            Bindings.bindContent((List)this.getChildren(), (ObservableList)((ObservableList)list));
        } else {
            this.getChildren().setAll(list);
        }
        this.hasLoaded = true;
    }
}

