/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.internal.databinding.BindingStatus;
import org.eclipse.core.internal.databinding.Util;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

class ValueBinding
extends Binding {
    private final UpdateValueStrategy targetToModel;
    private final UpdateValueStrategy modelToTarget;
    private WritableValue validationStatusObservable;
    private IObservableValue target;
    private IObservableValue model;
    private boolean updatingTarget;
    private boolean updatingModel;
    private IValueChangeListener targetChangeListener = new IValueChangeListener(){

        public void handleValueChange(ValueChangeEvent event) {
            if (!ValueBinding.this.updatingTarget && !Util.equals(event.diff.getOldValue(), event.diff.getNewValue())) {
                ValueBinding.this.doUpdate(ValueBinding.this.target, ValueBinding.this.model, ValueBinding.this.targetToModel, false, false);
            }
        }
    };
    private IValueChangeListener modelChangeListener = new IValueChangeListener(){

        public void handleValueChange(ValueChangeEvent event) {
            if (!ValueBinding.this.updatingModel && !Util.equals(event.diff.getOldValue(), event.diff.getNewValue())) {
                ValueBinding.this.doUpdate(ValueBinding.this.model, ValueBinding.this.target, ValueBinding.this.modelToTarget, false, false);
            }
        }
    };

    public ValueBinding(IObservableValue targetObservableValue, IObservableValue modelObservableValue, UpdateValueStrategy targetToModel, UpdateValueStrategy modelToTarget) {
        super((IObservable)targetObservableValue, (IObservable)modelObservableValue);
        this.target = targetObservableValue;
        this.model = modelObservableValue;
        this.targetToModel = targetToModel;
        this.modelToTarget = modelToTarget;
    }

    @Override
    protected void preInit() {
        ObservableTracker.setIgnore((boolean)true);
        try {
            this.validationStatusObservable = new WritableValue(this.context.getValidationRealm(), (Object)Status.OK_STATUS, IStatus.class);
        }
        finally {
            ObservableTracker.setIgnore((boolean)false);
        }
    }

    @Override
    protected void postInit() {
        if (this.modelToTarget.getUpdatePolicy() == UpdateValueStrategy.POLICY_UPDATE) {
            this.model.addValueChangeListener(this.modelChangeListener);
            this.updateModelToTarget();
        } else if (this.modelToTarget.getUpdatePolicy() == UpdateValueStrategy.POLICY_CONVERT) {
            this.model.addValueChangeListener(this.modelChangeListener);
            this.validateModelToTarget();
        } else {
            this.modelChangeListener = null;
        }
        if (this.targetToModel.getUpdatePolicy() == UpdateValueStrategy.POLICY_UPDATE) {
            this.target.addValueChangeListener(this.targetChangeListener);
            if (this.modelToTarget.getUpdatePolicy() == UpdateValueStrategy.POLICY_NEVER) {
                this.updateTargetToModel();
            } else {
                this.validateTargetToModel();
            }
        } else if (this.targetToModel.getUpdatePolicy() == UpdateValueStrategy.POLICY_CONVERT) {
            this.target.addValueChangeListener(this.targetChangeListener);
            this.validateTargetToModel();
        } else {
            this.targetChangeListener = null;
        }
    }

    @Override
    public IObservableValue getValidationStatus() {
        return this.validationStatusObservable;
    }

    @Override
    public void updateTargetToModel() {
        this.doUpdate(this.target, this.model, this.targetToModel, true, false);
    }

    @Override
    public void updateModelToTarget() {
        this.doUpdate(this.model, this.target, this.modelToTarget, true, false);
    }

    boolean mergeStatus(MultiStatus multiStatus, IStatus newStatus) {
        if (!newStatus.isOK()) {
            multiStatus.add(newStatus);
            return multiStatus.getSeverity() < 4;
        }
        return true;
    }

    private void doUpdate(final IObservableValue source, final IObservableValue destination, final UpdateValueStrategy updateValueStrategy, final boolean explicit, final boolean validateOnly) {
        final int policy = updateValueStrategy.getUpdatePolicy();
        if (policy == UpdateValueStrategy.POLICY_NEVER) {
            return;
        }
        if (policy == UpdateValueStrategy.POLICY_ON_REQUEST && !explicit) {
            return;
        }
        source.getRealm().exec(new Runnable(){

            @Override
            public void run() {
                boolean destinationRealmReached = false;
                final BindingStatus multiStatus = BindingStatus.ok();
                try {
                    Object value = source.getValue();
                    IStatus status = updateValueStrategy.validateAfterGet(value);
                    if (!ValueBinding.this.mergeStatus(multiStatus, status)) {
                        return;
                    }
                    final Object convertedValue = updateValueStrategy.convert(value);
                    status = updateValueStrategy.validateAfterConvert(convertedValue);
                    if (!ValueBinding.this.mergeStatus(multiStatus, status)) {
                        return;
                    }
                    if (policy == UpdateValueStrategy.POLICY_CONVERT && !explicit) {
                        return;
                    }
                    status = updateValueStrategy.validateBeforeSet(convertedValue);
                    if (!ValueBinding.this.mergeStatus(multiStatus, status)) {
                        return;
                    }
                    if (validateOnly) {
                        return;
                    }
                    try {
                        destinationRealmReached = true;
                        destination.getRealm().exec(new Runnable(){

                            @Override
                            public void run() {
                                if (destination == ValueBinding.this.target) {
                                    ValueBinding.this.updatingTarget = true;
                                } else {
                                    ValueBinding.this.updatingModel = true;
                                }
                                try {
                                    IStatus setterStatus = updateValueStrategy.doSet(destination, convertedValue);
                                    ValueBinding.this.mergeStatus(multiStatus, setterStatus);
                                }
                                finally {
                                    if (destination == ValueBinding.this.target) {
                                        ValueBinding.this.updatingTarget = false;
                                    } else {
                                        ValueBinding.this.updatingModel = false;
                                    }
                                    ValueBinding.this.setValidationStatus((IStatus)multiStatus);
                                }
                            }
                        });
                    }
                    catch (Exception ex) {
                        String message = ex.getMessage() != null ? ex.getMessage() : "";
                        ValueBinding.this.mergeStatus(multiStatus, (IStatus)new Status(4, "org.eclipse.core.databinding", 4, message, (Throwable)ex));
                    }
                }
                finally {
                    if (!destinationRealmReached) {
                        ValueBinding.this.setValidationStatus((IStatus)multiStatus);
                    }
                }
            }
        });
    }

    @Override
    public void validateModelToTarget() {
        this.doUpdate(this.model, this.target, this.modelToTarget, true, true);
    }

    @Override
    public void validateTargetToModel() {
        this.doUpdate(this.target, this.model, this.targetToModel, true, true);
    }

    private void setValidationStatus(final IStatus status) {
        this.validationStatusObservable.getRealm().exec(new Runnable(){

            @Override
            public void run() {
                ValueBinding.this.validationStatusObservable.setValue((Object)status);
            }
        });
    }

    @Override
    public void dispose() {
        if (this.targetChangeListener != null) {
            this.target.removeValueChangeListener(this.targetChangeListener);
            this.targetChangeListener = null;
        }
        if (this.modelChangeListener != null) {
            this.model.removeValueChangeListener(this.modelChangeListener);
            this.modelChangeListener = null;
        }
        this.target = null;
        this.model = null;
        super.dispose();
    }
}

