/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.fx;

import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.Pane;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fx.ui.workbench.renderers.base.BaseToolBarRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WToolBar;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WWidget;
import org.eclipse.fx.ui.workbench.renderers.fx.widget.WLayoutedWidgetImpl;

public class DefToolBarRenderer
extends BaseToolBarRenderer<ToolBar> {
    protected Class<? extends WToolBar<ToolBar>> getWidgetClass(MToolBar toolbar) {
        return WToolBarImpl.class;
    }

    public static class WToolBarImpl
    extends WLayoutedWidgetImpl<ToolBar, ToolBar, MToolBar>
    implements WToolBar<ToolBar> {
        private ToggleGroup group;
        private ToolBar toolbar;
        private InvalidationListener orientationSync;

        @Override
        protected ToolBar createWidget() {
            ToolBar b = new ToolBar();
            this.orientationSync = this::syncOrientation;
            b.parentProperty().addListener(this.orientationSync);
            return b;
        }

        private void syncOrientation(Observable o) {
            MToolBar element = (MToolBar)this.getDomElement();
            if (element != null && ((EObject)element).eContainer() instanceof MTrimBar) {
                MTrimBar bar = (MTrimBar)((EObject)element).eContainer();
                switch (bar.getSide()) {
                    case LEFT: 
                    case RIGHT: {
                        ((ToolBar)this.getWidget()).setOrientation(Orientation.VERTICAL);
                        break;
                    }
                    default: {
                        ((ToolBar)this.getWidget()).setOrientation(Orientation.HORIZONTAL);
                    }
                }
            }
        }

        @Override
        protected void doCleanup() {
            super.doCleanup();
            if (this.toolbar != null && this.orientationSync != null) {
                this.toolbar.parentProperty().removeListener(this.orientationSync);
            }
        }

        @Override
        public ToolBar getWidgetNode() {
            return (ToolBar)this.getWidget();
        }

        public void addChild(WWidget<MToolBarElement> itemWidget) {
            if (itemWidget.getWidget() instanceof Toggle) {
                if (this.group == null) {
                    this.group = new ToggleGroup();
                }
                this.group.getToggles().add((Object)((Toggle)itemWidget.getWidget()));
            }
            ((ToolBar)this.getWidget()).getItems().add((Object)((Node)itemWidget.getWidget()));
        }

        public void addChild(int idx, WWidget<MToolBarElement> widget) {
            if (widget.getWidget() instanceof Toggle) {
                if (this.group == null) {
                    this.group = new ToggleGroup();
                }
                this.group.getToggles().add((Object)((Toggle)widget.getWidget()));
            }
            ((ToolBar)this.getWidget()).getItems().add(idx, (Object)((Node)widget.getWidget()));
        }

        public void removeChild(WWidget<MToolBarElement> widget) {
            if (widget.getWidget() instanceof Toggle) {
                ((Toggle)widget.getWidget()).setToggleGroup(null);
            }
            ((ToolBar)this.getWidget()).getItems().remove((Object)((Node)widget.getWidget()));
        }

        @Override
        protected void initDnd(Pane staticLayoutGroup) {
        }
    }
}

