/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.fx;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.fx.ui.panes.FillLayoutPane;
import org.eclipse.fx.ui.workbench.renderers.base.BasePerspectiveRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.services.MaximizationTransitionService;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WLayoutedWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WPerspective;
import org.eclipse.fx.ui.workbench.renderers.fx.widget.WLayoutedWidgetImpl;
import org.eclipse.jdt.annotation.NonNull;

public class DefPerspectiveRenderer
extends BasePerspectiveRenderer<FillLayoutPane> {
    protected Class<? extends WPerspective<FillLayoutPane>> getWidgetClass(MPerspective perspective) {
        return PerspectiveWidgetImpl.class;
    }

    public static class PerspectiveWidgetImpl
    extends WLayoutedWidgetImpl<FillLayoutPane, FillLayoutPane, MPerspective>
    implements WPerspective<FillLayoutPane> {
        private StackPane overlayContainer;
        private FillLayoutPane greyPane;
        private FillLayoutPane maximizationContainer;
        private WLayoutedWidget<? extends MUIElement> maximizedWidget;
        @Inject
        @Optional
        private MaximizationTransitionService<Pane, Region> maximizationTransition;

        @Override
        public FillLayoutPane getWidgetNode() {
            return (FillLayoutPane)this.getWidget();
        }

        @Override
        protected FillLayoutPane createWidget() {
            return new FillLayoutPane();
        }

        public void addItems(List<WLayoutedWidget<MPartSashContainerElement>> list) {
            ArrayList<Node> l = new ArrayList<Node>(list.size());
            for (WLayoutedWidget<MPartSashContainerElement> w : list) {
                l.add((Node)w.getStaticLayoutNode());
            }
            ((FillLayoutPane)this.getWidget()).getChildren().addAll(l);
        }

        public void addItem(int index, WLayoutedWidget<MPartSashContainerElement> widget) {
            ((FillLayoutPane)this.getWidget()).getChildren().add(index, (Object)((Node)widget.getStaticLayoutNode()));
        }

        public void removeItem(WLayoutedWidget<MUIElement> widget) {
            ((FillLayoutPane)this.getWidget()).getChildren().remove(widget.getStaticLayoutNode());
        }

        public void setDialog(Object dialogNode) {
            @NonNull Pane staticLayoutNode = (Pane)this.getStaticLayoutNode();
            if (dialogNode == null) {
                if (this.overlayContainer != null) {
                    staticLayoutNode.getChildren().remove((Object)this.overlayContainer);
                    this.overlayContainer.getChildren().clear();
                }
            } else {
                if (this.overlayContainer == null) {
                    this.overlayContainer = new StackPane();
                    this.overlayContainer.getStyleClass().add((Object)"overlay-container");
                    this.overlayContainer.setManaged(false);
                    this.overlayContainer.setMouseTransparent(false);
                    staticLayoutNode.layoutBoundsProperty().addListener(o -> {
                        staticLayoutNode.layoutBoundsProperty().get();
                        this.overlayContainer.resize(staticLayoutNode.getWidth(), staticLayoutNode.getHeight());
                    });
                }
                this.overlayContainer.resize(staticLayoutNode.getWidth(), staticLayoutNode.getHeight());
                this.overlayContainer.getChildren().setAll((Object[])new Node[]{(Node)dialogNode});
                staticLayoutNode.getChildren().add((Object)this.overlayContainer);
            }
        }

        public void setMaximizedContent(WLayoutedWidget<? extends MUIElement> widget) {
            if (this.maximizedWidget != null) {
                return;
            }
            WLayoutedWidget<? extends MUIElement> childWidget = widget;
            Pane staticLayoutNode = (Pane)this.getStaticLayoutNode();
            this.maximizedWidget = widget;
            FillLayoutPane maximizationContainer = new FillLayoutPane();
            FillLayoutPane greyPane = new FillLayoutPane();
            greyPane.getStyleClass().add((Object)"maximization-container");
            greyPane.setOpacity(0.0);
            int size = staticLayoutNode.getChildren().size();
            if (this.overlayContainer == staticLayoutNode.getChildren().get(size - 1)) {
                staticLayoutNode.getChildren().add(size - 1, (Object)greyPane);
                staticLayoutNode.getChildren().add(size, (Object)maximizationContainer);
            } else {
                staticLayoutNode.getChildren().add((Object)greyPane);
                staticLayoutNode.getChildren().add((Object)maximizationContainer);
            }
            Runnable finisher = () -> {
                staticLayoutNode.getChildren().stream().forEach(n -> n.setVisible(false));
                maximizationContainer.setVisible(true);
                maximizationContainer.getChildren().clear();
                maximizationContainer.getChildren().add((Object)((Region)childWidget.getWidgetNode()));
                greyPane.setOpacity(1.0);
                this.maximizationContainer = maximizationContainer;
                this.greyPane = greyPane;
            };
            if (this.maximizationTransition != null) {
                this.maximizationTransition.maximize((Object)((Pane)this.getWidget()), (Object)greyPane, (Object)maximizationContainer, (Object)((Region)childWidget.getWidgetNode()), finisher);
            } else {
                finisher.run();
            }
        }

        public void removeMaximizedContent() {
            if (this.maximizationContainer != null) {
                Pane staticLayoutNode = (Pane)this.getStaticLayoutNode();
                Pane childStaticNode = (Pane)this.maximizedWidget.getStaticLayoutNode();
                Region childPane = (Region)this.maximizedWidget.getWidgetNode();
                FillLayoutPane maximizationContainer = this.maximizationContainer;
                FillLayoutPane greyPane = this.greyPane;
                this.maximizationContainer = null;
                this.maximizedWidget = null;
                Runnable finisher = () -> {
                    staticLayoutNode.getChildren().remove((Object)greyPane);
                    staticLayoutNode.getChildren().remove((Object)maximizationContainer);
                    childStaticNode.getChildren().add((Object)childPane);
                    staticLayoutNode.getChildren().stream().forEach(n -> n.setVisible(true));
                };
                if (this.maximizationTransition != null) {
                    this.maximizationTransition.restore((Object)staticLayoutNode, (Object)greyPane, (Object)maximizationContainer, (Object)childStaticNode, (Object)childPane, finisher);
                } else {
                    finisher.run();
                }
            }
        }
    }
}

