/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.fx.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.fx.core.URI;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.core.log.LoggerFactory;
import org.eclipse.fx.ui.services.resources.GraphicNodeProvider;
import org.eclipse.fx.ui.services.resources.GraphicsLoader;
import org.eclipse.fx.ui.services.resources.ImageProvider;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={ProviderComponent.class})
public class ProviderComponent {
    private Map<String, Set<RankedEntry<ImageProvider>>> imageProviderBySuffix = new HashMap<String, Set<RankedEntry<ImageProvider>>>();
    private Map<String, ImageProvider> imageProviderByName = new HashMap<String, ImageProvider>();
    private Map<String, Set<RankedEntry<GraphicNodeProvider>>> graphicProviderBySuffix = new HashMap<String, Set<RankedEntry<GraphicNodeProvider>>>();
    private Map<String, GraphicNodeProvider> graphicProviderByName = new HashMap<String, GraphicNodeProvider>();
    private LoggerFactory loggerFactory;
    private Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY)
    public void addImageProvider(ImageProvider provider, Map<String, Object> parameters) {
        Map<String, Set<RankedEntry<ImageProvider>>> map = this.imageProviderBySuffix;
        synchronized (map) {
            for (String suffix : provider.getFileSuffix()) {
                Integer ranking;
                Set<RankedEntry<ImageProvider>> set = this.imageProviderBySuffix.get(suffix);
                if (set == null) {
                    set = new TreeSet<RankedEntry<ImageProvider>>();
                    this.imageProviderBySuffix.put(suffix, set);
                }
                if ((ranking = (Integer)parameters.get("service.ranking")) == null) {
                    ranking = 0;
                }
                set.add(new RankedEntry<ImageProvider>(ranking, provider));
            }
        }
        map = this.imageProviderByName;
        synchronized (map) {
            ImageProvider p = this.imageProviderByName.put(provider.getName(), provider);
            if (p != null) {
                this.getLogger().warning("Replaced existing provider '" + String.valueOf(p) + "' named '" + provider.getName() + "' through new provider '" + String.valueOf(provider) + "'");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImageProvider(ImageProvider provider) {
        Map<String, Set<RankedEntry<ImageProvider>>> map = this.imageProviderBySuffix;
        synchronized (map) {
            for (Set<RankedEntry<ImageProvider>> set : this.imageProviderBySuffix.values()) {
                Iterator<RankedEntry<ImageProvider>> it = set.iterator();
                if (it.next().provider != provider) continue;
                it.remove();
            }
        }
        map = this.imageProviderByName;
        synchronized (map) {
            this.imageProviderByName.values().remove(provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY)
    public void addGraphicNodeProvider(GraphicNodeProvider provider, Map<String, Object> parameters) {
        Map<String, Set<RankedEntry<GraphicNodeProvider>>> map = this.graphicProviderBySuffix;
        synchronized (map) {
            for (String suffix : provider.getFileSuffix()) {
                Integer ranking;
                Set<RankedEntry<GraphicNodeProvider>> set = this.graphicProviderBySuffix.get(suffix);
                if (set == null) {
                    set = new TreeSet<RankedEntry<GraphicNodeProvider>>();
                    this.graphicProviderBySuffix.put(suffix, set);
                }
                if ((ranking = (Integer)parameters.get("service.ranking")) == null) {
                    ranking = 0;
                }
                set.add(new RankedEntry<GraphicNodeProvider>(ranking, provider));
            }
        }
        map = this.graphicProviderByName;
        synchronized (map) {
            GraphicNodeProvider p = this.graphicProviderByName.put(provider.getName(), provider);
            if (p != null) {
                this.getLogger().warning("Replaced existing provider '" + String.valueOf(p) + "' named '" + provider.getName() + "' through new provider '" + String.valueOf(provider) + "'");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGraphicNodeProvider(GraphicNodeProvider provider) {
        Map<String, Set<RankedEntry<GraphicNodeProvider>>> map = this.graphicProviderBySuffix;
        synchronized (map) {
            for (Set<RankedEntry<GraphicNodeProvider>> set : this.graphicProviderBySuffix.values()) {
                Iterator<RankedEntry<GraphicNodeProvider>> it = set.iterator();
                while (it.hasNext()) {
                    if (it.next().provider != provider) continue;
                    it.remove();
                }
            }
        }
        map = this.graphicProviderByName;
        synchronized (map) {
            this.graphicProviderByName.values().remove(provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable GraphicNodeProvider getGraphicNodeProvider(URI uri) {
        String s;
        String provider;
        if (uri.hasQuery() && (provider = GraphicsLoader.Util.getQueryValue((URI)uri, (String)"providerName")) != null) {
            GraphicNodeProvider pv;
            Map<String, GraphicNodeProvider> map = this.graphicProviderByName;
            synchronized (map) {
                pv = this.graphicProviderByName.get(provider);
            }
            if (pv != null) {
                return pv;
            }
        }
        if ((s = GraphicsLoader.Util.suffix((URI)uri)) != null) {
            Map<String, Set<RankedEntry<GraphicNodeProvider>>> map = this.graphicProviderBySuffix;
            synchronized (map) {
                Set<RankedEntry<GraphicNodeProvider>> set = this.graphicProviderBySuffix.get(s);
                if (set != null && !set.isEmpty()) {
                    return (GraphicNodeProvider)set.iterator().next().provider;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable ImageProvider getImageProvider(URI uri) {
        String s;
        String provider;
        if (uri.hasQuery() && (provider = GraphicsLoader.Util.getQueryValue((URI)uri, (String)"providerName")) != null) {
            ImageProvider pv;
            Map<String, ImageProvider> map = this.imageProviderByName;
            synchronized (map) {
                pv = this.imageProviderByName.get(provider);
            }
            if (pv == null) {
                this.getLogger().error("No provider named '" + provider + "' available. Falling back to suffix provider URI '" + uri.toString() + "'");
            } else {
                return pv;
            }
        }
        if ((s = GraphicsLoader.Util.suffix((URI)uri)) == null) {
            s = "*";
        }
        Map<String, Set<RankedEntry<ImageProvider>>> map = this.imageProviderBySuffix;
        synchronized (map) {
            Set<RankedEntry<ImageProvider>> set = this.imageProviderBySuffix.get(s);
            if (set != null && !set.isEmpty()) {
                return (ImageProvider)set.iterator().next().provider;
            }
            this.getLogger().warning("No image provider found for URI: '" + uri.toString() + "'");
            set = this.imageProviderBySuffix.get("*");
            if (!set.isEmpty()) {
                return (ImageProvider)set.iterator().next().provider;
            }
            this.getLogger().error("No default provider available");
        }
        return null;
    }

    private synchronized Logger getLogger() {
        if (this.logger == null && this.loggerFactory != null) {
            this.logger = this.loggerFactory.createLogger(this.getClass().getName());
        }
        return this.logger;
    }

    @Reference
    public synchronized void setLoggerFactory(LoggerFactory factory) {
        this.loggerFactory = factory;
        if (this.logger != null) {
            this.logger = null;
        }
    }

    public void unsetLoggerFactory(LoggerFactory factory) {
        if (this.loggerFactory == factory) {
            this.loggerFactory = null;
        }
    }

    static class RankedEntry<E>
    implements Comparable<RankedEntry<E>> {
        public final int ranking;
        public final E provider;

        public RankedEntry(int ranking, E provider) {
            this.ranking = ranking;
            this.provider = provider;
        }

        @Override
        public int compareTo(RankedEntry<E> o) {
            int rv = Integer.compare(this.ranking, o.ranking);
            return rv == 0 ? 1 : rv;
        }
    }
}

